/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.jute;

import com.cloudera.hive.jdbc42.internal.apache.jute.OutputArchive;
import com.cloudera.hive.jdbc42.internal.apache.jute.Record;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;

public class ToStringOutputArchive
implements OutputArchive {
    private PrintStream stream;
    private boolean isFirst = true;
    private long dataSize;

    private void throwExceptionOnError(String tag) throws IOException {
        if (this.stream.checkError()) {
            throw new IOException("Error serializing " + tag);
        }
    }

    private void printCommaUnlessFirst() {
        if (!this.isFirst) {
            this.stream.print(",");
            ++this.dataSize;
        }
        this.isFirst = false;
    }

    public ToStringOutputArchive(OutputStream out) throws UnsupportedEncodingException {
        this.stream = new PrintStream(out, true, "UTF-8");
    }

    @Override
    public void writeByte(byte b, String tag) throws IOException {
        this.writeLong(b, tag);
    }

    @Override
    public void writeBool(boolean b, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String val = b ? "T" : "F";
        this.stream.print(val);
        ++this.dataSize;
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeInt(int i, String tag) throws IOException {
        this.writeLong(i, tag);
    }

    @Override
    public void writeLong(long l, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String strValue = String.valueOf(l);
        this.stream.print(strValue);
        this.dataSize += (long)strValue.length();
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeFloat(float f, String tag) throws IOException {
        this.writeDouble(f, tag);
    }

    @Override
    public void writeDouble(double d, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String strValue = String.valueOf(d);
        this.stream.print(strValue);
        this.dataSize += (long)strValue.length();
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeString(String s, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String strValue = ToStringOutputArchive.escapeString(s);
        this.stream.print(strValue);
        this.dataSize += (long)strValue.length();
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeBuffer(byte[] buf, String tag) throws IOException {
        this.printCommaUnlessFirst();
        String strValue = ToStringOutputArchive.escapeBuffer(buf);
        this.stream.print(strValue);
        this.dataSize += (long)strValue.length();
        this.throwExceptionOnError(tag);
    }

    @Override
    public void writeRecord(Record r, String tag) throws IOException {
        if (r == null) {
            return;
        }
        r.serialize(this, tag);
    }

    @Override
    public void startRecord(Record r, String tag) throws IOException {
        if (tag != null && !"".equals(tag)) {
            this.printCommaUnlessFirst();
            this.stream.print("s{");
            this.dataSize += 2L;
            this.isFirst = true;
        }
    }

    @Override
    public void endRecord(Record r, String tag) throws IOException {
        if (tag == null || "".equals(tag)) {
            this.stream.print("\n");
            ++this.dataSize;
            this.isFirst = true;
        } else {
            this.stream.print("}");
            ++this.dataSize;
            this.isFirst = false;
        }
    }

    @Override
    public void startVector(List<?> v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("v{");
        this.dataSize += 2L;
        this.isFirst = true;
    }

    @Override
    public void endVector(List<?> v, String tag) throws IOException {
        this.stream.print("}");
        ++this.dataSize;
        this.isFirst = false;
    }

    @Override
    public void startMap(TreeMap<?, ?> v, String tag) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("m{");
        this.dataSize += 2L;
        this.isFirst = true;
    }

    @Override
    public void endMap(TreeMap<?, ?> v, String tag) throws IOException {
        this.stream.print("}");
        ++this.dataSize;
        this.isFirst = false;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    private static String escapeString(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append('\'');
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("%00");
                    continue block8;
                }
                case '\n': {
                    sb.append("%0A");
                    continue block8;
                }
                case '\r': {
                    sb.append("%0D");
                    continue block8;
                }
                case ',': {
                    sb.append("%2C");
                    continue block8;
                }
                case '}': {
                    sb.append("%7D");
                    continue block8;
                }
                case '%': {
                    sb.append("%25");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeBuffer(byte[] barr) {
        if (barr == null || barr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(barr.length + 1);
        sb.append('#');
        for (byte b : barr) {
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }
}

