/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.util;

import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.Logger;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.util.AuthorizationProvider;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.core.util.PasswordDecryptor;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.util.LoaderUtil;
import com.cloudera.hive.jdbc42.internal.apache.logging.log4j.util.PropertiesUtil;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    private static final String[] PREFIXES = new String[]{"log4j2.config.", "log4j2.Configuration.", "logging.auth."};
    private static final String AUTH_USER_NAME = "username";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_PASSWORD_DECRYPTOR = "passwordDecryptor";
    public static final String CONFIG_USER_NAME = "log4j2.configurationUserName";
    public static final String CONFIG_PASSWORD = "log4j2.configurationPassword";
    public static final String PASSWORD_DECRYPTOR = "log4j2.passwordDecryptor";
    private static final String BASIC_AUTH_ENCODING = "log4j2.configurationAuthorizationEncoding";
    private static final String SPRING_BASIC_AUTH_ENCODING = "logging.auth.encoding";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private String authString = null;

    public BasicAuthorizationProvider(PropertiesUtil props) {
        String userName = props.getStringProperty(PREFIXES, AUTH_USER_NAME, () -> props.getStringProperty(CONFIG_USER_NAME));
        String password = props.getStringProperty(PREFIXES, AUTH_PASSWORD, () -> props.getStringProperty(CONFIG_PASSWORD));
        String decryptor = props.getStringProperty(PREFIXES, AUTH_PASSWORD_DECRYPTOR, () -> props.getStringProperty(PASSWORD_DECRYPTOR));
        Charset passwordCharset = props.getCharsetProperty(BASIC_AUTH_ENCODING);
        if (passwordCharset == null) {
            props.getCharsetProperty(SPRING_BASIC_AUTH_ENCODING, StandardCharsets.UTF_8);
        }
        if (decryptor != null) {
            try {
                Object obj = LoaderUtil.newInstanceOf(decryptor);
                if (obj instanceof PasswordDecryptor) {
                    password = ((PasswordDecryptor)obj).decryptPassword(password);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to decrypt password.", (Throwable)ex);
            }
        }
        if (userName != null && password != null) {
            this.authString = "Basic " + Base64.getEncoder().encodeToString((userName + ":" + password).getBytes(passwordCharset));
        }
    }

    @Override
    public void addAuthorization(URLConnection urlConnection) {
        if (this.authString != null) {
            urlConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

