/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.thrift.transport;

import com.cloudera.hive.jdbc42.internal.apache.thrift.TException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TProcessor;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocolFactory;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TFileTransport;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;

public class TFileProcessor {
    private TProcessor processor_;
    private TProtocolFactory inputProtocolFactory_;
    private TProtocolFactory outputProtocolFactory_;
    private TFileTransport inputTransport_;
    private TTransport outputTransport_;

    public TFileProcessor(TProcessor processor, TProtocolFactory protocolFactory, TFileTransport inputTransport, TTransport outputTransport) {
        this.processor_ = processor;
        this.inputProtocolFactory_ = this.outputProtocolFactory_ = protocolFactory;
        this.inputTransport_ = inputTransport;
        this.outputTransport_ = outputTransport;
    }

    public TFileProcessor(TProcessor processor, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, TFileTransport inputTransport, TTransport outputTransport) {
        this.processor_ = processor;
        this.inputProtocolFactory_ = inputProtocolFactory;
        this.outputProtocolFactory_ = outputProtocolFactory;
        this.inputTransport_ = inputTransport;
        this.outputTransport_ = outputTransport;
    }

    private void processUntil(int lastChunk) throws TException {
        TProtocol ip = this.inputProtocolFactory_.getProtocol(this.inputTransport_);
        TProtocol op = this.outputProtocolFactory_.getProtocol(this.outputTransport_);
        int curChunk = this.inputTransport_.getCurChunk();
        try {
            while (lastChunk >= curChunk) {
                int newChunk;
                this.processor_.process(ip, op);
                curChunk = newChunk = this.inputTransport_.getCurChunk();
            }
        }
        catch (TTransportException e) {
            if (e.getType() != 4) {
                throw e;
            }
            return;
        }
    }

    public void processChunk(int startChunkNum, int endChunkNum) throws TException {
        int numChunks = this.inputTransport_.getNumChunks();
        if (endChunkNum < 0) {
            endChunkNum += numChunks;
        }
        if (startChunkNum < 0) {
            startChunkNum += numChunks;
        }
        if (endChunkNum < startChunkNum) {
            throw new TException("endChunkNum " + endChunkNum + " is less than " + startChunkNum);
        }
        this.inputTransport_.seekToChunk(startChunkNum);
        this.processUntil(endChunkNum);
    }

    public void processChunk(int chunkNum) throws TException {
        this.processChunk(chunkNum, chunkNum);
    }

    public void processChunk() throws TException {
        this.processChunk(this.inputTransport_.getCurChunk());
    }
}

