/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.commons.cli.CommandLine;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.DefaultParser;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.Options;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.ParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Quotas;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.StatsTrack;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ZooKeeper;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliWrapperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedPathException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Stat;
import java.util.ArrayList;
import java.util.List;

public class ListQuotaCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public ListQuotaCommand() {
        super("listquota", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String absolutePath = Quotas.limitPath(path);
        try {
            this.err.println("absolute path is " + absolutePath);
            List<StatsTrack> statsTracks = ListQuotaCommand.listQuota(this.zk, path);
            for (int i = 0; i < statsTracks.size(); ++i) {
                StatsTrack st = statsTracks.get(i);
                if (i == 0) {
                    this.out.println("Output quota for " + path + " " + st.toString());
                    continue;
                }
                this.out.println("Output stat for " + path + " " + st.toString());
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException.NoNodeException ne) {
            this.err.println("quota for " + path + " does not exist.");
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    public static List<StatsTrack> listQuota(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        ArrayList<StatsTrack> statsTracks = new ArrayList<StatsTrack>();
        Stat stat = new Stat();
        byte[] data = zk.getData(Quotas.limitPath(path), false, stat);
        StatsTrack st = new StatsTrack(data);
        statsTracks.add(st);
        data = zk.getData(Quotas.statPath(path), false, stat);
        st = new StatsTrack(data);
        statsTracks.add(st);
        return statsTracks;
    }
}

