/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.commons.cli.CommandLine;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.DefaultParser;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.Options;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.ParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliWrapperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedPathException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.StatPrinter;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.Stat;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetCommand() {
        super("set", "path data [-s] [-v version] [-b]", options);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        byte[] data = this.cl.hasOption("b") ? Base64.getDecoder().decode(this.args[2]) : this.args[2].getBytes(StandardCharsets.UTF_8);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setData(path, data, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("s", false, "Print znode stats additionally");
        options.addOption("v", true, "Set with an expected version");
        options.addOption("b", false, "Supply data in base64 format");
    }
}

