/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.metrics.impl;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.metrics.MetricsProvider;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.metrics.MetricsProviderLifeCycleException;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public abstract class MetricsProviderBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsProviderBootstrap.class);

    public static MetricsProvider startMetricsProvider(String metricsProviderClassName, Properties configuration) throws MetricsProviderLifeCycleException {
        try {
            Class<?> clazz = Class.forName(metricsProviderClassName, true, Thread.currentThread().getContextClassLoader());
            MetricsProvider metricsProvider = (MetricsProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            metricsProvider.configure(configuration);
            metricsProvider.start();
            return metricsProvider;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            LOG.error("Cannot boot MetricsProvider {}", (Object)metricsProviderClassName, (Object)error);
            throw new MetricsProviderLifeCycleException("Cannot boot MetricsProvider " + metricsProviderClassName, error);
        }
        catch (MetricsProviderLifeCycleException error) {
            LOG.error("Cannot boot MetricsProvider {}", (Object)metricsProviderClassName, (Object)error);
            throw error;
        }
    }
}

