/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server;

import com.cloudera.hive.jdbc42.internal.apache.jute.BinaryOutputArchive;
import com.cloudera.hive.jdbc42.internal.apache.jute.Record;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class ByteBufferOutputStream
extends OutputStream {
    private final ByteBuffer bb;

    public ByteBufferOutputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public void write(int b) throws IOException {
        this.bb.put((byte)b);
    }

    @Override
    public void write(@Nonnull byte[] b) throws IOException {
        this.bb.put(b);
    }

    @Override
    public void write(@Nonnull byte[] b, int off, int len) throws IOException {
        this.bb.put(b, off, len);
    }

    public static void record2ByteBuffer(Record record, ByteBuffer bb) throws IOException {
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive(new ByteBufferOutputStream(bb));
        record.serialize(oa, "request");
    }
}

