/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server;

import com.cloudera.hive.jdbc42.internal.apache.jute.BinaryOutputArchive;
import com.cloudera.hive.jdbc42.internal.apache.jute.Record;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.RequestRecord;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

public class SimpleRequestRecord
implements RequestRecord {
    private final Record record;
    private volatile byte[] bytes;

    public SimpleRequestRecord(Record record) {
        this.record = record;
    }

    @Override
    public <T extends Record> T readRecord(Supplier<T> constructor) {
        return (T)this.record;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] readBytes() {
        byte[] byArray;
        if (this.bytes != null) {
            return this.bytes;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            this.record.serialize(boa, "request");
            byArray = this.bytes = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        baos.close();
        return byArray;
    }

    @Override
    public int limit() {
        byte[] bytes = this.readBytes();
        return ByteBuffer.wrap(bytes).limit();
    }
}

