/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin.CommandOutputter;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin.CommandResponse;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.core.JsonGenerationException;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.JsonMappingException;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.SerializationFeature;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;

public class JsonOutputter
implements CommandOutputter {
    static final Logger LOG = LoggerFactory.getLogger(JsonOutputter.class);
    public static final String ERROR_RESPONSE = "{\"error\": \"Exception writing command response to JSON\"}";
    private ObjectMapper mapper = new ObjectMapper();
    private final String clientIP;

    public JsonOutputter(String clientIP) {
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.clientIP = clientIP;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public void output(CommandResponse response, PrintWriter pw) {
        try {
            this.mapper.writeValue(pw, response.toMap());
        }
        catch (JsonGenerationException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (JsonMappingException e) {
            LOG.warn("Exception writing command response to JSON:", e);
            pw.write(ERROR_RESPONSE);
        }
        catch (IOException e) {
            LOG.warn("Exception writing command response as JSON to {}", (Object)this.clientIP, (Object)e);
            pw.write(ERROR_RESPONSE);
        }
    }
}

