/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.proto.ReplyHeader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ZooKeeperCriticalThread;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ZooTrace;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class ReadOnlyRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRequestProcessor.class);
    private final LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private volatile boolean finished = false;
    private final RequestProcessor nextProcessor;
    private final ZooKeeperServer zks;

    public ReadOnlyRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ReadOnlyRequestProcessor:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public void run() {
        try {
            block6: while (!this.finished) {
                Request request = this.queuedRequests.take();
                if (LOG.isTraceEnabled()) {
                    long traceMask = 2L;
                    if (request.type == 11) {
                        traceMask = 8L;
                    }
                    ZooTrace.logRequest(LOG, traceMask, 'R', request, "");
                }
                if (Request.requestOfDeath != request) {
                    switch (request.type) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: 
                        case 21: {
                            this.sendErrorResponse(request);
                            continue block6;
                        }
                        case -11: 
                        case -10: {
                            if (request.isLocalSession()) break;
                            this.sendErrorResponse(request);
                            continue block6;
                        }
                    }
                    if (this.nextProcessor == null) continue;
                    this.nextProcessor.processRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleException(this.getName(), e);
        }
        LOG.info("ReadOnlyRequestProcessor exited loop!");
    }

    private void sendErrorResponse(Request request) {
        ReplyHeader hdr = new ReplyHeader(request.cxid, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), KeeperException.Code.NOTREADONLY.intValue());
        try {
            request.cnxn.sendResponse(hdr, null, null);
        }
        catch (IOException e) {
            LOG.error("IO exception while sending response", e);
        }
    }

    @Override
    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

