/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.io.netty.handler.address;

import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandler;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandlerContext;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelPromise;
import com.cloudera.hive.jdbc42.internal.io.netty.resolver.AddressResolver;
import com.cloudera.hive.jdbc42.internal.io.netty.resolver.AddressResolverGroup;
import com.cloudera.hive.jdbc42.internal.io.netty.util.concurrent.Future;
import com.cloudera.hive.jdbc42.internal.io.netty.util.concurrent.FutureListener;
import com.cloudera.hive.jdbc42.internal.io.netty.util.concurrent.GenericFutureListener;
import com.cloudera.hive.jdbc42.internal.io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = (AddressResolverGroup)ObjectUtil.checkNotNull(resolverGroup, (String)"resolverGroup");
    }

    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener)new FutureListener<SocketAddress>(){

                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect((SocketAddress)future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove((ChannelHandler)ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

