/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.string;

import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBuf;
import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBufAllocator;
import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBufUtil;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandler;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandlerContext;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.MessageToMessageEncoder;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.string.LineSeparator;
import com.cloudera.hive.jdbc42.internal.io.netty.util.CharsetUtil;
import com.cloudera.hive.jdbc42.internal.io.netty.util.internal.ObjectUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, CharsetUtil.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, CharsetUtil.UTF_8);
    }

    public LineEncoder(Charset charset) {
        this(LineSeparator.DEFAULT, charset);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset) {
        this.charset = (Charset)ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.lineSeparator = ((LineSeparator)ObjectUtil.checkNotNull((Object)lineSeparator, (String)"lineSeparator")).value().getBytes(charset);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        ByteBuf buffer = ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)CharBuffer.wrap(msg), (Charset)this.charset, (int)this.lineSeparator.length);
        buffer.writeBytes(this.lineSeparator);
        out.add(buffer);
    }
}

