/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hive.api;

import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TBinaryProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TSocket;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransport;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver1.hive.api.HS1Client;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.HiveServerType;
import com.cloudera.hiveserver1.hivecommon.ServiceDiscoveryMode;
import com.cloudera.hiveserver1.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver1.hivecommon.api.IHiveClientFactory;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class HiveServer1ClientFactory
implements IHiveClientFactory {
    @Override
    public IHiveClient createClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        hiveJDBCSettings.m_hiveServerType = HiveServerType.HiveServer1;
        try {
            TSocket tSocket = new TSocket(hiveJDBCSettings.m_host, hiveJDBCSettings.m_port, hiveJDBCSettings.m_timeout);
            ((TTransport)tSocket).open();
            return new HS1Client(hiveJDBCSettings, new TBinaryProtocol(tSocket), iLogger, iWarningListener);
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), tTransportException.getMessage());
            errorException.initCause(tTransportException);
            throw errorException;
        }
    }

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        return false;
    }
}

