/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnValue;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TDmlResult;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchOrientation;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCrossReferenceResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoType;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetPrimaryKeysResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TNamespace;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationState;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowResultLink;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkGetDirectResults;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkParameter;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkRowSetType;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TStatus;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TStatusCode;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeEntry;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeId;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TTypeQualifiers;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TApplicationException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TBase;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver1.dsi.exceptions.OperationCanceledException;
import com.cloudera.hiveserver1.hivecommon.AuthMech;
import com.cloudera.hiveserver1.hivecommon.DatabaseMetadataInfo;
import com.cloudera.hiveserver1.hivecommon.DownloadableResultSettings;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.TransportMode;
import com.cloudera.hiveserver1.hivecommon.api.CurrentBufferContext;
import com.cloudera.hiveserver1.hivecommon.api.DataTypeUtilities;
import com.cloudera.hiveserver1.hivecommon.api.HS2Buffer;
import com.cloudera.hiveserver1.hivecommon.api.HS2ClientWrapper;
import com.cloudera.hiveserver1.hivecommon.api.HS2ClientWrapperTester;
import com.cloudera.hiveserver1.hivecommon.api.HS2OAuthClientWrapper;
import com.cloudera.hiveserver1.hivecommon.api.HS2SSOSAMLClientWrapper;
import com.cloudera.hiveserver1.hivecommon.api.HS2v6Buffer;
import com.cloudera.hiveserver1.hivecommon.api.HiveCatalogContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveClientBase;
import com.cloudera.hiveserver1.hivecommon.api.HiveColumnContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveExecutionContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveForeignKeyContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver1.hivecommon.api.HivePrimaryKeyContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveSchemaContext;
import com.cloudera.hiveserver1.hivecommon.api.HiveServer2BaseBuffer;
import com.cloudera.hiveserver1.hivecommon.api.HiveTableContext;
import com.cloudera.hiveserver1.hivecommon.api.IExecutorUtility;
import com.cloudera.hiveserver1.hivecommon.api.RowsetBuffer;
import com.cloudera.hiveserver1.hivecommon.core.CoreUtils;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver1.hivecommon.core.QueryProfile;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.hiveserver1.hivecommon.dataengine.HiveJDBCPlaceholderTable;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonColumnMetadata;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonFunctionsMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonSchemasMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.hivecommon.exceptions.TETokenExpirationException;
import com.cloudera.hiveserver1.hivecommon.utils.HeartBeatThread;
import com.cloudera.hiveserver1.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.utils.HivePkFkAPINotSupportedException;
import com.cloudera.hiveserver1.jdbc.utils.WarningsUtils;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.exceptions.ExceptionType;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HS2Client
extends HiveClientBase<HiveServer2BaseBuffer> {
    public HiveJDBCSettings m_settings;
    private static final String CLIENT_PROTOCOL_ERR_KEYWORD = "PROTOCOL";
    private static final String NO_ERROR_MESSAGE_FROM_SERVER = "No error message available from the server";
    private static final String SHOW_DATABASES_STRING = "SHOW DATABASES";
    private static final int SHOW_DATABASES_RESULT_COLUM_IDX = 0;
    private static final String SHARK_REGEX = ".*[Ss][Hh][Aa][Rr][Kk][Ss][Ee][Rr][Vv][Ee][Rr].*";
    private static final Pattern SHARK_HIVE_VERSION = Pattern.compile("(.*)-shark-(.*)");
    private static final String SET_DASH_V_QUERY_STRING = "set -v";
    private static final int SET_DASH_V_RESULT_COLUM_IDX = 0;
    private static final String SET_CASE = "SET";
    private static final String SPARK_SERVER_NAME = "Spark";
    private static final String SPARK_LIVY_SERVER_NAME = "Livy JDBC";
    private static final String SPARK_LIVY_DEFAULT_SPARK_VERSION_STR = "2.4.0";
    private static final Map<String, String> HIVE_SPARK_VERSION_MAP;
    private static final int CATALOGS_MD_RS_NAME_IDX = 0;
    private static final int COLS_MD_RS_CATALOG_NAME_IDX = 0;
    private static final int COLS_MD_RS_SCHEMA_NAME_IDX = 1;
    private static final int COLS_MD_RS_TABLE_NAME_IDX = 2;
    private static final int COLS_MD_RS_COLUMN_NAME_IDX = 3;
    private static final int COLS_MD_RS_TYPE_NAME_IDX = 5;
    private static final int COLS_MD_RS_NULLABLE_IDX = 10;
    private static final int COLS_MD_RS_REMARKS_IDX = 11;
    private static final int TABLES_MD_RS_CATALOG_IDX = 0;
    private static final int TABLES_MD_RS_SCHEMA_IDX = 1;
    private static final int TABLES_MD_RS_NAME_IDX = 2;
    private static final int TABLES_MD_RS_TYPE_IDX = 3;
    private static final int TABLES_MD_RS_COMMENT_IDX = 4;
    private static final int FUNCTIONS_MD_RS_CATALOG_IDX = 0;
    private static final int FUNCTIONS_MD_RS_SCHEMA_IDX = 1;
    private static final int FUNCTIONS_MD_RS_NAME_IDX = 2;
    private static final int FUNCTIONS_MD_RS_COMMENT_IDX = 3;
    private static final int FUNCTIONS_MD_RS_TYPE_IDX = 4;
    private static final int FUNCTIONS_MD_RS_SPECIFIC_NAME_IDX = 5;
    private static final int SCHEMA_MD_RS_SCHEMA_IDX = 0;
    private static final int SCHEMA_MD_RS_CATALOG_IDX = 1;
    private static final String IMPALA_SERVER_NAME = "Impala";
    private static final int FILTER_CATALOG_RESTRICTION_IDX = 0;
    private static final int FILTER_SCHEMA_RESTRICTION_IDX = 1;
    private static final int FILTER_TABLE_RESTRICTION_IDX = 2;
    private static final int FILTER_COLUMN_RESTRICTION_IDX = 3;
    private static final int FILTER_FUNCTION_RESTRICTION_IDX = 4;
    private static final int GET_INFOS_SERVER_NAME_IDX = 0;
    private static final int GET_INFOS_DBMS_VER_IDX = 1;
    private static final int PK_CATALOG_RESTRICTION_IDX = 0;
    private static final int PK_SCHEMA_RESTRICTION_IDX = 1;
    private static final int PK_TABLE_RESTRICTION_IDX = 2;
    private static final int FK_CATALOG_RESTRICTION_IDX = 3;
    private static final int FK_SCHEMA_RESTRICTION_IDX = 4;
    private static final int FK_TABLE_RESTRICTION_IDX = 5;
    private static final String TBL_TYPE_TABLE = "TABLE";
    private static final int EXPECTED_SQLSTATE_STR_LEN = 5;
    private static final short GET_QUERY_LOG_FETCH_TYPE = 1;
    private static final TProtocolVersion DEFAULT_HIVE_CLI_SERVICE_PROTOCOL;
    private boolean m_hasOpenSession;
    protected ILogger m_logger;
    private DatabaseMetadataInfo dbmdInfo;
    private HS2ClientWrapper m_client;
    private TOpenSessionResp m_openSessionResp;
    private IWarningListener m_warningListener;
    private HeartBeatThread m_heartBeatThread;
    private boolean m_enableDirectResults = false;
    private boolean m_enableArrow = false;

    public HS2Client(HiveJDBCSettings hiveJDBCSettings, TProtocol tProtocol, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        this.m_settings = hiveJDBCSettings;
        this.m_client = AuthMech.OAUTH_2 == this.m_settings.m_authMech ? this.fetchOauthClientWrapper(tProtocol, iLogger) : (AuthMech.SAML_2_0 == this.m_settings.m_authMech ? new HS2SSOSAMLClientWrapper(tProtocol, iLogger, hiveJDBCSettings) : new HS2ClientWrapper(tProtocol, iLogger, hiveJDBCSettings));
        if (hiveJDBCSettings.m_enableErrorEmulation.booleanValue()) {
            this.m_client = new HS2ClientWrapperTester(tProtocol, iLogger, hiveJDBCSettings.m_thriftHTTPSettings, this.m_client, hiveJDBCSettings);
        }
        this.m_logger = iLogger;
        this.m_hasOpenSession = false;
        this.m_warningListener = iWarningListener;
        this.openSession();
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.UNION_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeVarchar(this.m_settings)) {
            DataTypeUtilities.addHiveType(TTypeId.VARCHAR_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeChar(this.m_settings)) {
            DataTypeUtilities.addHiveType(TTypeId.CHAR_TYPE, (short)1);
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.ARRAY_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.MAP_TYPE, (short)12);
            DataTypeUtilities.addHiveType(TTypeId.STRUCT_TYPE, (short)12);
        }
        if (this.m_settings.m_platformVersionUtils.supportsTypeDate(this.m_settings.m_serverVersion)) {
            DataTypeUtilities.addHiveType(TTypeId.DATE_TYPE, (short)91);
        }
    }

    protected HS2ClientWrapper fetchOauthClientWrapper(TProtocol tProtocol, ILogger iLogger) throws ErrorException {
        return new HS2OAuthClientWrapper(tProtocol, iLogger, this.m_settings);
    }

    public void cancelDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TCancelDelegationTokenReq tCancelDelegationTokenReq = new TCancelDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TCancelDelegationTokenResp tCancelDelegationTokenResp = this.m_client.CancelDelegationToken(tCancelDelegationTokenReq);
            this.checkResponseStatus(tCancelDelegationTokenResp.getStatus(), HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{tCancelDelegationTokenResp.getStatus().toString(), string});
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CANCEL_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public void cancelOperation(HiveOperationContext hiveOperationContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TCancelOperationReq tCancelOperationReq = new TCancelOperationReq();
            tCancelOperationReq.setOperationHandle(hiveOperationContext.getOperationHandle());
            TCancelOperationResp tCancelOperationResp = this.m_client.CancelOperation(tCancelOperationReq);
            Thread.sleep(1000L);
            String string = "CancelOperation";
            this.checkIfRespNull(tCancelOperationResp, string);
            this.checkResponseStatus(tCancelOperationResp.getStatus(), string);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name());
            errorException.initCause(exception);
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CANCELLATION_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
        }
    }

    @Override
    public void checkFetchErrors(RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException {
        if (rowsetBuffer.getBuffer().m_hiveServer2Buffer == null) {
            return;
        }
        this.checkResponseStatus(rowsetBuffer.getBuffer().m_hiveServer2Buffer.getStatus(), HiveJDBCMessageKey.CONN_FETCH_RESULT_ERR.name(), new String[]{"Buffer Fetch Error"});
    }

    public void checkFetchSize(HiveOperationContext hiveOperationContext, long l) throws ErrorException {
        if (null != hiveOperationContext.m_statement && this.m_settings.m_enableSetFetchSizeTesting && this.m_settings.m_setFetchSizeTakesPrecedence && l != (long)this.m_settings.m_expectedFetchSize) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SET_FETCH_SIZE_ERR.name(), "Fetch Size Error");
            throw errorException;
        }
    }

    @Override
    public void closeOperation(HiveOperationContext hiveOperationContext) {
        try {
            TCloseOperationResp tCloseOperationResp = null;
            if (hiveOperationContext.m_hasDRCloseOpResp) {
                LogUtilities.logDebug("Using DirectResults TCloseOperationResp", this.m_logger);
                tCloseOperationResp = hiveOperationContext.m_directResults.getCloseOperation();
                hiveOperationContext.m_hasDRCloseOpResp = false;
                hiveOperationContext.m_hasOpenOperation = false;
            } else if (hiveOperationContext.m_hasOpenOperation) {
                if (hiveOperationContext.m_heartbeatRegistered) {
                    this.getHeartBeatThread().removeOperationHandle(hiveOperationContext.m_fetchResultsReq.getOperationHandle());
                }
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(hiveOperationContext.m_fetchResultsReq.getOperationHandle());
                hiveOperationContext.m_hasOpenOperation = false;
                tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
            }
            if (null != tCloseOperationResp && TStatusCode.ERROR_STATUS == tCloseOperationResp.getStatus().getStatusCode()) {
                LogUtilities.logError(this.buildExceptionFromTStatus(tCloseOperationResp.getStatus(), HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), new String[]{tCloseOperationResp.getStatus().getErrorMessage()}), this.m_logger);
                this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tCloseOperationResp.getStatus()));
            }
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
        }
    }

    @Override
    public void closeSession() throws ErrorException {
        if (this.m_hasOpenSession) {
            try {
                TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
                tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                this.m_client.CloseSession(tCloseSessionReq);
                if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                    this.m_client.getInputProtocol().getTransport().close();
                }
                this.m_hasOpenSession = false;
                this.m_settings.m_isConnAlive = false;
            }
            catch (Exception exception) {
                String string = "Close Session Error";
                if (!exception.getMessage().isEmpty()) {
                    string = string + ": " + exception.getMessage();
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), string);
                errorException.initCause(exception);
                throw errorException;
            }
            finally {
                if (this.m_settings.m_thriftHTTPSettings.m_enableSessionTag) {
                    this.m_settings.m_thriftHTTPSettings.removeThriftSessionTag(this.m_logger);
                }
            }
        }
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_heartBeatThread) {
            this.m_heartBeatThread.stop();
        }
        this.closeSession();
        try {
            if (null != this.m_client && null != this.m_client.getInputProtocol() && null != this.m_client.getInputProtocol().getTransport()) {
                this.m_client.getInputProtocol().getTransport().close();
            }
        }
        catch (Exception exception) {
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public HiveExecutionContext executeStatement(String string, IExecutorUtility iExecutorUtility, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        boolean bl = false;
        if (iExecutorUtility instanceof HiveJDBCNativeQueryExecutor) {
            bl = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).getStatement().getAsyncExecution();
        }
        return this.executeStatementInternal(string, iExecutorUtility, hiveJDBCStatement, bl);
    }

    @Override
    public void executeUpdate(String string, IExecutorUtility iExecutorUtility) throws ErrorException {
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string, iExecutorUtility, null);
        this.closeOperation(hiveExecutionContext);
    }

    @Override
    public void fetchNRows(HiveOperationContext hiveOperationContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        if (hiveOperationContext.isCanceled()) {
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
        }
        this.fetchFromServer(hiveOperationContext, rowsetBuffer, n);
        if (!hiveOperationContext.m_serverHasMoreRows) {
            this.closeOperation(hiveOperationContext);
        }
    }

    public void fetchFromServer(HiveOperationContext hiveOperationContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer, int n) throws ErrorException, OperationCanceledException {
        try {
            TFetchResultsReq tFetchResultsReq = hiveOperationContext.m_fetchResultsReq;
            if (this.m_settings.m_setFetchSizeTakesPrecedence) {
                if (null != hiveOperationContext.m_statement && 0 == hiveOperationContext.m_fetchSize) {
                    hiveOperationContext.m_fetchSize = hiveOperationContext.m_statement.getProperty(6).getInt();
                }
                if (0 < hiveOperationContext.m_fetchSize) {
                    n = hiveOperationContext.m_fetchSize;
                }
            }
            tFetchResultsReq.setStartRowOffset(hiveOperationContext.m_driverSideStartRowOffset);
            tFetchResultsReq.setMaxRows(n);
            this.checkFetchSize(hiveOperationContext, n);
            tFetchResultsReq.setMaxBytes(this.m_settings.m_arrowMaxBytesPerFetch);
            HiveServer2BaseBuffer hiveServer2BaseBuffer = (HiveServer2BaseBuffer)rowsetBuffer.m_buffer;
            if (hiveOperationContext.m_hasDRFetchResp) {
                LogUtilities.logDebug("Using fetch response from direct results shortcut", this.m_logger);
                hiveServer2BaseBuffer.m_hiveServer2Buffer = hiveOperationContext.m_directResults.getResultSet();
                hiveOperationContext.m_hasDRFetchResp = false;
            } else {
                if (!hiveOperationContext.m_serverHasMoreRows) {
                    rowsetBuffer.m_bufferHasMoreRows = false;
                    return;
                }
                try {
                    hiveServer2BaseBuffer.m_hiveServer2Buffer = this.m_client.FetchResults(tFetchResultsReq);
                }
                catch (TException tException) {
                    ErrorException errorException;
                    this.closeOperation(hiveOperationContext);
                    if (tException instanceof TTransportException) {
                        errorException = this.handleTTransportException((TTransportException)tException, "FetchResults for query \"" + CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings) + "\"");
                    } else {
                        errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), tException.getMessage());
                        errorException.initCause(tException);
                    }
                    throw errorException;
                }
            }
            hiveOperationContext.m_hasOpenOperation = true;
            this.getRowSetInformation(hiveOperationContext, rowsetBuffer);
            while (this.correctHasMoreRowsResult() && !rowsetBuffer.m_bufferHasMoreRows && hiveServer2BaseBuffer.getHiveServer2Buffer().isHasMoreRows()) {
                LogUtilities.logDebug("Fetching again as hasMoreRows=true, but no rows returned", this.m_logger);
                hiveServer2BaseBuffer.m_hiveServer2Buffer = this.m_client.FetchResults(tFetchResultsReq);
                this.getRowSetInformation(hiveOperationContext, rowsetBuffer);
            }
            if (TStatusCode.ERROR_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode()) {
                try {
                    String string;
                    if (null != hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage() && ((string = hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage().toUpperCase()).contains("CANCELED") || string.contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus(), HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), new String[]{hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getErrorMessage()});
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveOperationContext);
                    throw throwable;
                }
            }
            if (hiveServer2BaseBuffer.m_hiveServer2Buffer.isSetResults()) {
                hiveOperationContext.m_isServerReturnedResultLinks = hiveServer2BaseBuffer.m_hiveServer2Buffer.getResults().isSetResultLinks();
            }
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "FetchResults");
        }
        catch (OperationCanceledException operationCanceledException) {
            throw operationCanceledException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Row Fetching Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void getRowSetInformation(HiveOperationContext hiveOperationContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException {
        HiveServer2BaseBuffer hiveServer2BaseBuffer = rowsetBuffer.getBuffer();
        if (TStatusCode.SUCCESS_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == hiveServer2BaseBuffer.getHiveServer2Buffer().getStatus().getStatusCode()) {
            rowsetBuffer.initializeBuffer();
            if (hiveServer2BaseBuffer.getHiveServer2Buffer().getResults().isSetResultLinks()) {
                TSparkArrowResultLink tSparkArrowResultLink;
                int n = 0;
                Iterator<TSparkArrowResultLink> iterator = hiveServer2BaseBuffer.getHiveServer2Buffer().getResults().getResultLinks().iterator();
                while (iterator.hasNext() && (n = (int)((long)n + (tSparkArrowResultLink = iterator.next()).getRowCount())) <= 0) {
                }
                rowsetBuffer.m_bufferHasMoreRows = 0 < n;
            } else {
                rowsetBuffer.m_bufferHasMoreRows = 0 < rowsetBuffer.getNumRows();
            }
            hiveOperationContext.m_serverHasMoreRows = this.correctHasMoreRowsResult() ? hiveServer2BaseBuffer.getHiveServer2Buffer().isHasMoreRows() : rowsetBuffer.m_bufferHasMoreRows;
        }
    }

    @Override
    public void fetchRows(HiveOperationContext hiveOperationContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException, OperationCanceledException {
        this.fetchNRows(hiveOperationContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
    }

    @Override
    public int getBinaryColumnSize() {
        return this.m_settings.m_binaryColumnSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<String> getCatalogs(HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        ArrayList<String> arrayList;
        HiveCatalogContext hiveCatalogContext;
        TOperationHandle tOperationHandle;
        block16: {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (!this.isMultiCatalogEnabled()) {
                arrayList2.add(this.m_settings.m_platformCatalog);
                return arrayList2;
            }
            boolean bl = this.m_settings.m_enableAsyncModeForMetadataOperation != false && this.m_settings.m_platformVersionUtils.supportsAsyncModeForMetadataOperation(this.m_settings);
            tOperationHandle = null;
            hiveCatalogContext = null;
            try {
                TGetCatalogsReq tGetCatalogsReq = new TGetCatalogsReq();
                TGetCatalogsResp tGetCatalogsResp = new TGetCatalogsResp();
                tGetCatalogsReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                if (bl) {
                    tGetCatalogsReq.setRunAsyncIsSet(true);
                    tGetCatalogsReq.setRunAsync(true);
                }
                if (this.m_enableDirectResults) {
                    tGetCatalogsReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                }
                Object object = this;
                synchronized (object) {
                    tGetCatalogsResp = this.m_client.GetCatalogs(tGetCatalogsReq);
                }
                tOperationHandle = tGetCatalogsResp.getOperationHandle();
                object = "GetCatalogs";
                this.checkIfRespNull(tGetCatalogsResp, (String)object);
                this.checkResponseStatus(tGetCatalogsResp.getStatus(), (String)object);
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                hiveCatalogContext = new HiveCatalogContext(this.m_settings, tGetCatalogsResp);
                hiveCatalogContext.m_fetchResultsReq = tFetchResultsReq;
                hiveCatalogContext.m_hasOpenOperation = true;
                if (tGetCatalogsResp.isSetDirectResults()) {
                    hiveCatalogContext.handleDirectResultsResp(this.m_logger, tGetCatalogsResp.getDirectResults());
                }
                this.storeQueryId(hiveCatalogContext, hiveJDBCStatement);
                if (bl) {
                    hiveCatalogContext = (HiveCatalogContext)this.pollForOperationCompletion(hiveCatalogContext);
                }
                RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveCatalogContext);
                do {
                    this.fetchNRows((HiveOperationContext)hiveCatalogContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    arrayList2.addAll(rowsetBuffer.getBuffer().getStringColumn(0));
                } while (hiveCatalogContext.m_serverHasMoreRows);
                arrayList = arrayList2;
                if (null != hiveCatalogContext) break block16;
            }
            catch (TTransportException tTransportException) {
                throw this.handleTTransportException(tTransportException, "GetCatalogs");
                catch (Exception exception) {
                    CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                    HiveJDBCExceptionUtils.logException(exception, this.m_logger);
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    return arrayList3;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return arrayList;
        }
        this.closeOperation(hiveCatalogContext);
        return arrayList;
        finally {
            if (null == hiveCatalogContext) {
                this.safeCloseOperation(tOperationHandle);
            } else {
                this.closeOperation(hiveCatalogContext);
            }
        }
    }

    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(String string, String string2, String string3, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_getColumnsWithQuery) {
            return this.getColumnsWithDescribeQuery(string, string2, string3, hiveJDBCStatement);
        }
        HashMap<MetadataSourceColumnTag, String> hashMap = new HashMap<MetadataSourceColumnTag, String>();
        hashMap.put(MetadataSourceColumnTag.CATALOG_NAME, string);
        hashMap.put(MetadataSourceColumnTag.SCHEMA_NAME, string2);
        hashMap.put(MetadataSourceColumnTag.TABLE_NAME, string3);
        try {
            return this.getColumns(hashMap, null, hiveJDBCStatement);
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonColumnMetadata> getColumns(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_getColumnsWithQuery) {
            return null;
        }
        String[] stringArray = this.parseFilters(map, arrayList);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        boolean bl = this.m_settings.m_enableAsyncModeForMetadataOperation != false && this.m_settings.m_platformVersionUtils.supportsAsyncModeForMetadataOperation(this.m_settings);
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            Object object;
            block34: {
                HiveColumnContext hiveColumnContext;
                block33: {
                    TOperationHandle tOperationHandle = null;
                    hiveColumnContext = null;
                    try {
                        ArrayList<HiveCommonColumnMetadata> arrayList2 = new ArrayList<HiveCommonColumnMetadata>();
                        String string5 = this.getCurrentCatalog();
                        TGetColumnsReq tGetColumnsReq = new TGetColumnsReq();
                        if (!this.isMultiCatalogEnabled()) {
                            tGetColumnsReq.setCatalogName(string5);
                            tGetColumnsReq.setCatalogNameIsSet(true);
                        } else if (null != string) {
                            tGetColumnsReq.setCatalogName(string);
                            tGetColumnsReq.setCatalogNameIsSet(true);
                        }
                        if (null != string2) {
                            tGetColumnsReq.setSchemaName(string2);
                            tGetColumnsReq.setSchemaNameIsSet(true);
                        }
                        if (null != string3) {
                            tGetColumnsReq.setTableName(string3);
                            tGetColumnsReq.setTableNameIsSet(true);
                        }
                        if (null != string4) {
                            tGetColumnsReq.setColumnName(string4);
                            tGetColumnsReq.setColumnNameIsSet(true);
                        } else if (this.m_settings.m_isSparkLivyServer) {
                            tGetColumnsReq.setColumnName("%");
                            tGetColumnsReq.setColumnNameIsSet(true);
                        }
                        tGetColumnsReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                        tGetColumnsReq.setSessionHandleIsSet(true);
                        if (bl) {
                            tGetColumnsReq.setRunAsyncIsSet(true);
                            tGetColumnsReq.setRunAsync(true);
                        }
                        if (this.m_enableDirectResults) {
                            tGetColumnsReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                        }
                        TGetColumnsResp tGetColumnsResp = this.m_client.GetColumns(tGetColumnsReq);
                        tOperationHandle = tGetColumnsResp.getOperationHandle();
                        String string6 = "GetColumns";
                        this.checkIfRespNull(tGetColumnsResp, string6);
                        this.checkResponseStatus(tGetColumnsResp.getStatus(), string6);
                        if (null == tOperationHandle) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GETCOLUMNS_API_CALL_ERR.name(), new String[]{"Unknown", "Unknown"});
                            throw errorException;
                        }
                        List<Object> list = new ArrayList();
                        List<Object> list2 = new ArrayList();
                        List<Object> list3 = new ArrayList();
                        String string7 = this.isMultiCatalogEnabled() ? "" : string5;
                        String string8 = "";
                        String string9 = "";
                        int n = 0;
                        int n2 = 0;
                        ArrayList<String> arrayList3 = null;
                        String string10 = "";
                        TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                        tFetchResultsReq.setOperationHandle(tOperationHandle);
                        hiveColumnContext = new HiveColumnContext(this.m_settings, tGetColumnsResp);
                        hiveColumnContext.m_fetchResultsReq = tFetchResultsReq;
                        hiveColumnContext.m_hasOpenOperation = true;
                        if (tGetColumnsResp.isSetDirectResults()) {
                            hiveColumnContext.handleDirectResultsResp(this.m_logger, tGetColumnsResp.getDirectResults());
                        }
                        this.storeQueryId(hiveColumnContext, hiveJDBCStatement);
                        if (bl) {
                            hiveColumnContext = (HiveColumnContext)this.pollForOperationCompletion(hiveColumnContext);
                        }
                        RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveColumnContext);
                        do {
                            object = rowsetBuffer.getBuffer();
                            this.fetchNRows((HiveOperationContext)hiveColumnContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                            n2 = ((HiveServer2BaseBuffer)object).getNumRowsInBuffer();
                            list = ((HiveServer2BaseBuffer)object).getStringColumn(3);
                            list2 = ((HiveServer2BaseBuffer)object).getStringColumn(5);
                            list3 = ((HiveServer2BaseBuffer)object).getStringColumn(11);
                            List<String> list4 = ((HiveServer2BaseBuffer)object).getStringColumn(0);
                            List<String> list5 = ((HiveServer2BaseBuffer)object).getStringColumn(1);
                            List<String> list6 = ((HiveServer2BaseBuffer)object).getStringColumn(2);
                            List<Integer> list7 = new ArrayList<Integer>(Collections.nCopies(list.size(), Nullable.NULLABLE.getIntValue()));
                            if (null != this.m_settings.m_isServerReturnsCorrectNullability && this.m_settings.m_isServerReturnsCorrectNullability.booleanValue()) {
                                list7 = ((HiveServer2BaseBuffer)object).getIntColumn(10);
                            }
                            for (int i = 0; i < n2; ++i, ++n) {
                                String string11 = string = this.isMultiCatalogEnabled() ? list4.get(i) : string7;
                                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string5, string)) continue;
                                string2 = list5.get(i);
                                string3 = list6.get(i);
                                if (!(string7.equals(string) && string8.equals(string2) && string9.equals(string3))) {
                                    string7 = string;
                                    string8 = string2;
                                    string9 = string3;
                                    n = 0;
                                    arrayList3 = null;
                                }
                                if ((((String)list2.get(i)).contains("DECIMAL") || ((String)list2.get(i)).contains("VARCHAR") || ((String)list2.get(i)).contains("CHAR")) && !this.m_settings.m_platformVersionUtils.supportsQualifiedTypeNames(this.m_settings.m_serverVersion)) {
                                    if (null == arrayList3) {
                                        arrayList3 = this.getQualifiedTypeNames(string2, string3, hiveJDBCStatement);
                                    }
                                    string10 = arrayList3.size() > 0 ? arrayList3.get(n) : (String)list2.get(i);
                                } else {
                                    string10 = (String)list2.get(i);
                                }
                                if (this.m_settings.m_isSparkLivyServer) {
                                    string10 = DataTypeUtilities.mapLivyTypeNameToHiveTypeName(string10.toUpperCase(), this.m_settings);
                                }
                                if (string10.toUpperCase().contains("ARRAY<") || string10.toUpperCase().contains("STRUCT<") || string10.toUpperCase().contains("MAP<") || string10.toUpperCase().contains("UNIONTYPE<")) {
                                    string10 = string10.toUpperCase();
                                }
                                try {
                                    arrayList2.add(DataTypeUtilities.createColumn(string, string2, string3, (String)list.get(i), (String)list3.get(i), DataTypeUtilities.mapHiveTypeNameToSqltype(string10, 2, this.m_settings), string10, 2, list7.get(i), this.m_settings));
                                    continue;
                                }
                                catch (Exception exception) {
                                    this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CREATE_COLUMN_METADATA_ERR.name(), new String[]{string2, string3, (String)list.get(i), string10}));
                                }
                            }
                        } while (hiveColumnContext.m_serverHasMoreRows);
                        object = arrayList2;
                        if (null != hiveColumnContext) break block33;
                    }
                    catch (TTransportException tTransportException) {
                        try {
                            throw this.handleTTransportException(tTransportException, "GetColumns");
                            catch (Exception exception) {
                                throw exception;
                            }
                        }
                        catch (Throwable throwable) {
                            if (null == hiveColumnContext) {
                                this.safeCloseOperation(tOperationHandle);
                                throw throwable;
                            }
                            this.closeOperation(hiveColumnContext);
                            throw throwable;
                        }
                    }
                    this.safeCloseOperation(tOperationHandle);
                    break block34;
                }
                this.closeOperation(hiveColumnContext);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentCatalog() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() {
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            return this.m_settings.m_Schema;
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, HiveExecutionContext hiveExecutionContext, CurrentBufferContext currentBufferContext) throws ErrorException {
        Object ApiBufferT = currentBufferContext.m_currentBuffer.m_buffer;
        short s = currentBufferContext.m_columnTypes[n];
        return ApiBufferT.getData(n, l, l2, dataWrapper, currentBufferContext.m_currentRowInBuffer, s, CoreUtils.redactQuery(hiveExecutionContext.m_operation, this.m_settings), this.m_settings);
    }

    public String getDelegationToken(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TGetDelegationTokenReq tGetDelegationTokenReq = new TGetDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string, string2);
        try {
            TGetDelegationTokenResp tGetDelegationTokenResp = this.m_client.GetDelegationToken(tGetDelegationTokenReq);
            this.checkResponseStatus(tGetDelegationTokenResp.getStatus(), HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{tGetDelegationTokenResp.getStatus().toString(), string, string2});
            return tGetDelegationTokenResp.getDelegationToken();
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.GET_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string, string2});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public DatabaseMetadataInfo getDatabaseMetadataInfo() {
        return this.dbmdInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveForeignKeyContext GetForeignKeys(ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException, HivePkFkAPINotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            boolean bl;
            TGetCrossReferenceReq tGetCrossReferenceReq = new TGetCrossReferenceReq();
            TGetCrossReferenceResp tGetCrossReferenceResp = new TGetCrossReferenceResp();
            boolean bl2 = bl = this.m_settings.m_AsyncExecPKFk != false && this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion);
            if (bl) {
                tGetCrossReferenceReq.setRunAsyncIsSet(true);
                tGetCrossReferenceReq.setRunAsync(true);
            }
            if (this.m_enableDirectResults) {
                tGetCrossReferenceReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
            }
            if (this.isMultiCatalogEnabled() && null != (string5 = arrayList.get(0))) {
                tGetCrossReferenceReq.setParentCatalogName(string5);
                tGetCrossReferenceReq.setParentCatalogNameIsSet(true);
            }
            if (null != (string5 = arrayList.get(1))) {
                tGetCrossReferenceReq.setParentSchemaName(string5);
                tGetCrossReferenceReq.setParentSchemaNameIsSet(true);
            }
            if (null != (string4 = arrayList.get(2))) {
                tGetCrossReferenceReq.setParentTableName(string4);
                tGetCrossReferenceReq.setParentTableNameIsSet(true);
            }
            if (null != (string3 = arrayList.get(3))) {
                tGetCrossReferenceReq.setForeignCatalogName(string3);
                tGetCrossReferenceReq.setForeignCatalogNameIsSet(true);
            }
            if (null != (string2 = arrayList.get(4))) {
                tGetCrossReferenceReq.setForeignSchemaName(string2);
                tGetCrossReferenceReq.setForeignSchemaNameIsSet(true);
            }
            if (null != (string = arrayList.get(5))) {
                tGetCrossReferenceReq.setForeignTableName(string);
                tGetCrossReferenceReq.setForeignTableNameIsSet(true);
            }
            Object object = this;
            synchronized (object) {
                tGetCrossReferenceReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetCrossReferenceResp = this.m_client.GetCrossReference(tGetCrossReferenceReq);
            }
            object = new HiveForeignKeyContext(this.m_settings, tGetCrossReferenceResp);
            if (null == ((HiveForeignKeyContext)object).getOperationHandle()) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{((HiveForeignKeyContext)object).m_operation, Integer.toString(tGetCrossReferenceResp.getStatus().getErrorCode()), tGetCrossReferenceResp.getStatus().getErrorMessage()});
            }
            ((HiveForeignKeyContext)object).m_fetchResultsReq = new TFetchResultsReq();
            ((HiveForeignKeyContext)object).m_fetchResultsReq.setOperationHandle(((HiveForeignKeyContext)object).getOperationHandle());
            if (tGetCrossReferenceResp.isSetDirectResults()) {
                ((HiveOperationContext)object).handleDirectResultsResp(this.m_logger, tGetCrossReferenceResp.getDirectResults());
            }
            this.storeQueryId((HiveOperationContext)object, hiveJDBCStatement);
            if (!bl) {
                return (HiveForeignKeyContext)this.pollForOperationCompletion((HiveOperationContext)object);
            }
            return object;
        }
        catch (TApplicationException tApplicationException) {
            if (1 == tApplicationException.getType()) {
                throw new HivePkFkAPINotSupportedException();
            }
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), tApplicationException.getMessage());
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "GetForeignKeys");
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ArrayList<HiveCommonFunctionsMetadataSourceRow> getFunctions(Map<MetadataSourceColumnTag, String> var1_1, ArrayList<String> var2_2, HiveJDBCStatement var3_3) throws ErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ILogger getLogger() {
        return this.m_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HivePrimaryKeyContext GetPrimaryKeys(ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException, HivePkFkAPINotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            String string;
            String string2;
            boolean bl;
            TGetPrimaryKeysReq tGetPrimaryKeysReq = new TGetPrimaryKeysReq();
            TGetPrimaryKeysResp tGetPrimaryKeysResp = new TGetPrimaryKeysResp();
            boolean bl2 = bl = this.m_settings.m_AsyncExecPKFk != false && this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion);
            if (bl) {
                tGetPrimaryKeysReq.setRunAsyncIsSet(true);
                tGetPrimaryKeysReq.setRunAsync(true);
            }
            if (this.m_settings.m_enableDirectResults) {
                tGetPrimaryKeysReq.setGetDirectResultsIsSet(true);
                tGetPrimaryKeysReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
            }
            if (this.isMultiCatalogEnabled() && null != (string2 = arrayList.get(0))) {
                tGetPrimaryKeysReq.setCatalogName(string2);
                tGetPrimaryKeysReq.setCatalogNameIsSet(true);
            }
            if (null != (string2 = arrayList.get(1))) {
                tGetPrimaryKeysReq.setSchemaName(string2);
                tGetPrimaryKeysReq.setSchemaNameIsSet(true);
            }
            if (null != (string = arrayList.get(2))) {
                tGetPrimaryKeysReq.setTableName(string);
                tGetPrimaryKeysReq.setTableNameIsSet(true);
            }
            Object object = this;
            synchronized (object) {
                tGetPrimaryKeysReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                tGetPrimaryKeysResp = this.m_client.GetPrimaryKeys(tGetPrimaryKeysReq);
            }
            object = new HivePrimaryKeyContext(this.m_settings, tGetPrimaryKeysResp);
            if (null == ((HivePrimaryKeyContext)object).getOperationHandle()) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{((HivePrimaryKeyContext)object).m_operation, Integer.toString(tGetPrimaryKeysResp.getStatus().getErrorCode()), tGetPrimaryKeysResp.getStatus().getErrorMessage()});
            }
            ((HivePrimaryKeyContext)object).m_fetchResultsReq = new TFetchResultsReq();
            ((HivePrimaryKeyContext)object).m_fetchResultsReq.setOperationHandle(((HivePrimaryKeyContext)object).getOperationHandle());
            if (tGetPrimaryKeysResp.isSetDirectResults()) {
                ((HiveOperationContext)object).handleDirectResultsResp(this.m_logger, tGetPrimaryKeysResp.getDirectResults());
            }
            this.storeQueryId((HiveOperationContext)object, hiveJDBCStatement);
            if (!bl) {
                return (HivePrimaryKeyContext)this.pollForOperationCompletion((HiveOperationContext)object);
            }
            return object;
        }
        catch (TApplicationException tApplicationException) {
            if (1 == tApplicationException.getType()) {
                throw new HivePkFkAPINotSupportedException();
            }
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), tApplicationException.getMessage());
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "GetPrimaryKeys");
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public ArrayList<ColumnMetadata> getResultSetMetadata(HiveOperationContext hiveOperationContext) throws ErrorException {
        try {
            TGetResultSetMetadataResp tGetResultSetMetadataResp = this.getResultSetMetadataInternal(hiveOperationContext);
            if (null == tGetResultSetMetadataResp.getSchema()) {
                return new ArrayList<ColumnMetadata>();
            }
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>(tGetResultSetMetadataResp.getSchema().getColumns().size());
            for (TColumnDesc tColumnDesc : tGetResultSetMetadataResp.getSchema().getColumns()) {
                TTypeEntry tTypeEntry = tColumnDesc.getTypeDesc().getTypes().get(0);
                if (this.m_settings.m_platformVersionUtils.hasIssueWithNullTypeMetadata(this.m_settings.m_serverVersion) && tTypeEntry.isSetPrimitiveEntry() && tTypeEntry.getPrimitiveEntry().getType().equals(TTypeId.USER_DEFINED_TYPE)) {
                    tTypeEntry.getPrimitiveEntry().setType(TTypeId.BOOLEAN_TYPE);
                }
                String string = this.fullColumnTypeNameBuilder(tTypeEntry);
                arrayList.add(DataTypeUtilities.createColumn(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getCatalogName(), null, null, tColumnDesc.getColumnName(), null, DataTypeUtilities.mapHiveTypeToSqlType(tTypeEntry.getPrimitiveEntry().getType()), string, 2, Nullable.NULLABLE.getIntValue(), this.m_settings));
            }
            return arrayList;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            String string = "Metadata Result Set Error";
            if (!exception.getMessage().isEmpty()) {
                string = string + ": " + exception.getMessage();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), string);
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected HiveExecutionContext createExecutionContext() {
        return new HiveExecutionContext(this.m_settings);
    }

    protected TGetResultSetMetadataResp getResultSetMetadataInternal(HiveOperationContext hiveOperationContext) throws TException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, hiveOperationContext);
        try {
            Object object;
            TGetResultSetMetadataResp tGetResultSetMetadataResp;
            if (hiveOperationContext.m_hasDRGetRsmdResp) {
                LogUtilities.logDebug("Using result set metadata from direct results response", this.m_logger);
                tGetResultSetMetadataResp = hiveOperationContext.m_directResults.getResultSetMetadata();
            } else {
                object = new TGetResultSetMetadataReq();
                ((TGetResultSetMetadataReq)object).setOperationHandle(hiveOperationContext.getOperationHandle());
                tGetResultSetMetadataResp = this.m_client.GetResultSetMetadata((TGetResultSetMetadataReq)object);
            }
            if (TStatusCode.ERROR_STATUS == tGetResultSetMetadataResp.getStatus().getStatusCode()) {
                try {
                    if (null != tGetResultSetMetadataResp.getStatus().getErrorMessage() && (((String)(object = tGetResultSetMetadataResp.getStatus().getErrorMessage().toUpperCase())).contains("CANCELED") || ((String)object).contains("CANCELLED"))) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name());
                    }
                    throw this.buildExceptionFromTStatus(tGetResultSetMetadataResp.getStatus(), HiveJDBCMessageKey.HIVE_METADATA_RESULTSET_ERR.name(), new String[]{tGetResultSetMetadataResp.getStatus().getErrorMessage()});
                }
                catch (Throwable throwable) {
                    this.closeOperation(hiveOperationContext);
                    throw throwable;
                }
            }
            if (TSparkRowSetType.ARROW_BASED_SET == tGetResultSetMetadataResp.getResultFormat() || TSparkRowSetType.URL_BASED_SET == tGetResultSetMetadataResp.getResultFormat()) {
                hiveOperationContext.m_rsMdColumns = tGetResultSetMetadataResp.getSchema().getColumns();
                hiveOperationContext.m_hasArrowResults = true;
            }
            hiveOperationContext.m_isLz4Compressed = tGetResultSetMetadataResp.isLz4Compressed();
            return tGetResultSetMetadataResp;
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "GetResultSetMetadata for query \"" + CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings) + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonSchemasMetadataSourceRow> getSchemas(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = this.parseFilters(map, arrayList)[0];
        String string2 = this.getCurrentCatalog();
        ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList2 = new ArrayList<HiveCommonSchemasMetadataSourceRow>();
        if (this.m_settings.m_getSchemasWithQuery || this.m_settings.m_connDBType.equalsIgnoreCase(IMPALA_SERVER_NAME)) {
            try {
                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.isNonCurrentCatalog(string2, string)) {
                    return arrayList2;
                }
                ArrayList<String> arrayList3 = this.runCatalogFunction(SHOW_DATABASES_STRING, 0);
                Iterator<String> iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    arrayList2.add(new HiveCommonSchemasMetadataSourceRow(string2, string3));
                }
                return arrayList2;
            }
            catch (Exception exception) {
                if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                    throw (ErrorException)exception;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                errorException.initCause(exception);
                throw errorException;
            }
        }
        TOperationHandle tOperationHandle = null;
        HiveSchemaContext hiveSchemaContext = null;
        boolean bl = this.m_settings.m_enableAsyncModeForMetadataOperation != false && this.m_settings.m_platformVersionUtils.supportsAsyncModeForMetadataOperation(this.m_settings);
        HS2Client hS2Client = this;
        synchronized (hS2Client) {
            ArrayList<HiveCommonSchemasMetadataSourceRow> arrayList4;
            block28: {
                block27: {
                    try {
                        TGetSchemasReq tGetSchemasReq = new TGetSchemasReq();
                        TGetSchemasResp tGetSchemasResp = new TGetSchemasResp();
                        boolean bl2 = this.isMultiCatalogEnabled();
                        if (!bl2) {
                            tGetSchemasReq.setCatalogName(string2);
                            tGetSchemasReq.setCatalogNameIsSet(true);
                        } else if (null != string) {
                            tGetSchemasReq.setCatalogName(string);
                            tGetSchemasReq.setCatalogNameIsSet(true);
                        }
                        tGetSchemasReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                        tGetSchemasReq.setSessionHandleIsSet(true);
                        if (this.m_enableDirectResults) {
                            tGetSchemasReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                        }
                        if (bl) {
                            tGetSchemasReq.setRunAsyncIsSet(true);
                            tGetSchemasReq.setRunAsync(true);
                        }
                        Object object = this;
                        synchronized (object) {
                            tGetSchemasResp = this.m_client.GetSchemas(tGetSchemasReq);
                        }
                        tOperationHandle = tGetSchemasResp.getOperationHandle();
                        object = "GetSchemas";
                        this.checkIfRespNull(tGetSchemasResp, (String)object);
                        this.checkResponseStatus(tGetSchemasResp.getStatus(), (String)object);
                        if (null == tOperationHandle) {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getSchemas", "Unknown", "Unknown"});
                            throw errorException;
                        }
                        TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                        tFetchResultsReq.setOperationHandle(tOperationHandle);
                        hiveSchemaContext = new HiveSchemaContext(this.m_settings, tGetSchemasResp);
                        hiveSchemaContext.m_fetchResultsReq = tFetchResultsReq;
                        hiveSchemaContext.m_hasOpenOperation = true;
                        if (tGetSchemasResp.isSetDirectResults()) {
                            hiveSchemaContext.handleDirectResultsResp(this.m_logger, tGetSchemasResp.getDirectResults());
                        }
                        this.storeQueryId(hiveSchemaContext, hiveJDBCStatement);
                        if (bl) {
                            hiveSchemaContext = (HiveSchemaContext)this.pollForOperationCompletion(hiveSchemaContext);
                        }
                        RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveSchemaContext);
                        do {
                            this.fetchNRows((HiveOperationContext)hiveSchemaContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                            List<String> list = rowsetBuffer.getBuffer().getStringColumn(0);
                            List<String> list2 = rowsetBuffer.getBuffer().getStringColumn(1);
                            for (int i = 0; rowsetBuffer.getBuffer().getNumRowsInBuffer() > i; ++i) {
                                if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string2, list2.get(i))) continue;
                                arrayList2.add(new HiveCommonSchemasMetadataSourceRow(bl2 ? list2.get(i) : string2, list.get(i)));
                            }
                        } while (hiveSchemaContext.m_serverHasMoreRows);
                        arrayList4 = arrayList2;
                        if (null != hiveSchemaContext) break block27;
                    }
                    catch (TTransportException tTransportException) {
                        try {
                            throw this.handleTTransportException(tTransportException, "GetSchemas");
                            catch (Exception exception) {
                                if (exception instanceof ErrorException) {
                                    ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                                }
                                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_SCHEMA_ERR.name(), "Schema Metadata Error");
                                errorException.initCause(exception);
                                throw errorException;
                            }
                        }
                        catch (Throwable throwable) {
                            if (null == hiveSchemaContext) {
                                this.safeCloseOperation(tOperationHandle);
                                throw throwable;
                            }
                            this.closeOperation(hiveSchemaContext);
                            throw throwable;
                        }
                    }
                    this.safeCloseOperation(tOperationHandle);
                    break block28;
                }
                this.closeOperation(hiveSchemaContext);
            }
            return arrayList4;
        }
    }

    @Override
    public short getStringColumnSize() {
        return this.m_settings.m_stringColumnSize;
    }

    @Override
    public HiveJDBCPlaceholderTable getTable(String string, String string2, String string3, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        ArrayList<HiveCommonColumnMetadata> arrayList;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.isMultiCatalogEnabled() && this.isNonPlatformCatalog(string)) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        if (null == (arrayList = this.getColumns(string, string2, string3, hiveJDBCStatement)) || arrayList.isEmpty()) {
            return null;
        }
        return new HiveJDBCPlaceholderTable(arrayList);
    }

    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList = new ArrayList<HiveCommonTablesMetadataSourceRow>();
        if (null == string) {
            string = this.getCurrentCatalog();
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.getCurrentSchema();
        }
        try {
            String string3 = "SHOW TABLES in " + string2;
            for (String string4 : this.runCatalogFunction(string3, this.m_settings.m_tableNameColIndex)) {
                arrayList.add(new HiveCommonTablesMetadataSourceRow(string, string2, string4, TBL_TYPE_TABLE, null));
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArrayList<HiveCommonTablesMetadataSourceRow> getTables(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        ArrayList<HiveCommonTablesMetadataSourceRow> arrayList2;
        HiveTableContext hiveTableContext;
        TOperationHandle tOperationHandle;
        block22: {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            if (this.m_settings.m_getTablesWithQuery) {
                return null;
            }
            String string = this.getCurrentCatalog();
            String[] stringArray = this.parseFilters(map, arrayList);
            String string2 = this.isSwitchRestrict() ? stringArray[1] : stringArray[0];
            String string3 = this.isSwitchRestrict() ? stringArray[0] : stringArray[1];
            String string4 = stringArray[2];
            ArrayList<HiveCommonTablesMetadataSourceRow> arrayList3 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
            tOperationHandle = null;
            hiveTableContext = null;
            TGetTablesResp tGetTablesResp = null;
            try {
                boolean bl;
                TGetTablesReq tGetTablesReq = new TGetTablesReq();
                tGetTablesReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
                boolean bl2 = this.isMultiCatalogEnabled();
                if (bl2 && null != string2) {
                    tGetTablesReq.setCatalogName(string2);
                    tGetTablesReq.setCatalogNameIsSet(true);
                }
                if (null != string3) {
                    tGetTablesReq.setSchemaName(string3);
                    tGetTablesReq.setSchemaNameIsSet(true);
                }
                if (null != string4) {
                    tGetTablesReq.setTableName(string4);
                    tGetTablesReq.setTableNameIsSet(true);
                }
                if (this.m_enableDirectResults) {
                    tGetTablesReq.setGetDirectResults(new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock));
                }
                boolean bl3 = bl = this.m_settings.m_enableAsyncModeForMetadataOperation != false && this.m_settings.m_platformVersionUtils.supportsAsyncModeForMetadataOperation(this.m_settings);
                if (bl) {
                    tGetTablesReq.setRunAsyncIsSet(true);
                    tGetTablesReq.setRunAsync(true);
                }
                Object object = this;
                synchronized (object) {
                    tGetTablesResp = this.m_client.GetTables(tGetTablesReq);
                }
                tOperationHandle = tGetTablesResp.getOperationHandle();
                object = new TGetResultSetMetadataReq();
                ((TGetResultSetMetadataReq)object).setOperationHandle(tGetTablesResp.getOperationHandle());
                String string5 = "GetTables";
                this.checkIfRespNull(tGetTablesResp, string5);
                this.checkResponseStatus(tGetTablesResp.getStatus(), string5);
                if (null == tOperationHandle) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{"getTables", "Unknown", "Unknown"});
                    throw errorException;
                }
                TFetchResultsReq tFetchResultsReq = new TFetchResultsReq();
                tFetchResultsReq.setOperationHandle(tOperationHandle);
                hiveTableContext = new HiveTableContext(this.m_settings, tGetTablesResp);
                hiveTableContext.m_fetchResultsReq = tFetchResultsReq;
                hiveTableContext.m_hasOpenOperation = true;
                if (tGetTablesResp.isSetDirectResults()) {
                    hiveTableContext.handleDirectResultsResp(this.m_logger, tGetTablesResp.getDirectResults());
                }
                this.storeQueryId(hiveTableContext, hiveJDBCStatement);
                if (bl) {
                    hiveTableContext = (HiveTableContext)this.pollForOperationCompletion(hiveTableContext);
                }
                RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveTableContext);
                do {
                    this.fetchNRows((HiveOperationContext)hiveTableContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                    List<String> list = rowsetBuffer.getBuffer().getStringColumn(0);
                    List<String> list2 = rowsetBuffer.getBuffer().getStringColumn(2);
                    List<String> list3 = rowsetBuffer.getBuffer().getStringColumn(3);
                    List<String> list4 = rowsetBuffer.getBuffer().getStringColumn(4);
                    List<String> list5 = rowsetBuffer.getBuffer().getStringColumn(1);
                    for (int i = 0; rowsetBuffer.getBuffer().getNumRowsInBuffer() > i; ++i) {
                        String string6 = list.get(i);
                        if (this.m_settings.m_forceCurrentCatalogOnlyForCatalogFunc && this.mismatchedCatalogOrTempCatalog(string, string6)) continue;
                        String string7 = list3.get(i);
                        if (string7.isEmpty() && this.m_settings.m_mapEmptyTableTypeToTable) {
                            string7 = TBL_TYPE_TABLE;
                        }
                        boolean bl4 = this.m_settings.m_platformVersionUtils.supportsGetTablesAPIComments(this.m_settings.m_serverVersion);
                        arrayList3.add(new HiveCommonTablesMetadataSourceRow(bl2 ? string6 : string, list5.get(i), list2.get(i), string7, bl4 ? list4.get(i) : null));
                    }
                } while (hiveTableContext.m_serverHasMoreRows);
                arrayList2 = arrayList3;
                if (null != hiveTableContext) break block22;
            }
            catch (TTransportException tTransportException) {
                throw this.handleTTransportException(tTransportException, "GetTables");
                catch (Exception exception) {
                    CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                    HiveJDBCExceptionUtils.logException(exception, this.m_logger);
                    ArrayList<HiveCommonTablesMetadataSourceRow> arrayList4 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
                    return arrayList4;
                }
            }
            this.safeCloseOperation(tOperationHandle);
            return arrayList2;
        }
        this.closeOperation(hiveTableContext);
        return arrayList2;
        finally {
            if (null == hiveTableContext) {
                this.safeCloseOperation(tOperationHandle);
            } else {
                this.closeOperation(hiveTableContext);
            }
        }
    }

    @Override
    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean isArrowEnabled() {
        return this.m_enableArrow;
    }

    @Override
    public boolean isMultiCatalogEnabled() {
        return this.m_settings.m_enableMultiCatalog;
    }

    @Override
    public boolean isSwitchRestrict() {
        return this.m_settings.m_switchCataANDSchema;
    }

    @Override
    public boolean isSessionValid() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.getServerVersion();
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            return false;
        }
        return true;
    }

    public boolean IsSupportPrimaryKeysForeignKeys() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_settings.m_platformVersionUtils.supportsGetPrimaryForeignKeyAPI(this.m_settings);
    }

    @Override
    public RowsetBuffer<HiveServer2BaseBuffer> makeRowsetBuffer(HiveOperationContext hiveOperationContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, hiveOperationContext);
        if (hiveOperationContext.m_hasArrowResults) {
            return new RowsetBuffer<HiveServer2BaseBuffer>(((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).createArrowBuffer(this.m_logger, hiveOperationContext.m_rsMdColumns, hiveOperationContext.m_isLz4Compressed, this.m_settings));
        }
        if (this.isAtLeastV6ProtocolSession()) {
            return new RowsetBuffer<HiveServer2BaseBuffer>(new HS2v6Buffer(this.m_logger, this.m_settings, hiveOperationContext));
        }
        return new RowsetBuffer<HiveServer2BaseBuffer>(new HS2Buffer(this.m_logger, this.m_settings));
    }

    public int operationHandleCountInHeartbeatThread() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = 0;
        if (null == this.m_heartBeatThread) {
            throw new RuntimeException("Heartbeat thread should not contains operation handle after execution of query.");
        }
        n = this.m_heartBeatThread.countOperationHandle();
        return n;
    }

    public HiveOperationContext pollForOperationCompletion(HiveOperationContext hiveOperationContext) throws ErrorException {
        if (hiveOperationContext.isCanceled()) {
            this.cancelOperation(hiveOperationContext);
            throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
        }
        try {
            TGetOperationStatusResp tGetOperationStatusResp;
            TGetOperationStatusReq tGetOperationStatusReq = new TGetOperationStatusReq();
            if (null == hiveOperationContext.getOperationHandle()) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_NULL_OPERATION_HANDLE.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                throw errorException;
            }
            tGetOperationStatusReq.setOperationHandle(hiveOperationContext.getOperationHandle());
            tGetOperationStatusReq.setOperationHandleIsSet(true);
            if (hiveOperationContext.m_hasDROperationStatusResp) {
                tGetOperationStatusResp = hiveOperationContext.m_directResults.getOperationStatus();
                LogUtilities.logDebug("DirectResults operationStatus: " + (TOperationState.FINISHED_STATE == tGetOperationStatusResp.getOperationState() ? "Finished" : "Not finished"), this.m_logger);
            } else {
                tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                this.checkNumModifiedRows(tGetOperationStatusResp, hiveOperationContext);
            }
            block14: while (!hiveOperationContext.isCanceled() && !hiveOperationContext.m_isExecutionComplete) {
                this.checkResponseStatus(tGetOperationStatusResp.getStatus(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_FROM_SERVER.name(), new String[]{String.valueOf(tGetOperationStatusResp.getErrorCode()), tGetOperationStatusResp.getSqlState(), CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings), tGetOperationStatusResp.isSetErrorMessage() ? tGetOperationStatusResp.getErrorMessage() : NO_ERROR_MESSAGE_FROM_SERVER});
                if (TStatusCode.SUCCESS_STATUS == tGetOperationStatusResp.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    switch (tGetOperationStatusResp.getOperationState()) {
                        case CLOSED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CLOSED_SERVER.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                            throw errorException;
                        }
                        case CANCELED_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL_SERVER.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                            throw errorException;
                        }
                        case ERROR_STATE: {
                            throw this.buildExceptionFromTStatusSqlState(tGetOperationStatusResp.getSqlState(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_FROM_SERVER.name(), new String[]{String.valueOf(tGetOperationStatusResp.getErrorCode()), tGetOperationStatusResp.getSqlState(), CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings), tGetOperationStatusResp.isSetErrorMessage() ? tGetOperationStatusResp.getErrorMessage() : NO_ERROR_MESSAGE_FROM_SERVER});
                        }
                        case UKNOWN_STATE: {
                            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                            throw errorException;
                        }
                        case PENDING_STATE: 
                        case RUNNING_STATE: 
                        case INITIALIZED_STATE: {
                            this.timeoutCheck(hiveOperationContext);
                            try {
                                Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                                if (hiveOperationContext.isCanceled()) continue block14;
                            }
                            tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                            this.checkNumModifiedRows(tGetOperationStatusResp, hiveOperationContext);
                            continue block14;
                        }
                        case FINISHED_STATE: {
                            hiveOperationContext.m_isExecutionComplete = true;
                            continue block14;
                        }
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_INVALID_STATE.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                    throw errorException;
                }
                if (TStatusCode.INVALID_HANDLE_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_INVALID_OPERATION_HANDLE.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                    throw errorException;
                }
                if (TStatusCode.STILL_EXECUTING_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                    this.timeoutCheck(hiveOperationContext);
                    Thread.sleep(this.m_settings.m_asyncExecPollInterval);
                    tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
                    continue;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_UNRECOGNIZED_STATUS_CODE.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)});
                throw errorException;
            }
            if (hiveOperationContext.isCanceled()) {
                this.cancelOperation(hiveOperationContext);
                throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
            }
            if (!hiveOperationContext.m_isManualCanceled.get() && hiveOperationContext.m_isExecutionComplete) {
                hiveOperationContext.m_fetchResultsReq = new TFetchResultsReq();
                hiveOperationContext.m_fetchResultsReq.setOrientation(TFetchOrientation.FETCH_NEXT);
                hiveOperationContext.m_fetchResultsReq.setOperationHandle(hiveOperationContext.getOperationHandle());
                hiveOperationContext.m_hasOpenOperation = true;
            }
            this.checkNumModifiedRows(tGetOperationStatusResp, hiveOperationContext);
            if (this.m_settings.m_isEnableHeartBeat && hiveOperationContext.m_hasOpenOperation && !hiveOperationContext.m_hasRowcountResult && (null == hiveOperationContext.m_directResults || !hiveOperationContext.m_directResults.isSetCloseOperation())) {
                this.getHeartBeatThread().addOperationHandle(hiveOperationContext.m_fetchResultsReq.getOperationHandle());
                hiveOperationContext.m_heartbeatRegistered = true;
            }
            return hiveOperationContext;
        }
        catch (TTransportException tTransportException) {
            ErrorException errorException = null != tTransportException.getCause() && tTransportException.getCause() instanceof SocketTimeoutException ? (0L != hiveOperationContext.m_timeoutVal ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)}, (Throwable)tTransportException, ExceptionType.TIME_OUT) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)}, (Throwable)tTransportException)) : this.handleTTransportException(tTransportException, "GetOperationStatus for query \"" + CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings) + "\"");
            throw errorException;
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_GENERAL.name(), new String[]{"HY000", CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings), exception.getMessage()}, (Throwable)exception);
            throw errorException;
        }
    }

    public void renewDelegationToken(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TRenewDelegationTokenReq tRenewDelegationTokenReq = new TRenewDelegationTokenReq(this.m_openSessionResp.getSessionHandle(), string);
        try {
            TRenewDelegationTokenResp tRenewDelegationTokenResp = this.m_client.RenewDelegationToken(tRenewDelegationTokenReq);
            this.checkResponseStatus(tRenewDelegationTokenResp.getStatus(), HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{tRenewDelegationTokenResp.getStatus().toString(), string});
        }
        catch (TException tException) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.RENEW_DELEGATION_TOKEN_ERR.name(), new String[]{tException.getMessage(), string});
            errorException.initCause(tException);
            throw errorException;
        }
    }

    @Override
    public void removeOperationHandleFromHeartbeatThread(HiveOperationContext hiveOperationContext) throws ErrorException {
        if (null != this.m_heartBeatThread && null != hiveOperationContext.m_fetchResultsReq) {
            this.m_heartBeatThread.removeOperationHandle(hiveOperationContext.m_fetchResultsReq.getOperationHandle());
        }
    }

    public boolean sendHeartBeat(TOperationHandle tOperationHandle) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TGetOperationStatusReq tGetOperationStatusReq = new TGetOperationStatusReq();
            TGetOperationStatusResp tGetOperationStatusResp = new TGetOperationStatusResp();
            tGetOperationStatusReq.setOperationHandle(tOperationHandle);
            tGetOperationStatusReq.setOperationHandleIsSet(true);
            tGetOperationStatusResp = this.m_client.GetOperationStatus(tGetOperationStatusReq);
            if (TStatusCode.SUCCESS_STATUS == tGetOperationStatusResp.getStatus().getStatusCode() || TStatusCode.SUCCESS_WITH_INFO_STATUS == tGetOperationStatusResp.getStatus().getStatusCode()) {
                if (TOperationState.FINISHED_STATE == tGetOperationStatusResp.getOperationState()) {
                    return true;
                }
                LogUtilities.logWarning("Got wrong status " + tGetOperationStatusResp.getStatus().getStatusCode() + " while sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The error message is: " + tGetOperationStatusResp.getStatus().getErrorMessage(), this.m_logger);
            } else {
                LogUtilities.logWarning("Got wrong status " + tGetOperationStatusResp.getStatus().getStatusCode() + " while sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The error message is: " + tGetOperationStatusResp.getStatus().getErrorMessage(), this.m_logger);
            }
        }
        catch (TTransportException tTransportException) {
            LogUtilities.logWarning("Got a TTransportExceptionwhile sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The exception is: " + tTransportException.getMessage(), this.m_logger);
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Got an Exceptionwhile sending heart beat for operation handler: " + tOperationHandle.getOperationId() + ". The exception is: " + exception.getMessage(), this.m_logger);
        }
        return false;
    }

    @Override
    public void setCurrentCatalog(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.isMultiCatalogEnabled() && this.m_settings.m_executeSetQueryOnSetCatalogCall) {
            this.runSetCatalog(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSchema(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_executeSetQueryOnSetSchemaCall) {
            this.runSetSchema(string);
        } else {
            HiveJDBCSettings hiveJDBCSettings = this.m_settings;
            synchronized (hiveJDBCSettings) {
                this.m_settings.m_Schema = string;
            }
        }
    }

    @Override
    public void setWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    protected void checkIfRespNull(TBase tBase, String string) throws ErrorException {
        if (null == tBase) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, "Unknown", "Unknown"});
            throw errorException;
        }
    }

    protected void checkOpenSessionStatus() throws ErrorException {
        try {
            String string = "OpenSession";
            this.checkIfRespNull(this.m_openSessionResp, string);
            this.checkResponseStatus(this.m_openSessionResp.getStatus(), string);
        }
        catch (ErrorException errorException) {
            this.m_hasOpenSession = false;
            throw errorException;
        }
    }

    @Override
    protected TProtocol getProtocol() {
        return this.m_client.getOutputProtocol();
    }

    protected String getServerVersion() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TGetInfoReq tGetInfoReq = new TGetInfoReq();
            tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_VER);
            tGetInfoReq.setInfoTypeIsSet(true);
            tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tGetInfoReq.setSessionHandleIsSet(true);
            TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
            String string = "GetInfo - Server Version";
            this.checkIfRespNull(tGetInfoResp, string);
            this.checkResponseStatus(tGetInfoResp.getStatus(), string);
            return tGetInfoResp.getInfoValue().getStringValue();
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_ERROR.name(), "no details available");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected String getServerVersionViaVersionQuery() throws Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            ArrayList<String> arrayList = this.runCatalogFunction("select version()", 0);
            if (arrayList.size() > 0) {
                return arrayList.get(0);
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVER_VERSION_NO_RESULT_ERROR.name());
            throw errorException;
        }
        catch (ErrorException errorException) {
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            throw errorException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected void checkResponseStatus(TStatus tStatus, String string) throws ErrorException {
        String string2 = null == tStatus ? "Unknown" : Integer.toString(tStatus.getErrorCode());
        String string3 = null == tStatus ? "Unknown" : tStatus.toString();
        this.checkResponseStatus(tStatus, HiveJDBCMessageKey.API_CALL_ERR.name(), new String[]{string, string2, string3});
    }

    protected void checkResponseStatus(TStatus tStatus, String string, String[] stringArray) throws ErrorException {
        if (null == tStatus) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string, stringArray);
            throw errorException;
        }
        if (TStatusCode.SUCCESS_STATUS != tStatus.getStatusCode() && TStatusCode.SUCCESS_WITH_INFO_STATUS != tStatus.getStatusCode()) {
            throw this.buildExceptionFromTStatus(tStatus, string, stringArray);
        }
    }

    protected boolean correctHasMoreRowsResult() {
        if (null != this.m_settings.m_isServerReturnsCorrectHasMoreRows) {
            return this.m_settings.m_isServerReturnsCorrectHasMoreRows;
        }
        return TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue() || this.m_settings.m_connDBType.equalsIgnoreCase(IMPALA_SERVER_NAME);
    }

    protected boolean isAtLeastV6ProtocolSession() {
        if (this.m_hasOpenSession && null != this.m_openSessionResp) {
            TProtocolVersion tProtocolVersion = this.m_openSessionResp.getServerProtocolVersion();
            return tProtocolVersion.getValue() >= TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue();
        }
        return false;
    }

    protected boolean supportsNamespaceInConfiguration() {
        if (this.m_hasOpenSession && null != this.m_openSessionResp) {
            TProtocolVersion tProtocolVersion = this.m_openSessionResp.getServerProtocolVersion();
            return tProtocolVersion.getValue() >= TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V4.getValue();
        }
        return false;
    }

    protected void openSession() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            TOpenSessionReq tOpenSessionReq = this.createOpenSessionReq();
            boolean bl = this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol();
            if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
                block34: {
                    try {
                        this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                        this.checkOpenSessionStatus();
                        this.m_hasOpenSession = true;
                        this.m_settings.m_isConnAlive = true;
                    }
                    catch (TProtocolException tProtocolException) {
                        if (this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol() && tProtocolException.getMessage().toUpperCase().contains(CLIENT_PROTOCOL_ERR_KEYWORD)) {
                            LogUtilities.logInfo("Error received when leaving the client protocol unset, trying OpenSession again with highest supported protocol: " + this.m_settings.m_platformVersionUtils.getHighestClientProtocol().toString(), this.m_logger);
                            tOpenSessionReq.setClient_protocol(this.m_settings.m_platformVersionUtils.getHighestClientProtocol());
                            try {
                                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                                this.checkOpenSessionStatus();
                                this.m_hasOpenSession = true;
                            }
                            catch (TApplicationException tApplicationException) {
                                if (tApplicationException.getMessage().toUpperCase().contains(CLIENT_PROTOCOL_ERR_KEYWORD)) {
                                    tOpenSessionReq = this.createOpenSessionReq();
                                    tOpenSessionReq.setClient_protocol(DEFAULT_HIVE_CLI_SERVICE_PROTOCOL);
                                    bl = false;
                                    this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                                    this.checkOpenSessionStatus();
                                    this.m_hasOpenSession = true;
                                }
                                break block34;
                            }
                        }
                        throw tProtocolException;
                    }
                }
                if (bl && this.m_settings.m_platformVersionUtils.isSupportedProtocol(this.m_openSessionResp.getServerProtocolVersion())) {
                    this.m_settings.m_protocolVersion = this.m_openSessionResp.getServerProtocolVersion();
                }
                this.m_settings.m_strServerVersion = this.m_openSessionResp.isSetGetInfos() && 2 == this.m_openSessionResp.getGetInfos().size() ? this.m_openSessionResp.getGetInfos().get(1).getStringValue() : this.getServerVersion();
                if (this.m_settings.m_connDBType.equals(IMPALA_SERVER_NAME)) {
                    this.regroupImpalaServerVersion();
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                } else {
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                    this.setSparkServerVersion();
                }
                if (DEFAULT_HIVE_CLI_SERVICE_PROTOCOL == this.m_settings.m_protocolVersion && (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion) || this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion) || this.m_settings.m_platformVersionUtils.supportsV8Protocol(this.m_settings.m_serverVersion))) {
                    this.safeCloseSession();
                    this.m_hasOpenSession = false;
                }
            }
            if (!this.m_settings.m_platformVersionUtils.supportPushdownCatalogFilter(this.m_settings.m_serverVersion)) {
                this.m_settings.m_pushdownCatalogFunctionFilters = false;
            }
            if (DEFAULT_HIVE_CLI_SERVICE_PROTOCOL == this.m_settings.m_protocolVersion) {
                if (this.m_settings.m_platformVersionUtils.supportsV8Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
                } else if (this.m_settings.m_platformVersionUtils.supportsV6Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
                } else if (this.m_settings.m_platformVersionUtils.supportsV3Protocol(this.m_settings.m_serverVersion)) {
                    tOpenSessionReq.setClient_protocol(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
                }
            }
            if (!this.m_hasOpenSession) {
                this.m_openSessionResp = this.m_client.OpenSession(tOpenSessionReq);
                this.checkOpenSessionStatus();
                this.m_hasOpenSession = true;
                this.m_settings.m_isConnAlive = true;
            }
            if (this.m_settings.m_dbmsName.isEmpty() || this.m_settings.m_isSparkLivyServer) {
                this.m_settings.m_dbmsName = this.m_openSessionResp.isSetGetInfos() && 1 <= this.m_openSessionResp.getGetInfos().size() ? this.m_openSessionResp.getGetInfos().get(0).getStringValue() : this.getDbmsProdName();
            }
            this.setProtocolSpecificSettings();
            this.setMultiCatalogSettings();
            this.setLivySettings();
            boolean bl2 = false;
            if (this.supportsNamespaceInConfiguration()) {
                if (!this.m_openSessionResp.isSetInitialNamespace()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_NOT_SET.name());
                    throw errorException;
                }
                TNamespace tNamespace = this.m_openSessionResp.getInitialNamespace();
                if (!tNamespace.isSetCatalogName()) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_CATALOG_NOT_SET.name());
                    throw errorException;
                }
                this.m_settings.m_catalog = tNamespace.getCatalogName();
                if (tNamespace.isSetSchemaName()) {
                    this.m_settings.m_Schema = tNamespace.getSchemaName();
                    bl2 = true;
                } else {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.INITIAL_NAMESPACE_SCHEMA_NOT_SET.name());
                    CoreUtils.postWarning(errorException, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                }
            } else {
                this.m_settings.m_catalog = this.m_settings.m_platformCatalog;
            }
            if (!bl2 && !this.m_settings.m_Schema.equals("default")) {
                try {
                    this.runSetSchema(this.m_settings.m_Schema);
                }
                catch (ErrorException errorException) {
                    if (MetadataUtils.checkForCommunicationLinkFailure(errorException)) {
                        throw errorException;
                    }
                    CoreUtils.postWarning(errorException, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, errorException.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
                    HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
                    this.m_settings.m_Schema = "default";
                }
            }
            this.dbmdInfo = new DatabaseMetadataInfo(this.m_settings.m_dbmsName, this.m_settings.m_strServerVersion);
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "OpenSession");
        }
        catch (Exception exception) {
            if (exception instanceof ErrorException) {
                ((ErrorException)exception).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            }
            ErrorException errorException = null != exception.getMessage() ? HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), exception.getMessage()) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR_NO_DETAIL.name());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected String getDbmsProdName() throws ErrorException, TException {
        TGetInfoReq tGetInfoReq = new TGetInfoReq();
        tGetInfoReq.setInfoType(TGetInfoType.CLI_DBMS_NAME);
        tGetInfoReq.setInfoTypeIsSet(true);
        tGetInfoReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
        tGetInfoReq.setSessionHandleIsSet(true);
        TGetInfoResp tGetInfoResp = this.m_client.GetInfo(tGetInfoReq);
        String string = "GetInfo - Product Name";
        this.checkIfRespNull(tGetInfoResp, string);
        this.checkResponseStatus(tGetInfoResp.getStatus(), string);
        return tGetInfoResp.getInfoValue().getStringValue();
    }

    protected ArrayList<String> runCatalogFunction(String string, int n) throws ErrorException, Exception {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            ArrayList<String> arrayList = new ArrayList<String>();
            HiveExecutionContext hiveExecutionContext = this.executeStatement(string, null, null);
            if (this.m_enableArrow) {
                this.getResultSetMetadataInternal(hiveExecutionContext);
            }
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            do {
                this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                if (!rowsetBuffer.m_bufferHasMoreRows) continue;
                int n2 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getNumColumns();
                if (n2 <= n) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CATALOG_FUNCTION_COL_IDX_ERR.name(), new String[]{string, Integer.toString(n), Integer.toString(n2)});
                    throw errorException;
                }
                arrayList.addAll(((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(n));
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            Collections.sort(arrayList);
            return arrayList;
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CatalogFunction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSetCatalog(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "USE CATALOG " + string;
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string2, null, null);
        this.closeOperation(hiveExecutionContext);
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_catalog = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSetSchema(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "USE " + string;
        HiveExecutionContext hiveExecutionContext = this.executeStatement(string2, null, null);
        this.closeOperation(hiveExecutionContext);
        HiveJDBCSettings hiveJDBCSettings = this.m_settings;
        synchronized (hiveJDBCSettings) {
            this.m_settings.m_Schema = string;
        }
    }

    protected void safeCloseOperation(TOperationHandle tOperationHandle) throws ErrorException {
        TStatus tStatus = null;
        try {
            if (null != tOperationHandle) {
                TCloseOperationReq tCloseOperationReq = new TCloseOperationReq();
                tCloseOperationReq.setOperationHandle(tOperationHandle);
                TCloseOperationResp tCloseOperationResp = this.m_client.CloseOperation(tCloseOperationReq);
                String string = "CloseOperation";
                this.checkIfRespNull(tCloseOperationResp, string);
                tStatus = tCloseOperationResp.getStatus();
                this.checkResponseStatus(tStatus, string);
            }
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CloseOperation");
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
            if (null != tStatus) {
                this.m_warningListener.postWarning(this.buildWarningFromTStatus(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name(), tStatus));
            }
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    protected void safeCloseSession() throws ErrorException {
        try {
            TCloseSessionReq tCloseSessionReq = new TCloseSessionReq();
            tCloseSessionReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            tCloseSessionReq.setSessionHandleIsSet(true);
            TCloseSessionResp tCloseSessionResp = this.m_client.CloseSession(tCloseSessionReq);
            String string = "CloseSession";
            this.checkIfRespNull(tCloseSessionResp, string);
            this.checkResponseStatus(tCloseSessionResp.getStatus(), string);
        }
        catch (TTransportException tTransportException) {
            throw this.handleTTransportException(tTransportException, "CloseSession");
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
        }
    }

    protected ErrorException buildExceptionFromTStatus(TStatus tStatus, String string, String[] stringArray) {
        String string2 = null;
        if (tStatus.isSetSqlState()) {
            string2 = tStatus.getSqlState();
        }
        return this.buildExceptionFromTStatusSqlState(string2, string, stringArray);
    }

    protected ErrorException buildExceptionFromTStatusSqlState(String string, String string2, String[] stringArray) {
        ErrorException errorException = this.m_settings.m_useSqlStateFromServer != false && null != string && 5 == string.length() ? HiveJDBCCommonDriver.s_HiveMessages.createCustomException(string, string2, stringArray) : HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(string2, stringArray);
        return errorException;
    }

    private Warning buildWarningFromTStatus(String string, TStatus tStatus) {
        if (null != tStatus.getInfoMessages() && tStatus.getInfoMessages().size() > 0) {
            String[] stringArray = new String[tStatus.getInfoMessages().size()];
            tStatus.getInfoMessages().toArray(stringArray);
            return new Warning(WarningCode.GENERAL_WARNING, 101, string, stringArray);
        }
        return new Warning(WarningCode.GENERAL_WARNING, 101, string, new String[]{tStatus.getErrorMessage(), Integer.toString(tStatus.getErrorCode())});
    }

    private void checkNumModifiedRows(TGetOperationStatusResp tGetOperationStatusResp, HiveOperationContext hiveOperationContext) throws TException, ErrorException {
        if (this.m_settings.m_supportsNumRowsModified && tGetOperationStatusResp.isSetNumModifiedRows()) {
            hiveOperationContext.m_rowCount = tGetOperationStatusResp.getNumModifiedRows();
            return;
        }
        if (hiveOperationContext.m_hasOpenOperation && hiveOperationContext.m_isExecutionComplete && this.m_settings.m_supportsDMLResults && hiveOperationContext.m_hasRowcountResult) {
            try {
                TCloseImpalaOperationReq tCloseImpalaOperationReq = new TCloseImpalaOperationReq(hiveOperationContext.getOperationHandle());
                TCloseImpalaOperationResp tCloseImpalaOperationResp = this.m_client.CloseImpalaOperation(tCloseImpalaOperationReq);
                this.checkResponseStatus(tCloseImpalaOperationResp.getStatus(), "closeImpalaOperation");
                hiveOperationContext.m_hasOpenOperation = false;
                if (tCloseImpalaOperationResp.isSetDml_result()) {
                    TDmlResult tDmlResult = tCloseImpalaOperationResp.getDml_result();
                    if (tDmlResult.isSetRows_modified()) {
                        long l = 0L;
                        for (Map.Entry<String, Long> entry : tDmlResult.getRows_modified().entrySet()) {
                            LogUtilities.logTrace("Partition name: " + entry.getKey() + ", Modify count: " + entry.getValue(), this.m_logger);
                            l += entry.getValue().longValue();
                        }
                        hiveOperationContext.m_rowCount = l;
                    }
                    if (tDmlResult.isSetNum_row_errors() && 0L < tDmlResult.getNum_row_errors()) {
                        this.m_warningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, "The server returned" + Long.toString(tDmlResult.getNum_row_errors()) + "row errors for the DML statement."));
                    }
                } else {
                    LogUtilities.logDebug("CloseImpalaOperation successful, but no DmlResult returned.", this.m_logger);
                }
            }
            catch (TException tException) {
                if (tException instanceof TApplicationException && tException.getMessage().contains("CloseImpalaOperation")) {
                    LogUtilities.logWarning("CloseImpalaOperation not supported, setting supportsDMLResults to false: " + tException.getLocalizedMessage(), this.m_logger);
                    this.m_settings.m_supportsDMLResults = false;
                }
                throw tException;
            }
        }
    }

    private TExecuteStatementReq createExecuteStatementReq() {
        TExecuteStatementReq tExecuteStatementReq = new TExecuteStatementReq();
        if (this.m_enableDirectResults) {
            LogUtilities.logDebug("DirectResults is enabled for execution", this.m_logger);
            TSparkGetDirectResults tSparkGetDirectResults = new TSparkGetDirectResults(this.m_settings.m_rowsFetchedPerBlock);
            if (this.m_enableArrow) {
                tSparkGetDirectResults.setMaxBytes(this.m_settings.m_arrowMaxBytesPerFetch);
            }
            tExecuteStatementReq.setGetDirectResults(tSparkGetDirectResults);
        }
        if (this.m_enableArrow) {
            if (this.m_settings.m_downloadableResultSettings.m_isEnableQueryResultDownload) {
                tExecuteStatementReq.setCanDownloadResult(true);
                if (this.m_settings.m_downloadableResultSettings.m_maxBytesPerFile != DownloadableResultSettings.MAX_BYTES_PER_FILE_IS_NOT_SET) {
                    tExecuteStatementReq.setMaxBytesPerFile(this.m_settings.m_downloadableResultSettings.m_maxBytesPerFile);
                }
            }
            tExecuteStatementReq.setCanDecompressLZ4Result(this.m_settings.m_isEnableQueryResultLZ4Compression);
            tExecuteStatementReq.setCanReadArrowResult(true);
        }
        return tExecuteStatementReq;
    }

    private TOpenSessionReq createOpenSessionReq() {
        Cloneable cloneable;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TOpenSessionReq tOpenSessionReq = new TOpenSessionReq();
        tOpenSessionReq.setClient_protocol(DEFAULT_HIVE_CLI_SERVICE_PROTOCOL);
        if (this.m_settings.m_platformVersionUtils.supportsUnsetClientProtocol()) {
            LogUtilities.logDebug("Setting client protocol as unset to get highest supported version by the server", this.m_logger);
            tOpenSessionReq.setClient_protocolIsSet(false);
            if (this.m_settings.m_isPassMaxProtocolVerInOpenSessionReq) {
                tOpenSessionReq.setClient_protocol_i64(this.m_settings.m_platformVersionUtils.getHighestClientProtocol().getValue());
            }
        } else {
            tOpenSessionReq.setClient_protocolIsSet(true);
        }
        if (null != this.m_settings.m_delegationUID) {
            cloneable = new HashMap<String, String>();
            cloneable.put(this.m_settings.m_platformDelegationUIDPropertyKey, this.m_settings.m_delegationUID);
            tOpenSessionReq.setConfiguration((Map<String, String>)((Object)cloneable));
        }
        if (AuthMech.UIDPWD == this.m_settings.m_authMech && TransportMode.BINARY == this.m_settings.m_transportMode) {
            tOpenSessionReq.setUsername(this.m_settings.m_username);
            tOpenSessionReq.setPassword(this.m_settings.m_password);
        } else if (this.m_settings.m_platformVersionUtils.sendUidViaOpenSessionReq(this.m_settings.m_authMech) && null != this.m_settings.m_username) {
            tOpenSessionReq.setUsername(this.m_settings.m_username);
        }
        LogUtilities.logDebug("Setting GetInfos in the OpenSession request", this.m_logger);
        cloneable = new ArrayList();
        cloneable.add(0, TGetInfoType.CLI_DBMS_NAME);
        if (!this.m_settings.m_platformVersionUtils.isServerVersionSet(this.m_settings.m_serverVersion)) {
            cloneable.add(1, TGetInfoType.CLI_DBMS_VER);
        }
        tOpenSessionReq.setGetInfos((List<TGetInfoType>)((Object)cloneable));
        if (this.m_settings.m_thriftHTTPSettings.m_enableSessionTag) {
            this.m_settings.m_thriftHTTPSettings.setThriftSessionTag(this.m_logger);
        }
        String string = null;
        String string2 = null;
        if (this.m_settings.m_catalogSetByUser && null != this.m_settings.m_catalog) {
            string = this.m_settings.m_catalog;
        }
        if (null != this.m_settings.m_Schema) {
            string2 = this.m_settings.m_Schema;
        }
        if (null != string || null != string2) {
            TNamespace tNamespace = new TNamespace();
            if (null != string) {
                tNamespace.setCatalogName(string);
            }
            if (null != string2) {
                tNamespace.setSchemaName(string2);
            }
            tOpenSessionReq.setInitialNamespace(tNamespace);
        }
        if (!this.m_settings.m_applySSPWithQueries && null != this.m_settings.m_sspValues) {
            for (String string3 : this.m_settings.m_sspValues.keySet()) {
                tOpenSessionReq.putToConfiguration(string3, this.m_settings.m_sspValues.get(string3));
            }
        }
        tOpenSessionReq.putToConnectionProperties("UseNativeQuery", String.valueOf(this.m_settings.m_useNativeQueryVal));
        if (this.m_settings.m_proxySettings.m_useProxy && this.m_settings.m_proxySettings.m_isHostInProxyIgnoreList.booleanValue()) {
            tOpenSessionReq.putToConnectionProperties("UseProxy", "0");
        } else {
            tOpenSessionReq.putToConnectionProperties("UseProxy", this.m_settings.m_proxySettings.m_useProxy ? "1" : "0");
        }
        if (null != this.m_settings.m_databricksCatalogSSP) {
            tOpenSessionReq.putToConfiguration("databricks.catalog", this.m_settings.m_databricksCatalogSSP);
        }
        tOpenSessionReq.setCanUseMultipleCatalogs(this.m_settings.m_requestEnableMultiCatalog);
        return tOpenSessionReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HiveExecutionContext executeStatementInternal(String string, IExecutorUtility iExecutorUtility, HiveJDBCStatement hiveJDBCStatement, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl2 = false;
        try {
            Object object;
            Object object2;
            long l = 0L;
            boolean bl3 = this.m_settings.m_platformVersionUtils.supportsAsynchronousOperations(this.m_settings.m_serverVersion);
            HiveExecutionContext hiveExecutionContext = this.createExecutionContext();
            TExecuteStatementReq tExecuteStatementReq = this.createExecuteStatementReq();
            tExecuteStatementReq.setSessionHandle(this.m_openSessionResp.getSessionHandle());
            if (string.startsWith(SET_CASE)) {
                object2 = "\n";
                object = "\r";
                String string2 = " ";
                boolean bl4 = this.m_settings.m_platformVersionUtils.supportsNewLineCharacter(this.m_settings.m_serverVersion);
                if (!bl4) {
                    string = string.replace((CharSequence)object2, string2).replace((CharSequence)object, string2);
                }
            }
            tExecuteStatementReq.setStatement(string);
            hiveExecutionContext.m_operation = string;
            if (bl3) {
                tExecuteStatementReq.setRunAsyncIsSet(true);
                tExecuteStatementReq.setRunAsync(true);
            }
            if (this.m_settings.m_useNativeQuery && this.m_settings.m_enableNativeParameterizedQuery.booleanValue() && this.m_settings.m_platformVersionUtils.supportsNativeModeParameterizedQuery(this.m_settings) && (HiveJDBCNativeQueryExecutor)iExecutorUtility != null && (object2 = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).getParameterList()) != null) {
                tExecuteStatementReq.setParameters((List<TSparkParameter>)object2);
            }
            object = this;
            synchronized (object) {
                if (null != iExecutorUtility && 0 != iExecutorUtility.getQueryTimeout()) {
                    l = iExecutorUtility.getQueryTimeout();
                    bl2 = true;
                    if (!bl3) {
                        this.setSocketTimeout(iExecutorUtility.getQueryTimeout());
                    } else {
                        this.setSocketTimeout(this.m_settings.m_timeout);
                    }
                } else {
                    this.setSocketTimeout(this.m_settings.m_timeout);
                }
                this.m_settings.m_thriftHTTPSettings.m_currentQuery = string;
                if (null != iExecutorUtility) {
                    hiveExecutionContext.setStatement(iExecutorUtility.getStatement());
                    if (hiveExecutionContext.isCanceled()) {
                        throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
                    }
                }
                hiveExecutionContext.m_executeResponse = object2 = this.m_client.ExecuteStatement(tExecuteStatementReq);
            }
            if (hiveExecutionContext.m_executeResponse.isSetDirectResults()) {
                hiveExecutionContext.handleDirectResultsResp(this.m_logger, hiveExecutionContext.m_executeResponse.getDirectResults());
            }
            hiveExecutionContext.m_startTime = System.currentTimeMillis();
            hiveExecutionContext.m_timeoutVal = l;
            if (null != iExecutorUtility) {
                iExecutorUtility.setExeContext(hiveExecutionContext);
            }
            this.checkResponseStatus(((TExecuteStatementResp)object2).getStatus(), HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_FROM_SERVER.name(), new String[]{String.valueOf(((TExecuteStatementResp)object2).getStatus().getErrorCode()), ((TExecuteStatementResp)object2).getStatus().getSqlState(), string, ((TExecuteStatementResp)object2).getStatus().isSetErrorMessage() ? ((TExecuteStatementResp)object2).getStatus().getErrorMessage() : NO_ERROR_MESSAGE_FROM_SERVER});
            if (iExecutorUtility instanceof HiveJDBCNativeQueryExecutor) {
                hiveExecutionContext.m_hasRowcountResult = ((HiveJDBCNativeQueryExecutor)iExecutorUtility).isRowCountQuery();
            }
            this.storeQueryId(hiveExecutionContext, hiveJDBCStatement);
            if (bl) {
                return hiveExecutionContext;
            }
            return (HiveExecutionContext)this.pollForOperationCompletion(hiveExecutionContext);
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (TTransportException tTransportException) {
            if (null != tTransportException.getCause() && tTransportException.getCause() instanceof SocketTimeoutException) {
                if (bl2) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException, ExceptionType.TIME_OUT);
                    throw errorException;
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_STMT_EXEC_SOCKETTIMEOUT_ERR.name(), new String[]{string}, (Throwable)tTransportException);
                throw errorException;
            }
            throw this.handleTTransportException(tTransportException, "ExecuteStatment for query \"" + string + "\"");
        }
        catch (Exception exception) {
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR_GENERAL.name(), new String[]{"HY000", string, exception.getMessage()}, (Throwable)exception);
            throw errorException;
        }
    }

    private String fullColumnTypeNameBuilder(TTypeEntry tTypeEntry) {
        TTypeQualifiers tTypeQualifiers = tTypeEntry.getPrimitiveEntry().getTypeQualifiers();
        TTypeId tTypeId = tTypeEntry.getPrimitiveEntry().getType();
        if (this.m_settings.m_platformVersionUtils.supportsCharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("CHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "CHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsVarcharLength(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("VARCHAR_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("characterMaximumLength").getI32Value();
            return "VARCHAR(" + n + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsDecimalPrecisionAndScale(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("DECIMAL_TYPE") && null != tTypeQualifiers) {
            int n = tTypeQualifiers.getQualifiers().get("precision").getI32Value();
            int n2 = tTypeQualifiers.getQualifiers().get("scale").getI32Value();
            return "DECIMAL(" + n + ", " + n2 + ")";
        }
        if (this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
            if (tTypeId.name().equalsIgnoreCase("ARRAY_TYPE")) {
                return "ARRAY";
            }
            if (tTypeId.name().equalsIgnoreCase("STRUCT_TYPE")) {
                return "STRUCT";
            }
            if (tTypeId.name().equalsIgnoreCase("MAP_TYPE")) {
                return "MAP";
            }
        }
        if (this.m_settings.m_platformVersionUtils.supportsUnionDataTypes(this.m_settings.m_serverVersion) && tTypeId.name().equalsIgnoreCase("UNION_TYPE")) {
            return "UNION";
        }
        return "null";
    }

    private void timeoutCheck(HiveOperationContext hiveOperationContext) throws ErrorException {
        if (0L != hiveOperationContext.m_timeoutVal && System.currentTimeMillis() - hiveOperationContext.m_startTime >= hiveOperationContext.m_timeoutVal) {
            hiveOperationContext.m_isManualCanceled.set(true);
            this.cancelOperation(hiveOperationContext);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.QUERY_TIMEOUT_ERR.name(), new String[]{CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings)}, ExceptionType.TIME_OUT);
            throw errorException;
        }
    }

    private void regroupImpalaServerVersion() {
        String[] stringArray = this.m_settings.m_strServerVersion.split("-");
        if (stringArray.length > 1) {
            try {
                Integer.parseInt(stringArray[0].substring(0, 1));
                this.m_settings.m_strServerVersion = stringArray[0] + "-" + stringArray[1];
            }
            catch (NumberFormatException numberFormatException) {
                this.m_settings.m_strServerVersion = stringArray[1] + "-" + stringArray[0];
            }
        }
    }

    private ArrayList<String> getQualifiedTypeNames(String string, String string2, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        if (this.m_settings.m_enableIsQualifierTypeReturnedTesting) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TYPE_QUALIFIER_SIZE_ERROR.name(), "Qualified Type Names Error");
            throw errorException;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = string == null || string.equals("") ? this.getCurrentSchema() + "." : string + ".";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string3 + string2, null, hiveJDBCStatement);
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            do {
                String string4;
                this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                int n = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getNumRowsInBuffer();
                List<String> list = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(1);
                for (int i = 0; i < n && null != (string4 = list.get(i)); ++i) {
                    arrayList.add(string4.toUpperCase().trim());
                }
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<String>();
        }
    }

    private ArrayList<HiveCommonColumnMetadata> getColumnsWithDescribeQuery(String string, String string2, String string3, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<HiveCommonColumnMetadata> arrayList = new ArrayList<HiveCommonColumnMetadata>();
        try {
            if (string3.contains("\\")) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            boolean bl = null != string2 && !string2.equals("");
            String string4 = "`" + (bl ? string2 : this.getCurrentSchema()) + "`.`" + string3 + "`";
            HiveExecutionContext hiveExecutionContext = this.executeStatement("DESCRIBE " + string4, null, hiveJDBCStatement);
            if (hiveExecutionContext == null) {
                return new ArrayList<HiveCommonColumnMetadata>();
            }
            if (this.m_enableArrow) {
                this.getResultSetMetadataInternal(hiveExecutionContext);
            }
            RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer = this.makeRowsetBuffer(hiveExecutionContext);
            block2: do {
                this.fetchNRows((HiveOperationContext)hiveExecutionContext, rowsetBuffer, this.m_settings.m_rowsFetchedPerBlock);
                this.checkFetchErrors(rowsetBuffer);
                List<String> list = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(0);
                List<String> list2 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(1);
                List<String> list3 = ((HiveServer2BaseBuffer)rowsetBuffer.m_buffer).getStringColumn(2);
                for (int i = 0; i < list.size(); ++i) {
                    String string5 = list2.get(i);
                    if (null == string5 || 0 == string5.length()) {
                        rowsetBuffer.m_bufferHasMoreRows = false;
                        continue block2;
                    }
                    string5 = string5.toUpperCase();
                    short s = DataTypeUtilities.mapHiveTypeNameToSqltype(string5, 2, this.m_settings);
                    arrayList.add(DataTypeUtilities.createColumn(string, string2, string3, list.get(i), list3.get(i), s, string5, 2, Nullable.NULLABLE.getIntValue(), this.m_settings));
                }
            } while (hiveExecutionContext.m_serverHasMoreRows);
            this.closeOperation(hiveExecutionContext);
            return arrayList;
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            CoreUtils.postWarning(exception, this.m_warningListener, WarningCode.GENERAL_WARNING, 101, exception.getLocalizedMessage(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
            HiveJDBCExceptionUtils.logException(exception, this.m_logger);
            return new ArrayList<HiveCommonColumnMetadata>();
        }
    }

    private synchronized HeartBeatThread getHeartBeatThread() {
        if (null == this.m_heartBeatThread) {
            this.m_heartBeatThread = new HeartBeatThread(this, this.m_settings.m_heartBeatInterval, this.m_logger);
        }
        return this.m_heartBeatThread;
    }

    protected ErrorException handleTTransportException(TTransportException tTransportException, String string) {
        ErrorException errorException;
        if (null != this.m_heartBeatThread) {
            try {
                this.m_heartBeatThread.stop();
            }
            catch (ErrorException errorException2) {
                HiveJDBCExceptionUtils.logException(errorException2, this.m_logger);
            }
        }
        this.m_settings.m_isConnAlive = false;
        String string2 = "";
        if (this.m_settings.m_addApiCallToTTransportExceptionMessage && !string.equals("")) {
            string2 = null == tTransportException.getMessage() || !tTransportException.getMessage().endsWith(".") ? ". " + string : " " + string;
        }
        if (tTransportException instanceof TETokenExpirationException) {
            errorException = new ErrorException("08006", 105, CommonJDBCMessageKey.CONN_OAUTH_TOKEN_EXP.name(), new String[]{(null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown") + string2});
        } else {
            errorException = new ErrorException(DiagState.DIAG_COMM_LINK_FAILURE, 101, HiveJDBCMessageKey.COMM_LINK_FAILURE.name(), new String[]{(null != tTransportException.getMessage() ? tTransportException.getMessage() : "Unknown") + string2});
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
        }
        errorException.initCause(tTransportException);
        return errorException;
    }

    private void setLivySettings() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_settings.m_isSparkLivyServer = this.m_settings.m_dbmsName.contains(SPARK_LIVY_SERVER_NAME);
        if (this.m_settings.m_isSparkLivyServer) {
            if (!this.m_settings.m_serverVersionSetByUser) {
                try {
                    this.m_settings.m_strServerVersion = this.getServerVersionViaVersionQuery();
                    this.setSparkServerVersion();
                }
                catch (Exception exception) {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_GET_SERVER_VERSION_VIA_QUERY_ERROR.name(), new String[]{SPARK_LIVY_DEFAULT_SPARK_VERSION_STR, exception.getMessage()});
                    errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                    LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
                    this.m_settings.m_strServerVersion = SPARK_LIVY_DEFAULT_SPARK_VERSION_STR;
                    this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
                }
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.USER_SERVER_VERSION_DISABLE_VERSION_QUERY.name(), this.m_settings.m_strServerVersion);
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            }
        }
    }

    private void setMultiCatalogSettings() throws ErrorException {
        boolean bl;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl2 = bl = this.m_openSessionResp.isSetCanUseMultipleCatalogs() && this.m_openSessionResp.isCanUseMultipleCatalogs();
        if (!this.m_settings.m_requestEnableMultiCatalog && bl) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SERVER_IGNORE_DISABLE_MULTICATALOG.name());
            throw errorException;
        }
        this.m_settings.m_enableMultiCatalog = bl;
        if (this.m_settings.m_enableMultiCatalog) {
            this.m_settings.m_executeSetQueryOnSetCatalogCall = true;
            this.m_settings.m_acceptEmptyStringAsCatalog = true;
            this.m_settings.m_convertSyntheticCatalogToNullForCatalogFunc = true;
            this.m_settings.m_trackCatalogFromQueries = true;
            this.m_settings.m_convertSyntheticCatalogToCurrCatalogForQuery = true;
        }
    }

    private void setProtocolSpecificSettings() {
        boolean bl;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_enableDirectResults = this.m_settings.m_enableDirectResults && TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_settings.m_mapEmptyTableTypeToTable = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V2.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_enableArrow = this.m_settings.m_enableArrow && TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        this.m_settings.m_isServerSupportsNamespace = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V4.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        boolean bl2 = bl = TProtocolVersion.SPARK_CLI_SERVICE_PROTOCOL_V1.getValue() <= this.m_openSessionResp.getServerProtocolVersion().getValue();
        if (!bl && !this.m_settings.m_applySSPWithQueries) {
            if (!this.m_settings.m_bypassChecksForSSPWithQueries) {
                this.m_settings.m_applySSPWithQueries = true;
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DRIVER_ENABLE_SSP_WITH_QUERY_NO_CONF_OVERLAY.name(), "ApplySSPWithQueries");
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.BYPASS_CHECK_FOR_SSP_WITH_QUERY_NO_CONF_OVERLAY.name(), "ApplySSPWithQueries");
                errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(errorException.getMessage(), this.m_logger);
            }
        }
    }

    private void setSparkServerVersion() throws ErrorException, Exception {
        Object object;
        boolean bl = false;
        String string = null;
        if (this.m_settings.m_dbmsName.contains(SPARK_SERVER_NAME) || this.m_settings.m_dbmsName.contains(SPARK_LIVY_SERVER_NAME)) {
            bl = true;
            string = this.m_settings.m_strServerVersion;
        } else if (this.m_settings.m_strServerVersion.contains("shark")) {
            bl = true;
            object = SHARK_HIVE_VERSION.matcher(this.m_settings.m_strServerVersion);
            if (((Matcher)object).find()) {
                string = ((Matcher)object).group(2);
            }
        } else if (!this.m_settings.m_dbmsName.contains(IMPALA_SERVER_NAME)) {
            object = this.runCatalogFunction(SET_DASH_V_QUERY_STRING, 0);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                if (!((String)((ArrayList)object).get(i)).matches(SHARK_REGEX)) continue;
                bl = true;
                string = HIVE_SPARK_VERSION_MAP.get(this.m_settings.m_strServerVersion.substring(0, 4));
            }
        }
        if (bl && SPARK_SERVER_NAME.equals(this.m_settings.m_connDBType)) {
            this.m_settings.m_strServerVersion = string;
            this.m_settings.m_serverVersion = this.m_settings.m_platformVersionUtils.parseServerVersion(this.m_settings.m_strServerVersion, this.m_logger);
        }
        if (bl && !SPARK_SERVER_NAME.equals(this.m_settings.m_connDBType) || !bl && SPARK_SERVER_NAME.equals(this.m_settings.m_connDBType)) {
            object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_SESSION_ERR.name(), "Incorrect Server Type Connected To.");
            throw object;
        }
    }

    private String[] parseFilters(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList) {
        return this.parseFilters(map, arrayList, false);
    }

    private String[] parseFilters(Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String[] stringArray = new String[]{null, null, null, null, null};
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        String string5 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        if (bl && null != string) {
            string = MetadataUtils.EscapeWildCard(string, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string2) {
            string2 = MetadataUtils.EscapeWildCard(string2, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string3) {
            string3 = MetadataUtils.EscapeWildCard(string3, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string4) {
            string4 = MetadataUtils.EscapeWildCard(string4, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != string5) {
            string5 = MetadataUtils.EscapeWildCard(string5, MetadataUtils.CATALOG_FUNC_WILDCARD_CHARS, '\\');
        }
        if (null != arrayList) {
            if (null == string && arrayList.size() > MetadataUtils.CATALOG_PATTERN_IDX) {
                string = arrayList.get(MetadataUtils.CATALOG_PATTERN_IDX);
            }
            if (null == string2 && arrayList.size() > MetadataUtils.SCHEMA_PATTERN_IDX) {
                string2 = arrayList.get(MetadataUtils.SCHEMA_PATTERN_IDX);
            }
            if (null == string3 && arrayList.size() > MetadataUtils.TABLE_PATTERN_IDX) {
                string3 = arrayList.get(MetadataUtils.TABLE_PATTERN_IDX);
            }
            if (null == string4 && arrayList.size() > MetadataUtils.COLUMN_PATTERN_IDX) {
                string4 = arrayList.get(MetadataUtils.COLUMN_PATTERN_IDX);
            }
            if (null == string5 && arrayList.size() > MetadataUtils.FUNCTION_PATTERN_IDX) {
                string5 = arrayList.get(MetadataUtils.FUNCTION_PATTERN_IDX);
            }
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
        stringArray[3] = string4;
        stringArray[4] = string5;
        return stringArray;
    }

    private boolean isNonCurrentCatalog(String string, String string2) {
        return string2 != null && !string2.isEmpty() && !string.equalsIgnoreCase(string2);
    }

    private boolean mismatchedCatalogOrTempCatalog(String string, String string2) {
        return !this.m_settings.m_globalTempCatalog.equalsIgnoreCase(string2) && (!this.m_settings.m_acceptEmptyStringAsCatalog || !string2.isEmpty()) && !string.equalsIgnoreCase(string2);
    }

    private boolean isNonPlatformCatalog(String string) {
        return string != null && !string.equalsIgnoreCase(this.m_settings.m_platformCatalog);
    }

    @Override
    public List<String> getQueryLog(HiveOperationContext hiveOperationContext, boolean bl, int n) throws ErrorException {
        ArrayList<String> arrayList;
        block10: {
            TRowSet tRowSet;
            block11: {
                Object object;
                if (hiveOperationContext == null) {
                    return Collections.emptyList();
                }
                if (hiveOperationContext.isCanceled()) {
                    throw new OperationCanceledException(101, HiveJDBCMessageKey.HIVE_OP_CANCEL.name());
                }
                try {
                    object = new TFetchResultsReq(hiveOperationContext.getOperationHandle(), bl ? TFetchOrientation.FETCH_NEXT : TFetchOrientation.FETCH_FIRST, n);
                    ((TFetchResultsReq)object).setFetchType((short)1);
                    hiveOperationContext.queryLogResultsResp = this.m_client.FetchResults((TFetchResultsReq)object);
                }
                catch (TException tException) {
                    ErrorException errorException;
                    this.closeOperation(hiveOperationContext);
                    if (tException instanceof TTransportException) {
                        errorException = this.handleTTransportException((TTransportException)tException, "FetchResults for query \"" + CoreUtils.redactQuery(hiveOperationContext.m_operation, this.m_settings) + "\"");
                    } else {
                        errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), tException.getMessage());
                        errorException.initCause(tException);
                    }
                    throw errorException;
                }
                object = hiveOperationContext.queryLogResultsResp.getStatus().getStatusCode();
                arrayList = new ArrayList<String>();
                if (TStatusCode.SUCCESS_STATUS != object && TStatusCode.SUCCESS_WITH_INFO_STATUS != object || hiveOperationContext.queryLogResultsResp == null || !hiveOperationContext.queryLogResultsResp.isSetResults()) break block10;
                tRowSet = hiveOperationContext.queryLogResultsResp.getResults();
                if (tRowSet.getRowsSize() <= 0) break block11;
                for (int i = 0; i < tRowSet.getRowsSize(); ++i) {
                    List<TColumnValue> list = tRowSet.getRows().get(i).getColVals();
                    for (int j = 0; j < list.size(); ++j) {
                        arrayList.add(list.get(j).getStringVal().getValue());
                    }
                }
                break block10;
            }
            if (tRowSet.getColumns().size() <= 0) break block10;
            for (int i = 0; i < tRowSet.getColumns().size(); ++i) {
                List<String> list = tRowSet.getColumns().get(i).getStringVal().getValues();
                for (int j = 0; j < list.size(); ++j) {
                    arrayList.add(list.get(j));
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasMoreLogs(HiveOperationContext hiveOperationContext) {
        if (hiveOperationContext == null) {
            return true;
        }
        if (null == hiveOperationContext.queryLogResultsResp) {
            return true;
        }
        if (null == hiveOperationContext.queryLogResultsResp.getResults()) {
            return false;
        }
        int n = this.getNumRows(hiveOperationContext.queryLogResultsResp.getResults(), this.m_logger);
        boolean bl = false;
        if (hiveOperationContext.queryLogResultsResp.getResults().isSetResultLinks()) {
            TSparkArrowResultLink tSparkArrowResultLink;
            int n2 = 0;
            Iterator<TSparkArrowResultLink> iterator = hiveOperationContext.queryLogResultsResp.getResults().getResultLinks().iterator();
            while (iterator.hasNext() && (n2 = (int)((long)n2 + (tSparkArrowResultLink = iterator.next()).getRowCount())) <= 0) {
            }
            bl = 0 < n2;
        } else {
            boolean bl2 = bl = 0 < n;
        }
        if (this.correctHasMoreRowsResult()) {
            bl = hiveOperationContext.queryLogResultsResp.isHasMoreRows();
        }
        return bl;
    }

    private int getNumRows(TRowSet tRowSet, ILogger iLogger) {
        TColumn tColumn;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        int n = tRowSet.getRowsSize() > 0 ? tRowSet.getRowsSize() : (tRowSet.getColumns().size() > 0 ? ((tColumn = tRowSet.getColumns().get(0)).isSetBinaryVal() ? tColumn.getBinaryVal().getValuesSize() : (tColumn.isSetBoolVal() ? tColumn.getBoolVal().getValuesSize() : (tColumn.isSetByteVal() ? tColumn.getByteVal().getValuesSize() : (tColumn.isSetDoubleVal() ? tColumn.getDoubleVal().getValuesSize() : (tColumn.isSetI16Val() ? tColumn.getI16Val().getValuesSize() : (tColumn.isSetI32Val() ? tColumn.getI32Val().getValuesSize() : (tColumn.isSetI64Val() ? tColumn.getI64Val().getValuesSize() : tColumn.getStringVal().getValuesSize()))))))) : 0);
        return n;
    }

    public void storeQueryId(HiveOperationContext hiveOperationContext, HiveJDBCStatement hiveJDBCStatement) {
        byte[] byArray = hiveOperationContext.getOperationHandle().getOperationId().getGuid();
        String string = hiveOperationContext.getOperationHandle().getOperationType().toString();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        String string2 = new UUID(l, l2).toString();
        if (null != hiveJDBCStatement) {
            if (null == hiveJDBCStatement.m_queryIds || string.equals((Object)QueryProfile.QueryTypes.EXECUTE_STATEMENT)) {
                hiveJDBCStatement.m_queryIds = new LinkedList();
            }
            hiveJDBCStatement.m_queryIds.addLast(string2);
            if (hiveJDBCStatement.m_queryIds.size() > this.m_settings.m_queryIDLimit) {
                hiveJDBCStatement.m_queryIds.removeFirst();
            }
            if (null == hiveJDBCStatement.m_opTypes || string.equals((Object)QueryProfile.QueryTypes.EXECUTE_STATEMENT)) {
                hiveJDBCStatement.m_opTypes = new LinkedList();
            }
            hiveJDBCStatement.m_opTypes.addLast(string);
            if (hiveJDBCStatement.m_opTypes.size() > this.m_settings.m_queryIDLimit) {
                hiveJDBCStatement.m_opTypes.removeFirst();
            }
        }
    }

    static {
        DEFAULT_HIVE_CLI_SERVICE_PROTOCOL = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
        HIVE_SPARK_VERSION_MAP = new HashMap<String, String>();
        HIVE_SPARK_VERSION_MAP.put("0.11", "0.9");
        HIVE_SPARK_VERSION_MAP.put("0.12", "1.1");
    }
}

