/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.hivecommon.HttpErrorEmulationSettings;
import com.cloudera.hiveserver1.hivecommon.HttpRetrySettings;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TEHTTPSettings {
    private static final int USER_AGENT_CHAR_BEGIN_OCTET = 0;
    private static final int USER_AGENT_CHAR_END_OCTET = 127;
    private static final int USER_AGENT_CTL_BEGIN_OCTET = 0;
    private static final int USER_AGENT_CTL_END_OCTET = 31;
    private static final String CLOSING_PAREN_STR = ")";
    private static final String OPENING_PAREN_STR = "(";
    private static final String SLASH_CHAR_STR = "/";
    private static final String THRIFT_SESSION_TAG_HEADER = "X-Thriftserver-Session-Tag";
    private static final String THRIFT_USER_ENTRY = " Java/THttpClient/HC ";
    private static final String USER_AGENT_SEPARATORS = "()<>@,;:\\\"/[]?={} \t";
    public boolean m_enableSessionTag = false;
    private Map<String, String> m_customHeaders = null;
    public ArrayList<HttpRetrySettings> m_httpRetrySettingsList = null;
    public Map<String, HttpErrorEmulationSettings> m_httpErrorEmulationSettingsMap = null;
    public HttpErrorEmulationSettings m_currentHttpErrorEmulationSettings = null;
    public String m_currentAPICall = null;
    public String m_currentQuery = null;
    public boolean m_enableZeroRowsTesting = false;
    public int m_emulateZeroRowBlocks = 0;
    public String m_userAgentEntry = TEHTTPSettings.createUserAgentDefault();
    public boolean m_isOAuth;
    public boolean m_retrieveErrorFromBody = false;
    public int m_resultSetBlocksFetched = 0;
    public boolean m_throwDifferentExceptionOnRedirect = false;

    public TEHTTPSettings() {
        this.m_httpRetrySettingsList = new ArrayList();
        this.m_httpErrorEmulationSettingsMap = new HashMap<String, HttpErrorEmulationSettings>();
    }

    public void addCustomHeader(String string, String string2) {
        if (null == this.m_customHeaders) {
            this.m_customHeaders = new HashMap<String, String>();
        }
        this.m_customHeaders.put(string, string2);
    }

    public Map<String, String> getCustomHeaders() {
        return this.m_customHeaders;
    }

    public String removeCustomHeader(String string) {
        if (null != this.m_customHeaders) {
            return this.m_customHeaders.remove(string);
        }
        return null;
    }

    public void removeThriftSessionTag(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = this.removeCustomHeader(THRIFT_SESSION_TAG_HEADER);
        LogUtilities.logDebug("Removed Thrift session tag in HTTP header: " + string, iLogger);
    }

    public void setLegacyUserAgent() {
        this.m_userAgentEntry = THRIFT_USER_ENTRY;
    }

    public void setCustomHeaders(Map<String, String> map) {
        this.m_customHeaders = map;
    }

    public void setThriftSessionTag(ILogger iLogger) {
        String string = UUID.randomUUID().toString();
        LogUtilities.logDebug("Setting Thrift session tag in HTTP header: " + string, iLogger);
        this.addCustomHeader(THRIFT_SESSION_TAG_HEADER, string);
    }

    public void setUserAgentEntry(Variant variant) throws ErrorException {
        String string = variant.getString();
        if (this.validUserAgentEntry(string)) {
            this.m_userAgentEntry = this.m_userAgentEntry.concat(string);
            return;
        }
    }

    private static String createUserAgentDefault() {
        String string = MessageFormat.format("{0,number,0}.{1,number,00}.{2,number,00}", 2, 6, 29);
        String string2 = "HiveJDBC";
        string2 = string2.replace("JDBC", "JDBCDriver");
        string2 = string2.replaceAll("\\s", "");
        String string3 = "Cloudera" + string2;
        return string3 + SLASH_CHAR_STR + string + THRIFT_USER_ENTRY;
    }

    private boolean containsUserAgentTokenCharacters(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (this.isUserAgentTokenCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private void handleInvalidUserAgentString(String string, String string2) throws ErrorException {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.USER_AGENT_ENTRY_ERROR.name(), new String[]{string, string2});
        throw errorException;
    }

    private boolean isUserAgentCommentChar(char c) {
        return !this.isUserAgentCtrlChar(c) && OPENING_PAREN_STR.charAt(0) != c && CLOSING_PAREN_STR.charAt(0) != c;
    }

    private boolean isUserAgentCtrlChar(char c) {
        return '\u0000' <= c && '\u001f' >= c;
    }

    private boolean isUserAgentTokenCharacter(char c) {
        return '\u0000' <= c && '\u007f' >= c && !this.isUserAgentCtrlChar(c) && -1 == USER_AGENT_SEPARATORS.indexOf(c);
    }

    private boolean validUserAgentEntry(String string) throws ErrorException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(OPENING_PAREN_STR);
        if (-1 != n) {
            string4 = string.substring(n);
            string4 = string4.trim();
            string2 = string.substring(0, n);
        } else {
            string2 = string;
        }
        int n2 = string2.indexOf(SLASH_CHAR_STR);
        if (-1 != n2) {
            string3 = string2.substring(n2 + 1);
            string3 = string3.trim();
            string2 = string2.substring(0, n2);
        }
        if (!(string2 = string2.trim()).isEmpty()) {
            if (!this.containsUserAgentTokenCharacters(string2)) {
                this.handleInvalidUserAgentString(string, "Invalid characters in product name");
            }
        } else if (-1 != n2) {
            this.handleInvalidUserAgentString(string, "Product name is empty");
        }
        if (null != string3 && !string3.isEmpty()) {
            if (!this.containsUserAgentTokenCharacters(string3)) {
                this.handleInvalidUserAgentString(string, "Invalid characters in product version");
            }
        } else if (-1 != n2) {
            this.handleInvalidUserAgentString(string, "Product version is empty");
        }
        if (null != string4 && !string4.isEmpty()) {
            char[] cArray;
            if (!string4.endsWith(CLOSING_PAREN_STR)) {
                this.handleInvalidUserAgentString(string, "Comment is not surrounded by parenthesis");
            }
            String string5 = string4.substring(1, string4.length() - 1);
            for (char c : cArray = string5.toCharArray()) {
                if (this.isUserAgentCommentChar(c)) continue;
                this.handleInvalidUserAgentString(string, "Invalid characters in comment");
            }
        }
        return true;
    }
}

