/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.dataengine;

import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.model.TypeCoercionMap;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;

public class HiveJDBCCoercionHandler
extends AEMetadataCoercionHandler {
    private ILogger m_logger;

    public HiveJDBCCoercionHandler(boolean bl, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, bl);
        this.m_logger = iLogger;
        this.initializeCustomTypeRanking(bl);
    }

    private AEMetadataCoercionHandler.CoercionOperation getCoercionOperation(CoercionOp coercionOp) {
        switch (coercionOp) {
            case OP_COMPARISON: {
                return AEMetadataCoercionHandler.CoercionOperation.COMPARISON;
            }
            case OP_CONCAT: {
                return null;
            }
            case OP_IN: {
                return AEMetadataCoercionHandler.CoercionOperation.IN;
            }
            case OP_LIKE: {
                return null;
            }
            case OP_UNION: {
                return AEMetadataCoercionHandler.CoercionOperation.SET_OPERATION;
            }
            case OP_DIVISION: {
                return AEMetadataCoercionHandler.CoercionOperation.DIVISION;
            }
            case OP_MINUS: {
                return AEMetadataCoercionHandler.CoercionOperation.MINUS;
            }
            case OP_PLUS: {
                return AEMetadataCoercionHandler.CoercionOperation.PLUS;
            }
            case OP_MULTIPLICATION: {
                return AEMetadataCoercionHandler.CoercionOperation.MULTIPLICATION;
            }
        }
        return null;
    }

    private void initializeCustomTypeRanking(boolean bl) {
        TypeCoercionMap[] typeCoercionMapArray;
        LogUtilities.logFunctionEntrance(this.m_logger, bl);
        if (bl && null != (typeCoercionMapArray = HiveJDBCCommonDriver.s_typeCoercionMapping)) {
            for (int i = 0; i < typeCoercionMapArray.length; ++i) {
                try {
                    TypeCoercionMap typeCoercionMap = typeCoercionMapArray[i];
                    AEMetadataCoercionHandler.CoercionOperation coercionOperation = this.getCoercionOperation(typeCoercionMap.getCoercionOp());
                    if (null == coercionOperation) continue;
                    this.overrideCoercionType(coercionOperation, typeCoercionMap.getLeftType(), typeCoercionMap.getRightType(), typeCoercionMap.getTargetType());
                    if (!typeCoercionMap.isReversible()) continue;
                    this.overrideCoercionType(coercionOperation, typeCoercionMap.getRightType(), typeCoercionMap.getLeftType(), typeCoercionMap.getTargetType());
                    continue;
                }
                catch (Exception exception) {
                    LogUtilities.logWarning("Custom coercion override failure ignored at position: " + i + " with error: " + (null == exception ? "Unknown" : exception.getMessage()), this.m_logger);
                }
            }
        }
    }

    public static enum CoercionOp {
        OP_COMPARISON,
        OP_CONCAT,
        OP_IN,
        OP_LIKE,
        OP_UNION,
        OP_DIVISION,
        OP_MINUS,
        OP_PLUS,
        OP_MULTIPLICATION;

    }
}

