/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.dataengine.metadata;

import com.cloudera.hiveserver1.dsi.dataengine.filters.IFilter;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.HiveCommonFunctionsMetadataSourceRow;
import com.cloudera.hiveserver1.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Map;

public class HiveJDBCGetFunctionsMetadataSource
implements IMetadataSource {
    private HiveJDBCSettings m_settings;
    private boolean m_hasStartedFetch = false;
    private int m_currentIndex = -1;
    private final IHiveClient<?> m_hiveClient;
    private ILogger m_logger;
    private ArrayList<HiveCommonFunctionsMetadataSourceRow> m_functions = null;
    Map<MetadataSourceColumnTag, String> m_literalRestrictions;
    ArrayList<String> m_restrictionPatterns = null;
    ArrayList<IFilter> m_filters;
    private HiveJDBCStatement m_statement;

    public HiveJDBCGetFunctionsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, ArrayList<IFilter> arrayList2, HiveJDBCSettings hiveJDBCSettings, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_literalRestrictions = map;
        this.m_restrictionPatterns = arrayList;
        this.m_filters = arrayList2;
        this.m_settings = hiveJDBCSettings;
        this.m_hiveClient = iHiveClient;
        this.initFunctions();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            HiveJDBCExceptionUtils.logException(errorException, this.m_logger);
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    private void initFunctions() throws ErrorException {
        try {
            if (null == this.m_functions) {
                this.m_functions = this.m_hiveClient.getFunctions(this.m_literalRestrictions, this.m_restrictionPatterns, this.m_statement);
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_TABLE_ERR.name(), "Metadata Initialization Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_functions.get(this.m_currentIndex).getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_functions.get(this.m_currentIndex).getSchemaName(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_functions.get(this.m_currentIndex).getFunctionName(), dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_functions.get(this.m_currentIndex).getComments(), dataWrapper, l, l2);
            }
            case PROCEDURE_TYPE: {
                dataWrapper.setSmallInt(this.m_functions.get(this.m_currentIndex).getFunctionType());
                return false;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_functions.get(this.m_currentIndex).getSpecificName(), dataWrapper, l, l2);
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentIndex >= this.m_functions.size() - 1) {
            return false;
        }
        ++this.m_currentIndex;
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
        }
        return true;
    }
}

