/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.jdbc42.future;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IResultSet;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver1.exceptions.ExceptionConverter;
import com.cloudera.hiveserver1.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.common.SResultSetMetaData;
import com.cloudera.hiveserver1.jdbc.common.future.SDatabaseMetaData;
import com.cloudera.hiveserver1.jdbc.jdbc41.future.S41MetaDataProxy;
import com.cloudera.hiveserver1.jdbc.jdbc42.S42ResultSetMetaData;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ExceptionType;
import com.cloudera.hiveserver1.utilities.JDBCVersion;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42MetaDataProxy
extends S41MetaDataProxy {
    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger) throws SQLException {
        this(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, JDBCVersion.JDBC42);
    }

    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, jDBCVersion);
    }

    @Override
    protected SResultSetMetaData createResultSetMetadata() {
        return new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener());
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

