/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.kerberos;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Scanner;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;

public class JaasConfiguration
extends Configuration {
    private String m_entryName;
    private String m_krb5LoginModuleName;
    private HashMap<String, String> m_configuration = new HashMap();
    private AppConfigurationEntry[] m_appConfigurationEntry;

    public JaasConfiguration(String string) throws LoginException, FileNotFoundException {
        this.parseJAASConfig(string);
        this.m_appConfigurationEntry = new AppConfigurationEntry[]{new AppConfigurationEntry(this.m_krb5LoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.m_configuration)};
    }

    private void parseJAASConfig(String string) throws FileNotFoundException, LoginException {
        String string2 = "";
        Scanner scanner = new Scanner(new File(string));
        while (scanner.hasNext()) {
            string2 = string2 + scanner.nextLine();
            string2 = string2 + " ";
        }
        scanner.close();
        string2 = string2.trim();
        int n = string2.indexOf("{");
        if (-1 == n) {
            throw new LoginException("Configuration Error:\nexpected [{]");
        }
        this.m_entryName = string2.substring(0, n).trim();
        int n2 = string2.length() - 1;
        int n3 = 0;
        int n4 = 59;
        while (n2 >= 0) {
            int n5 = string2.charAt(n2);
            if (n5 != n4 && Character.isWhitespace((char)n5)) {
                --n2;
                continue;
            }
            if (n5 != n4 && n4 == 59) {
                throw new LoginException("Configuration Error:\nexpected [;], read [end of file]");
            }
            if (n5 != n4 && n4 == 125) {
                throw new LoginException("Configuration Error:\nexpected [module class name], read [end of file]");
            }
            if (n4 == 59 && n3 == 0) {
                n4 = 125;
                n3 = n2--;
                continue;
            }
            if (n4 != 125) continue;
            n3 = n2;
            break;
        }
        if ((string2 = string2.substring(n + 1, n3).trim()).indexOf(";") != string2.length() - 1) {
            throw new LoginException("Configuration Error:");
        }
        String[] stringArray = string2.substring(0, string2.length() - 1).split(" = |=| ");
        this.m_krb5LoginModuleName = stringArray[0];
        for (int i = 2; i < stringArray.length; i += 2) {
            if (stringArray[i + 1].contains("\"")) {
                stringArray[i + 1] = stringArray[i + 1].replace("\"", "");
            }
            this.m_configuration.put(stringArray[i], stringArray[i + 1]);
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        return this.m_entryName.equals(string) ? this.m_appConfigurationEntry : null;
    }

    public String getM_entryName() {
        return this.m_entryName;
    }

    public String getM_krb5LoginModuleName() {
        return this.m_krb5LoginModuleName;
    }

    public HashMap<String, String> getM_configuration() {
        return this.m_configuration;
    }
}

