/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement;

import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AEParameterContainer;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AETreeCopyUtil;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class AEUpdate
extends AERowCountStatement {
    private static final int NUM_CHILDREN = 3;
    private AETable m_table;
    private AESetClauseList m_setClauses;
    private AEBooleanExpr m_updateCond;
    private AEParameterContainer m_params = null;
    private final boolean m_doInsertOnRC0;

    public AEUpdate(AETable aETable, AESetClauseList aESetClauseList, AEBooleanExpr aEBooleanExpr, boolean bl) throws ErrorException {
        if (null == aETable || null == aESetClauseList || null == aEBooleanExpr) {
            throw new NullPointerException();
        }
        this.m_doInsertOnRC0 = bl;
        this.m_table = aETable;
        this.m_table.setParent(this);
        this.m_setClauses = aESetClauseList;
        this.m_setClauses.setParent(this);
        this.m_updateCond = aEBooleanExpr;
        this.m_updateCond.setParent(this);
        this.updateDefaultMetadata();
        this.validate();
    }

    private AEUpdate(AEUpdate aEUpdate) {
        this.m_table = aEUpdate.m_table.copy();
        this.m_table.setParent(this);
        this.m_setClauses = aEUpdate.m_setClauses.copy();
        this.m_setClauses.setParent(this);
        this.m_updateCond = aEUpdate.m_updateCond.copy();
        this.m_updateCond.setParent(this);
        this.m_doInsertOnRC0 = aEUpdate.m_doInsertOnRC0;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AEUpdate copy() {
        AEUpdate aEUpdate = new AEUpdate(this);
        AETreeCopyUtil.updateColumns(aEUpdate);
        return aEUpdate;
    }

    public boolean doInsertOnRc0() {
        return this.m_doInsertOnRC0;
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AEUpdate.this.m_table;
                }
                if (1 == n) {
                    return AEUpdate.this.m_setClauses;
                }
                if (2 == n) {
                    return AEUpdate.this.m_updateCond;
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 3;
            }
        }.iterator();
    }

    @Override
    public String getLogString() {
        return this.m_doInsertOnRC0 ? "AEUpsert" : "AEUpdate";
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    public AETable getTable() {
        return this.m_table;
    }

    public AESetClauseList getSetClauses() {
        return this.m_setClauses;
    }

    public AEBooleanExpr getUpdateCondition() {
        return this.m_updateCond;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        return this == iAENode || iAENode instanceof AEUpdate && this.m_table.isEquivalent(((AEUpdate)iAENode).m_table) && this.m_setClauses.isEquivalent(((AEUpdate)iAENode).m_setClauses) && this.m_updateCond.isEquivalent(((AEUpdate)iAENode).m_updateCond);
    }

    @Override
    public void reprocessMetadata() throws ErrorException {
        AEUpdate.getMetadataProcessor().visit(this);
    }

    @Override
    protected void NotifyDataNeededForColumnReference(AEColumnReference aEColumnReference) throws ErrorException {
        this.m_table.setDataNeeded(this.m_table, aEColumnReference.getColumnNum());
    }

    @Override
    public void notifyDataNeeded() throws ErrorException {
        AEDefaultVisitor<Void> aEDefaultVisitor = super.getNotifyDataNeededVisitor();
        this.m_updateCond.acceptVisitor(aEDefaultVisitor);
        Iterator iterator = this.m_setClauses.getChildItr();
        while (iterator.hasNext()) {
            AESetClause aESetClause = (AESetClause)iterator.next();
            aESetClause.getRightOperand().acceptVisitor(aEDefaultVisitor);
        }
        this.m_table.setDataNeededOnChild();
    }

    public void setTable(AETable aETable) {
        if (aETable == null) {
            throw new NullPointerException("Table to update can not be null.");
        }
        this.m_table = aETable;
        this.m_table.setParent(this);
    }

    public void setUpdateCondition(AEBooleanExpr aEBooleanExpr) {
        if (aEBooleanExpr == null) {
            throw new NullPointerException("Update condition can not be null.");
        }
        this.m_updateCond = aEBooleanExpr;
        this.m_updateCond.setParent(this);
    }

    private void updateDefaultMetadata() throws ErrorException {
        Iterator iterator = this.m_setClauses.getChildItr();
        while (iterator.hasNext()) {
            AESetClause aESetClause = (AESetClause)iterator.next();
            AEValueExpr aEValueExpr = aESetClause.getRightOperand();
            if (!(aEValueExpr instanceof AEDefault)) continue;
            AEDefault aEDefault = (AEDefault)aEValueExpr;
            aEDefault.setMetadata(aESetClause.getLeftOperand().getColumn());
        }
    }

    private void validate() throws ErrorException {
        int n = this.m_setClauses.getNumChildren();
        for (int i = 0; i < n - 1; ++i) {
            AEColumnReference aEColumnReference = ((AESetClause)this.m_setClauses.getChild(i)).getLeftOperand();
            for (int j = i + 1; j < n; ++j) {
                if (!aEColumnReference.isEquivalent(((AESetClause)this.m_setClauses.getChild(j)).getLeftOperand())) continue;
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DUPLICATE_UPDATE_COLUMN.name(), new String[]{aEColumnReference.getName()});
            }
        }
    }

    @Override
    public List<AEParameter> getDynamicParameters() {
        if (this.m_params == null) {
            this.m_params = new AEParameterContainer();
            this.m_params.initialize(this);
        }
        return this.m_params.getParameters();
    }
}

