/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.relation;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.conv.ConverterConstants;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.math.BigInteger;

public class ETTop
extends ETUnaryRelationalExpr {
    private final ETValueExpr m_selectLimit;
    private final ETValueExpr m_skipOffsetExpr;
    private long m_curRow;
    private long m_maxRowIndex;
    private long m_skipOffset;
    private long m_maxRowsToReturn;

    public ETTop(ETRelationalExpr eTRelationalExpr, boolean[] blArray, ETValueExpr eTValueExpr, ETValueExpr eTValueExpr2, boolean bl) {
        super(eTRelationalExpr, blArray);
        if (bl) {
            throw new RuntimeException(SQLEngineExceptionFactory.featureNotImplementedException("TOP %"));
        }
        this.m_selectLimit = eTValueExpr;
        this.m_skipOffsetExpr = eTValueExpr2;
        this.m_curRow = 0L;
        this.m_maxRowIndex = 0L;
        this.m_skipOffset = 0L;
    }

    @Override
    public void close(boolean bl) {
        super.close(bl);
        this.m_selectLimit.close(bl);
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && this.m_selectLimit.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        super.reset();
        this.m_selectLimit.reset();
        if (null != this.m_skipOffsetExpr) {
            this.m_skipOffsetExpr.reset();
        }
        this.skipCurRowToOffset();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        assert (this.isOpen()) : "getRowCount() called when ETTop node was not open.";
        long l = this.getOperand().getRowCount();
        if (-1L == l || l <= this.m_maxRowsToReturn) {
            return l;
        }
        return this.m_maxRowsToReturn;
    }

    public ETValueExpr getSelectLimit() {
        return this.m_selectLimit;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        super.open(cursorType);
        this.m_selectLimit.open();
        ETDataRequest eTDataRequest = new ETDataRequest(0L, -1L, new ColumnMetadata(TypeMetadata.createTypeMetadata(-5)));
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            this.m_selectLimit.retrieveData(eTDataRequest);
            bigInteger = eTDataRequest.getData().getBigInt();
            if (null != this.m_skipOffsetExpr) {
                this.m_skipOffsetExpr.retrieveData(eTDataRequest);
                bigInteger2 = eTDataRequest.getData().getBigInt();
            }
        }
        catch (ErrorException errorException) {
            throw SQLEngineExceptionFactory.incompatibleTypesException("TOP", "UNKNOWN");
        }
        if (null == bigInteger) {
            throw SQLEngineExceptionFactory.invalidTopLimitValue("null");
        }
        this.checkLimitOrSkipRange(bigInteger);
        if (null != bigInteger2) {
            this.checkLimitOrSkipRange(bigInteger2);
        }
        this.m_skipOffset = null == bigInteger2 ? 0L : bigInteger2.longValue();
        this.m_maxRowsToReturn = bigInteger.longValue();
        this.m_maxRowIndex = this.m_maxRowsToReturn + this.m_skipOffset;
        this.skipCurRowToOffset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.getOperand().retrieveData(n, eTDataRequest);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_curRow < this.m_maxRowIndex && this.getOperand().move()) {
            ++this.m_curRow;
            return true;
        }
        return false;
    }

    private void checkLimitOrSkipRange(BigInteger bigInteger) throws ErrorException {
        if (bigInteger.compareTo(ConverterConstants.SIGNED_BIGINT_MAX) > 0 || bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw SQLEngineExceptionFactory.invalidTopLimitValue(bigInteger.toString());
        }
    }

    private void skipCurRowToOffset() throws ErrorException {
        this.m_curRow = 0L;
        while (this.m_curRow < this.m_skipOffset && this.getOperand().move()) {
            ++this.m_curRow;
        }
    }
}

