/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogLevel;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.security.TypeRecordingObjectOutputStream;
import com.cloudera.hiveserver1.support.security.WhitelistedObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class RowBlock
implements IRowView {
    private static final String PACKAGE_NAME = "com.cloudera.sqlengine.executor.etree.temptable";
    private static final String CLASS_NAME = "RowBlock";
    private ColumnSliceArray m_columns;
    private int m_currentRow = -1;
    private ILogger m_logger;
    private IColumn[] m_metadata;
    private static final Set<String> s_serializedTypes = Collections.newSetFromMap(new ConcurrentHashMap());

    public RowBlock(ColumnSliceArray columnSliceArray, IColumn[] iColumnArray, ILogger iLogger) {
        this.m_columns = columnSliceArray;
        this.m_metadata = (IColumn[])iColumnArray.clone();
        this.m_logger = iLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RowBlock loadData(byte[] byArray, ILogger iLogger, IColumn[] iColumnArray) throws ErrorException {
        RowBlock rowBlock;
        block11: {
            if (null != iLogger) {
                LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
            }
            long l = null != iLogger && LogLevel.TRACE == iLogger.getLogLevel() ? System.nanoTime() : 0L;
            WhitelistedObjectInputStream whitelistedObjectInputStream = new WhitelistedObjectInputStream(new ByteArrayInputStream(byArray), s_serializedTypes);
            try {
                ColumnSliceArray columnSliceArray = (ColumnSliceArray)whitelistedObjectInputStream.readObject();
                RowBlock rowBlock2 = new RowBlock(columnSliceArray, iColumnArray, iLogger);
                if (null != iLogger && LogLevel.TRACE == iLogger.getLogLevel()) {
                    iLogger.logTrace(PACKAGE_NAME, CLASS_NAME, "loadData", String.format("Loaded %d bytes: %d slices and %d rows in %.2f ms", byArray.length, columnSliceArray.trueNumColumns(), columnSliceArray.numRows(), (double)(System.nanoTime() - l) / 1000000.0));
                }
                rowBlock = rowBlock2;
            }
            catch (Throwable throwable) {
                try {
                    block12: {
                        try {
                            whitelistedObjectInputStream.close();
                        }
                        catch (IOException iOException) {
                            if (null == iLogger) break block12;
                            iLogger.logError(PACKAGE_NAME, CLASS_NAME, "loadData", "Failed to close stream(s).");
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw SQLEngineExceptionFactory.failedToReadData(exception);
                }
            }
            try {
                whitelistedObjectInputStream.close();
            }
            catch (IOException iOException) {
                if (null == iLogger) break block11;
                iLogger.logError(PACKAGE_NAME, CLASS_NAME, "loadData", "Failed to close stream(s).");
            }
        }
        return rowBlock;
    }

    public boolean moveToNextRow() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (this.m_currentRow < this.m_columns.numRows()) {
            ++this.m_currentRow;
        }
        return this.m_currentRow < this.m_columns.numRows();
    }

    public boolean moveToRow(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        if (n < this.m_columns.numRows() && n > -1) {
            this.m_currentRow = n;
            return true;
        }
        this.m_currentRow = this.m_columns.numRows();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize() throws ErrorException {
        byte[] byArray;
        block10: {
            if (null != this.m_logger) {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            TypeRecordingObjectOutputStream typeRecordingObjectOutputStream = new TypeRecordingObjectOutputStream(byteArrayOutputStream, s_serializedTypes);
            try {
                typeRecordingObjectOutputStream.writeObject(this.m_columns);
                typeRecordingObjectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    block11: {
                        try {
                            typeRecordingObjectOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (null == this.m_logger) break block11;
                            this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "serialize", "Failed to close stream(s).");
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw SQLEngineExceptionFactory.failedToWriteData(iOException);
                }
            }
            try {
                typeRecordingObjectOutputStream.close();
            }
            catch (IOException iOException) {
                if (null == this.m_logger) break block10;
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "serialize", "Failed to close stream(s).");
            }
        }
        return byArray;
    }

    public int getNumRows() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        return this.m_columns.numRows();
    }

    @Override
    public BigDecimal getExactNumber(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getExactNum(this.m_currentRow);
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getFileMarker(this.m_currentRow);
    }

    @Override
    public long getBigInt(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getBigInt(this.m_currentRow);
    }

    @Override
    public boolean isNull(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).isNull(this.m_currentRow);
    }

    @Override
    public double getDouble(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getDouble(this.m_currentRow);
    }

    @Override
    public float getReal(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getReal(this.m_currentRow);
    }

    @Override
    public boolean getBoolean(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getBoolean(this.m_currentRow);
    }

    @Override
    public String getString(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getString(this.m_currentRow);
    }

    @Override
    public Date getDate(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getDate(this.m_currentRow);
    }

    @Override
    public Time getTime(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getTime(this.m_currentRow);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getTimestamp(this.m_currentRow);
    }

    @Override
    public UUID getGuid(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getGuid(this.m_currentRow);
    }

    @Override
    public int getInteger(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getInteger(this.m_currentRow);
    }

    @Override
    public short getSmallInt(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getSmallInt(this.m_currentRow);
    }

    @Override
    public byte getTinyInt(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getTinyInt(this.m_currentRow);
    }

    @Override
    public byte[] getBytes(int n) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
        }
        return this.m_columns.get(n).getBytes(this.m_currentRow);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata[n];
    }
}

