/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.IColumnSlice;

public final class BinaryColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 2719920700780359307L;
    private byte[][] m_data;
    private final int m_columnNumber;

    public BinaryColumnSlice(int n, int n2) {
        this.m_data = new byte[n][];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public byte[] getBytes(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.BINARY;
    }

    @Override
    public void setBytes(int n, byte[] byArray) {
        this.m_data[n] = byArray;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        BinaryColumnSlice binaryColumnSlice = (BinaryColumnSlice)iColumnSlice;
        System.arraycopy(binaryColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize, int n) {
        return javaSize.estimateArraySize(javaSize.getByteSize(), n);
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

