/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value;

import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class ETConstant
extends ETValueExpr {
    private ISqlDataWrapper m_data;

    public ETConstant(ISqlDataWrapper iSqlDataWrapper) {
        this.m_data = iSqlDataWrapper;
    }

    protected ETConstant() {
    }

    @Override
    public void close(boolean bl) {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    public boolean isNull() throws ErrorException {
        return null != this.m_data && this.m_data.isNull();
    }

    @Override
    public void open() {
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        if (this.m_data.isNull()) {
            iSqlDataWrapper.setNull();
        } else {
            switch (eTDataRequest.getData().getType()) {
                case -5: {
                    iSqlDataWrapper.setBigInt(this.m_data.getBigInt());
                    break;
                }
                case 2: 
                case 3: {
                    iSqlDataWrapper.setExactNumber(this.m_data.getExactNumber());
                    break;
                }
                case 6: 
                case 8: {
                    iSqlDataWrapper.setDouble(this.m_data.getDouble());
                    break;
                }
                case 7: {
                    iSqlDataWrapper.setReal(this.m_data.getReal());
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    iSqlDataWrapper.setBinary(this.m_data.getBinary());
                    break;
                }
                case -7: 
                case 16: {
                    iSqlDataWrapper.setBoolean(this.m_data.getBoolean());
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    iSqlDataWrapper.setChar(this.m_data.getChar());
                    return DataRetrievalUtil.retrieveCharData(iSqlDataWrapper, eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), eTDataRequest.getColumn().getColumnLength(), this.getWarningListener());
                }
                case 91: {
                    iSqlDataWrapper.setDate((Date)this.m_data.getDate().clone());
                    break;
                }
                case 92: {
                    iSqlDataWrapper.setTime((Time)this.m_data.getTime().clone());
                    break;
                }
                case 93: {
                    iSqlDataWrapper.setTimestamp((Timestamp)this.m_data.getTimestamp().clone());
                    break;
                }
                case -11: {
                    iSqlDataWrapper.setGuid(this.m_data.getGuid());
                    break;
                }
                case 4: {
                    iSqlDataWrapper.setInteger(this.m_data.getInteger());
                    break;
                }
                case 5: {
                    iSqlDataWrapper.setSmallInt(this.m_data.getSmallInt());
                    break;
                }
                case -6: {
                    iSqlDataWrapper.setTinyInt(this.m_data.getTinyInt());
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + this.m_data.getType());
                }
            }
        }
        return false;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }
}

