/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.support.conv.ConversionResult;
import com.cloudera.hiveserver1.support.conv.ExactNumConverter;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public final class ETModFn
extends ETScalarFn {
    private final int m_type;

    public ETModFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size() && 2 == list2.size());
        short s = iColumn.getTypeMetadata().getType();
        assert (TypeUtilities.isNumberType(s));
        assert (list2.get(0).getTypeMetadata().getType() == s);
        assert (list2.get(1).getTypeMetadata().getType() == s);
        this.m_type = s;
    }

    @Override
    public String getLogString() {
        return "ETModFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        switch (this.m_type) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
                BigDecimal bigDecimal2 = iSqlDataWrapper2.getExactNumber();
                if (0 == bigDecimal2.compareTo(BigDecimal.ZERO)) {
                    throw SQLEngineExceptionFactory.divByZeroException();
                }
                TypeMetadata typeMetadata = this.getResultMetadata().getTypeMetadata();
                ConversionResult conversionResult = new ConversionResult();
                BigDecimal bigDecimal3 = ExactNumConverter.setPrecScale(bigDecimal.remainder(bigDecimal2), typeMetadata.getPrecision(), typeMetadata.getScale(), conversionResult);
                eTDataRequest.getData().setExactNumber(bigDecimal3);
                break;
            }
            case -5: {
                BigInteger bigInteger = iSqlDataWrapper.getBigInt();
                BigInteger bigInteger2 = iSqlDataWrapper2.getBigInt();
                if (bigInteger2.equals(BigInteger.ZERO)) {
                    throw SQLEngineExceptionFactory.divByZeroException();
                }
                BigInteger bigInteger3 = bigInteger.remainder(bigInteger2);
                eTDataRequest.getData().setBigInt(bigInteger3);
                break;
            }
            case 4: {
                eTDataRequest.getData().setInteger(ETModFn.mod(iSqlDataWrapper.getInteger(), iSqlDataWrapper2.getInteger()));
                break;
            }
            case 5: {
                eTDataRequest.getData().setSmallInt(ETModFn.mod(iSqlDataWrapper.getSmallInt(), iSqlDataWrapper2.getSmallInt()));
                break;
            }
            case -6: {
                eTDataRequest.getData().setTinyInt((short)ETModFn.mod(iSqlDataWrapper.getTinyInt(), iSqlDataWrapper2.getTinyInt()));
                break;
            }
            case 7: {
                eTDataRequest.getData().setReal((float)ETModFn.mod(iSqlDataWrapper.getReal(), iSqlDataWrapper2.getReal()));
                break;
            }
            default: {
                eTDataRequest.getData().setDouble(ETModFn.mod(iSqlDataWrapper.getDouble(), iSqlDataWrapper2.getDouble()));
            }
        }
        return false;
    }

    private static int mod(int n, int n2) throws ErrorException {
        if (0 == n2) {
            throw SQLEngineExceptionFactory.divByZeroException();
        }
        return n % n2;
    }

    private static long mod(long l, long l2) throws ErrorException {
        if (0L == l2) {
            throw SQLEngineExceptionFactory.divByZeroException();
        }
        return l % l2;
    }

    private static double mod(double d, double d2) throws ErrorException {
        if (0.0 == d2) {
            throw SQLEngineExceptionFactory.divByZeroException();
        }
        return d % d2;
    }
}

