/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;

public final class ETMonthFn
extends ETScalarFn {
    public ETMonthFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (1 != list.size() || 1 != list2.size()) {
            throw new IllegalArgumentException("Invalid Number of arguments for MONTH scalar function.");
        }
        short s = list2.get(0).getTypeMetadata().getType();
        if (91 != s) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getLogString() {
        return "ETMonthFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            int n = iSqlDataWrapper.getDate().getMonth() + 1;
            assert (1 <= n && n <= 12);
            eTDataRequest.getData().setSmallInt(n);
        }
        return false;
    }
}

