/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.support;

import com.cloudera.hiveserver1.support.IMessageSource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageSourceImpl
implements IMessageSource {
    private Map<Integer, String> m_componentToFileName = new HashMap<Integer, String>();
    private Map<Integer, String> m_componentIDToName = new HashMap<Integer, String>();
    private boolean m_isConcatComponentName;
    private boolean m_isConcatVendorString;
    private String m_vendorName = "";

    public MessageSourceImpl(boolean bl, boolean bl2) {
        this.m_isConcatVendorString = bl;
        this.m_isConcatComponentName = bl2;
        this.setVendorName("Simba");
    }

    @Override
    public String loadMessage(Locale locale, int n, String string) {
        return this.getFormattedMessage(locale, n, string, this.m_isConcatVendorString, this.m_isConcatComponentName, new Object[0]);
    }

    @Override
    public String loadMessage(Locale locale, int n, String string, boolean bl, boolean bl2) {
        return this.getFormattedMessage(locale, n, string, bl, bl2, new Object[0]);
    }

    @Override
    public String loadMessage(Locale locale, int n, String string, boolean bl, boolean bl2, Object ... objectArray) {
        return this.getFormattedMessage(locale, n, string, bl, bl2, objectArray);
    }

    @Override
    public String loadMessage(Locale locale, int n, String string, Object ... objectArray) {
        return this.getFormattedMessage(locale, n, string, this.m_isConcatVendorString, this.m_isConcatComponentName, objectArray);
    }

    public synchronized void registerMessages(String string, int n, String string2) {
        this.m_componentToFileName.put(n, string);
        this.m_componentIDToName.put(n, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVendorName(String string) {
        MessageSourceImpl messageSourceImpl = this;
        synchronized (messageSourceImpl) {
            this.m_vendorName = "[" + string + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedMessage(Locale locale, int n, String string, boolean bl, boolean bl2, Object ... objectArray) {
        try {
            Object object;
            String string2 = this.m_componentToFileName.get(n);
            if (null == string2) {
                return "Component not found: " + n;
            }
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, locale);
            String string3 = resourceBundle.getString(string);
            if (null != objectArray) {
                string3 = MessageFormat.format(string3, objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                object = this;
                synchronized (object) {
                    stringBuilder.append(this.m_vendorName);
                }
            }
            if (bl2 && null != (object = this.m_componentIDToName.get(n))) {
                stringBuilder.append("[");
                stringBuilder.append((String)object);
                stringBuilder.append("]");
            }
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }
        catch (MissingResourceException missingResourceException) {
            return "Error message not found: " + string + ". " + missingResourceException.getLocalizedMessage();
        }
    }
}

