/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.support.conv;

import com.cloudera.hiveserver1.support.Pair;
import com.cloudera.hiveserver1.support.conv.ApproxNumConverter;
import com.cloudera.hiveserver1.support.conv.ConversionResult;
import com.cloudera.hiveserver1.support.conv.IntegralConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class ExactNumConverter {
    private ExactNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static Pair<Short, Short> calculateSQLPrecisionScale(BigDecimal bigDecimal, ConversionResult conversionResult) {
        int n;
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return new Pair<Short, Short>((short)1, (short)0);
        }
        int n2 = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
        int n3 = n = bigDecimal.scale() < 0 ? bigDecimal.precision() - bigDecimal.scale() : bigDecimal.precision();
        if (0 > n || Short.MAX_VALUE < n) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (Short.MAX_VALUE < n2) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            n2 = Short.MAX_VALUE;
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return new Pair<Short, Short>((short)n, (short)n2);
    }

    public static boolean toBoolean(BigDecimal bigDecimal, ConversionResult conversionResult) {
        int n = bigDecimal.compareTo(BigDecimal.ONE);
        int n2 = bigDecimal.compareTo(BigDecimal.ZERO);
        if (0 == n) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if (0 == n2) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        if (0 < n) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return true;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        return true;
    }

    public static double toDouble(BigDecimal bigDecimal, ConversionResult conversionResult) {
        double d = bigDecimal.doubleValue();
        if (Double.POSITIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (Double.NEGATIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return d;
    }

    public static float toFloat(BigDecimal bigDecimal, ConversionResult conversionResult) {
        double d = ExactNumConverter.toDouble(bigDecimal, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState()) {
            return (float)d;
        }
        return ApproxNumConverter.toFloat(d, conversionResult);
    }

    public static String toChar(BigDecimal bigDecimal, long l, ConversionResult conversionResult) {
        String string = bigDecimal.toString();
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }

    public static BigInteger toBigInt(BigDecimal bigDecimal, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger = bigDecimal.toBigInteger();
        BigInteger bigInteger2 = IntegralConverter.toBigInt(bigInteger, bl, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState()) {
            int n = bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (n > 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (n < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
            return bigInteger2;
        }
        return null;
    }

    public static long toInteger(BigDecimal bigDecimal, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger = bigDecimal.toBigInteger();
        long l = IntegralConverter.toInteger(bigInteger, bl, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState()) {
            int n = bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (n > 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (n < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return l;
    }

    public static int toSmallInt(BigDecimal bigDecimal, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger = bigDecimal.toBigInteger();
        int n = IntegralConverter.toSmallInt(bigInteger, bl, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState()) {
            int n2 = bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (n2 > 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (n2 < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return n;
    }

    public static short toTinyInt(BigDecimal bigDecimal, boolean bl, ConversionResult conversionResult) {
        BigInteger bigInteger = bigDecimal.toBigInteger();
        short s = IntegralConverter.toTinyInt(bigInteger, bl, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS == conversionResult.getState()) {
            int n = bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO);
            if (n > 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else if (n < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        }
        return s;
    }

    public static BigDecimal setPrecScale(BigDecimal bigDecimal, short s, short s2, ConversionResult conversionResult) {
        int n;
        if (s < 1 || s2 > s || s2 < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        ConversionResult conversionResult2 = new ConversionResult();
        Pair<Short, Short> pair = ExactNumConverter.calculateSQLPrecisionScale(bigDecimal, conversionResult2);
        if (ConversionResult.TypeConversionState.SUCCESS != conversionResult2.getState()) {
            conversionResult.setState(conversionResult2.getState());
            return null;
        }
        int n2 = pair.key() - pair.value();
        if (n2 > (n = s - s2)) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
            return null;
        }
        if (pair.value() <= s2) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.setScale((int)s2, RoundingMode.DOWN);
        int n3 = bigDecimal.compareTo(bigDecimal2);
        if (n3 < 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        } else if (n3 == 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        }
        return bigDecimal2;
    }
}

