/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.utilities;

import com.cloudera.hiveserver1.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.hiveserver1.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.hiveserver1.dsi.core.utilities.ConnectionSetting;
import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.exceptions.GeneralException;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class PropertyTypeConverter {
    public static ConnSettingRequestMap toConnSettingRequestMap(Properties properties) throws ErrorException {
        ConnSettingRequestMap connSettingRequestMap = new ConnSettingRequestMap();
        if (null == properties) {
            return connSettingRequestMap;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            try {
                Variant variant = new Variant(0, properties.get(string).toString());
                connSettingRequestMap.setProperty(string, variant);
            }
            catch (Exception exception) {
                int n = 0;
                if (exception instanceof SQLException) {
                    n = ((SQLException)exception).getErrorCode();
                } else if (exception instanceof ErrorException) {
                    throw (ErrorException)exception;
                }
                throw new GeneralException(exception.getLocalizedMessage(), n, (Throwable)exception);
            }
        }
        return connSettingRequestMap;
    }

    public static DriverPropertyInfo[] toDriverPropertyInfo(ConnSettingResponseMap connSettingResponseMap) {
        if (null == connSettingResponseMap) {
            return new DriverPropertyInfo[0];
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[connSettingResponseMap.size()];
        Iterator<String> iterator = connSettingResponseMap.getKeysIterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            ConnectionSetting connectionSetting = connSettingResponseMap.getProperty(string);
            driverPropertyInfoArray[n] = new DriverPropertyInfo(string, null);
            driverPropertyInfoArray[n].description = connectionSetting.getLabel();
            driverPropertyInfoArray[n].required = connectionSetting.isRequired();
            ArrayList<Variant> arrayList = connectionSetting.getValues();
            driverPropertyInfoArray[n].choices = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                driverPropertyInfoArray[n].choices[i] = arrayList.get(i).getString();
            }
            ++n;
        }
        return driverPropertyInfoArray;
    }
}

