/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver2.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver2.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class TimestampJDBCDataSource
extends ConvertingJDBCDataSource {
    private final int m_fracSecPrec;

    public TimestampJDBCDataSource(IWarningListener iWarningListener, TypeMetadata typeMetadata) {
        super(iWarningListener);
        this.m_fracSecPrec = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fracSecPrec;
    }

    protected abstract int get(Calendar var1) throws ErrorException;

    protected Timestamp doGetTimestamp(Calendar calendar) throws ErrorException {
        assert (calendar != null);
        int n = this.get(calendar);
        if (n >= 0) {
            assert (n <= 999999999);
            assert (calendar.get(14) == 0);
            this.setWasNull(false);
            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
            timestamp.setNanos(n);
            return timestamp;
        }
        this.setWasNull(true);
        return null;
    }

    @Override
    public Timestamp get() throws ErrorException {
        return this.doGetTimestamp(this.getLocalCalendarForConversions());
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Timestamp timestamp = this.get();
        if (timestamp == null) {
            return null;
        }
        return NonTrivialJDBCConversions.timestampToString(timestamp, this.getLocalCalendarForConversions(), this.m_fracSecPrec);
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Timestamp timestamp;
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        if ((timestamp = this.getTimestamp(calendar)) == null) {
            return null;
        }
        return NonTrivialJDBCConversions.timestampToDate(timestamp, calendar);
    }

    @Override
    public Time getTime(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Timestamp timestamp;
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        if ((timestamp = this.getTimestamp(calendar)) == null) {
            return null;
        }
        Time time = NonTrivialJDBCConversions.timestampToTime(timestamp, this.m_fracSecPrec, calendar);
        if (this.m_fracSecPrec > 3) {
            calendar.clear();
            calendar.setTimeInMillis(time.getTime());
            if (calendar.get(14) * 1000000 != timestamp.getNanos()) {
                this.onFractionalTruncation(timestamp, 3, "getTime");
            }
        }
        return time;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        return this.doGetTimestamp(calendar);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

