/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TProtocolVersion;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.IServerVersion;
import com.cloudera.hiveserver2.hivecommon.IServerVersionUtils;

public abstract class AbstractServerVersionUtils
implements IServerVersionUtils {
    static int MAJOR_ARR_IDX = 0;
    static int MINOR_ARR_IDX = 1;
    static int PATCH_ARR_IDX = 2;
    static int MAJOR_VERSION_IDX = 1;
    static int MINOR_VERSION_IDX = 2;
    static int PATCH_VERSION_IDX = 3;

    @Override
    public TProtocolVersion getHighestClientProtocol() {
        return TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6;
    }

    @Override
    public String getDriverNamePrefix() {
        return null;
    }

    public boolean greaterThanOrEqualTo(IServerVersion iServerVersion, IServerVersion iServerVersion2) {
        int[] nArray;
        int[] nArray2 = this.parseServerVersionParts(iServerVersion);
        boolean bl = nArray2[MAJOR_ARR_IDX] > (nArray = this.parseServerVersionParts(iServerVersion2))[MAJOR_ARR_IDX];
        boolean bl2 = nArray2[MAJOR_ARR_IDX] == nArray[MAJOR_ARR_IDX] && nArray2[MINOR_ARR_IDX] > nArray[MINOR_ARR_IDX];
        boolean bl3 = nArray2[MAJOR_ARR_IDX] == nArray[MAJOR_ARR_IDX] && nArray2[MINOR_ARR_IDX] == nArray[MINOR_ARR_IDX] && nArray2[PATCH_ARR_IDX] >= nArray[PATCH_ARR_IDX];
        return bl || bl2 || bl3;
    }

    @Override
    public boolean isSupportedProtocol(TProtocolVersion tProtocolVersion) {
        return tProtocolVersion.compareTo(this.getHighestClientProtocol()) <= 0;
    }

    private int[] parseServerVersionParts(IServerVersion iServerVersion) {
        int[] nArray = new int[3];
        String string = iServerVersion.name();
        if (!string.equals("AUTO")) {
            String[] stringArray = string.split("_");
            if (stringArray.length > MAJOR_VERSION_IDX) {
                nArray[AbstractServerVersionUtils.MAJOR_ARR_IDX] = new Integer(stringArray[MAJOR_VERSION_IDX]);
            }
            if (stringArray.length > MINOR_VERSION_IDX) {
                nArray[AbstractServerVersionUtils.MINOR_ARR_IDX] = new Integer(stringArray[MINOR_VERSION_IDX]);
            }
            if (stringArray.length > PATCH_VERSION_IDX) {
                nArray[AbstractServerVersionUtils.PATCH_ARR_IDX] = new Integer(stringArray[PATCH_VERSION_IDX]);
            }
        }
        return nArray;
    }

    @Override
    public IServerVersion parseServerVersion(String string) {
        return this.parseServerVersion(string, null);
    }

    @Override
    public boolean supportsDMLResults() {
        return false;
    }

    @Override
    public boolean supportsGetTablesAPIComments(IServerVersion iServerVersion) {
        return true;
    }

    @Override
    public boolean supportsLeftFunction(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsMonthNameFunction(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsQuarterFunction(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsRightFunction(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsWeekFunction(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsUnsetClientProtocol() {
        return false;
    }

    @Override
    public boolean supportsQualifiedTypeNames(IServerVersion iServerVersion) {
        return false;
    }

    @Override
    public boolean supportsAsyncModeForMetadataOperation(HiveJDBCSettings hiveJDBCSettings) {
        return false;
    }

    @Override
    public boolean supportsNativeModeParameterizedQuery(HiveJDBCSettings hiveJDBCSettings) {
        return false;
    }
}

