/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.dataengine;

import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.dsi.dataengine.impl.DSISimpleResultSet;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.api.CurrentBufferContext;
import com.cloudera.hiveserver2.hivecommon.api.HS2Client;
import com.cloudera.hiveserver2.hivecommon.api.HiveExecutionContext;
import com.cloudera.hiveserver2.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver2.hivecommon.api.IHiveClient;
import com.cloudera.hiveserver2.hivecommon.core.BackgroundFetcherExecutionContextMap;
import com.cloudera.hiveserver2.hivecommon.core.CoreUtils;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hiveserver2.hivecommon.dataengine.BackgroundFetcher;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.utils.WarningsUtils;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.WarningCode;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;

public class HiveJDBCResultSet
extends DSISimpleResultSet {
    private static final String EXPR_COL_NAME = "EXPR_";
    private static final List<String> COMPLEX_DATA_TYPES = new ArrayList<String>(Arrays.asList("ARRAY", "MAP", "STRUCT", "UNION"));
    private ArrayList<ColumnMetadata> m_columns;
    protected HiveOperationContext m_context;
    protected IHiveClient m_client;
    private HiveJDBCStatement m_statement;
    private HiveJDBCCommonConnection m_connection;
    private CurrentBufferContext m_currentBufferContext;
    private Future<?> m_fetcherResult = null;
    private BackgroundFetcher m_fetcher;
    private boolean m_hasOpenCursor;
    protected final ILogger m_logger;
    private final boolean m_isRowCountResult;
    private int m_resultSetMaxRow;
    private boolean m_resultSetMaxRowSet;
    private int m_currentFetchedRows;
    protected boolean m_hasMoreRows = true;
    private boolean m_queryTranslationFailed = false;

    public HiveJDBCResultSet(HiveExecutionContext hiveExecutionContext, IHiveClient iHiveClient, HiveJDBCStatement hiveJDBCStatement, HiveJDBCCommonConnection hiveJDBCCommonConnection, ILogger iLogger, boolean bl, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_context = hiveExecutionContext;
        this.m_client = iHiveClient;
        this.m_statement = hiveJDBCStatement;
        this.m_connection = hiveJDBCCommonConnection;
        this.m_logger = iLogger;
        this.m_currentBufferContext = new CurrentBufferContext();
        this.m_hasOpenCursor = false;
        this.m_isRowCountResult = bl;
        this.m_resultSetMaxRowSet = false;
        this.m_currentFetchedRows = 0;
        this.m_queryTranslationFailed = bl2;
        Variant variant = this.m_statement.getProperty(2);
        if (null != variant) {
            try {
                this.m_resultSetMaxRow = variant.getInt();
                this.m_resultSetMaxRowSet = true;
            }
            catch (NumericOverflowException numericOverflowException) {
                this.m_resultSetMaxRowSet = false;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                this.m_resultSetMaxRowSet = false;
            }
        }
        if (this.m_context.m_isExecutionComplete) {
            this.initializeColumns();
        } else {
            this.m_columns = new ArrayList();
        }
    }

    @Override
    public void close() {
        int n;
        if (null != this.m_client) {
            try {
                this.m_client.removeOperationHandleFromHeartbeatThread(this.m_context);
            }
            catch (ErrorException errorException) {
                this.handleCloseFunctionException(errorException);
            }
        }
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_context) {
            BackgroundFetcherExecutionContextMap.removeContext(this.m_context);
        }
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            this.handleCloseFunctionException(errorException);
        }
        if (this.m_connection.getSettings().m_enableTestGetOperationHandleCountHeartBeatThread.booleanValue() && this.m_client instanceof HS2Client && (n = ((HS2Client)this.m_client).operationHandleCountInHeartbeatThread()) > 0) {
            throw new RuntimeException("Heartbeat thread should not contains operation handle after execution of query.");
        }
    }

    public void consolidateResultColumnNames(ArrayList<ColumnMetadata> arrayList) {
        if (null == arrayList) {
            return;
        }
        HiveJDBCSettings hiveJDBCSettings = this.m_connection.getSettings();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            ColumnMetadata columnMetadata = arrayList.get(i);
            ColumnMetadata columnMetadata2 = (ColumnMetadata)((ArrayList)this.getSelectColumns()).get(i);
            if (hiveJDBCSettings.m_automaticColumnRename || !columnMetadata.getName().toUpperCase().startsWith(EXPR_COL_NAME) || !columnMetadata.getName().substring(EXPR_COL_NAME.length()).matches("^\\d+$")) {
                string = columnMetadata.getName();
                columnMetadata2.setName(string);
                columnMetadata2.setLabel(string);
            }
            if (!hiveJDBCSettings.m_platformVersionUtils.preservesAliasCase(hiveJDBCSettings)) {
                string = columnMetadata2.getName().toLowerCase();
                columnMetadata2.setName(string);
                columnMetadata2.setLabel(string);
            }
            if (null == columnMetadata2.getCatalogName()) {
                columnMetadata2.setCatalogName(columnMetadata.getCatalogName());
            }
            if (null == columnMetadata2.getSchemaName()) {
                columnMetadata2.setSchemaName(columnMetadata.getSchemaName());
            }
            if (null == columnMetadata2.getTableName()) {
                columnMetadata2.setTableName(columnMetadata.getTableName());
            }
            if (!this.isComplexType(columnMetadata.getTypeMetadata().getTypeName())) continue;
            columnMetadata2.getTypeMetadata().setTypeName(columnMetadata.getTypeMetadata().getTypeName());
        }
    }

    public HiveOperationContext getContext() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_context;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        short s = this.m_currentBufferContext.m_columnTypes[n];
        Object ApiBufferT = this.m_currentBufferContext.m_currentBuffer.getBuffer();
        return ApiBufferT.getData(n, l, l2, dataWrapper, this.m_currentBufferContext.m_currentRowInBuffer, s, this.m_context.m_operation, this.m_connection.getSettings());
    }

    @Override
    public long getRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_context.m_rowCount;
    }

    @Override
    public ArrayList<ColumnMetadata> getSelectColumns() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columns;
    }

    public void setSelectColumns(ArrayList<ColumnMetadata> arrayList) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns = arrayList;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return true;
    }

    public boolean hasOpenCursor() {
        return this.m_hasOpenCursor;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    public void initializeColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns = this.m_client.getResultSetMetadata(this.m_context);
        this.setupColumns();
    }

    public void setupCatalogColumns(ArrayList<ColumnMetadata> arrayList) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_columns = arrayList;
        this.setupColumns();
    }

    public void setupColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_currentBufferContext.m_currentRowInBuffer = 0;
        this.m_currentBufferContext.m_columnTypes = new short[this.m_columns.size()];
        int n = 0;
        for (ColumnMetadata columnMetadata : this.m_columns) {
            HiveJDBCSettings hiveJDBCSettings = this.m_connection.getSettings();
            if (hiveJDBCSettings.m_upperCaseResultSetColName && (this.m_queryTranslationFailed || hiveJDBCSettings.m_useNativeQuery)) {
                String string = columnMetadata.getName().toUpperCase();
                columnMetadata.setName(string);
                columnMetadata.setLabel(string);
            }
            this.m_currentBufferContext.m_columnTypes[n++] = columnMetadata.getTypeMetadata().getType();
        }
        this.m_context.m_columnTypes = this.m_currentBufferContext.m_columnTypes;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasMoreRows) {
            return false;
        }
        if (!this.checkMaxRows()) {
            return false;
        }
        if (null == this.m_fetcher) {
            this.m_fetcher = new BackgroundFetcher(this.m_context, this.m_client, this.m_logger, this.m_connection.getSettings());
            this.m_fetcherResult = this.m_connection.getThreadPool().submit(this.m_fetcher);
            try {
                if (!this.m_fetcher.getNextBuffer(this.m_currentBufferContext)) {
                    if (this.m_fetcher.m_isCancelled) {
                        this.m_client.closeOperation(this.m_context);
                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_CANCEL.name(), "Fetching is cancelled");
                        throw errorException;
                    }
                    this.m_hasMoreRows = false;
                    return false;
                }
            }
            catch (ErrorException errorException) {
                this.m_fetcher = null;
                if (null != this.m_client) {
                    this.m_client.removeOperationHandleFromHeartbeatThread(this.m_context);
                }
                throw errorException;
            }
            this.m_currentBufferContext.m_currentRowInBuffer = 0;
            this.m_currentFetchedRows = 0;
        } else if (null != this.m_fetcher.m_exception) {
            this.m_fetcher.resetException();
            this.m_connection.getThreadPool().submit(this.m_fetcher);
        } else if (this.m_currentBufferContext.isGetNextBuffer(++this.m_currentBufferContext.m_currentRowInBuffer)) {
            this.m_currentBufferContext.m_currentBuffer.m_isConsumed = true;
            try {
                if (!this.m_fetcher.getNextBuffer(this.m_currentBufferContext)) {
                    this.m_hasMoreRows = false;
                    return false;
                }
                this.m_currentBufferContext.m_currentRowInBuffer = 0;
            }
            catch (ErrorException errorException) {
                if (null != this.m_client) {
                    this.m_client.removeOperationHandleFromHeartbeatThread(this.m_context);
                }
                --this.m_currentBufferContext.m_currentRowInBuffer;
                throw errorException;
            }
        } else {
            this.m_currentBufferContext.parseRow();
        }
        ++this.m_currentFetchedRows;
        return true;
    }

    public void openCursor() {
        this.m_hasOpenCursor = true;
    }

    public void updateSelectColumns() throws ErrorException {
        if (this.m_client instanceof HS2Client) {
            ((HS2Client)this.m_client).pollForOperationCompletion(this.m_context);
        }
        this.initializeColumns();
        this.consolidateResultColumnNames(this.m_context.m_sencolumns);
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_fetcher) {
            this.m_fetcher.stop();
            try {
                this.m_fetcherResult.get();
                this.m_fetcher.cleanUp();
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_OPERATION_CLOSING_ERR.name());
                errorException.initCause(exception);
                throw errorException;
            }
            this.m_currentBufferContext.m_currentBuffer = null;
            this.m_fetcher = null;
            this.m_fetcherResult = null;
        }
        this.m_client.closeOperation(this.m_context);
        this.m_hasOpenCursor = false;
    }

    @Override
    protected boolean doMoveToNextRow() {
        return false;
    }

    private boolean checkMaxRows() {
        return !this.m_resultSetMaxRowSet || this.m_resultSetMaxRow == 0 || this.m_currentFetchedRows < this.m_resultSetMaxRow;
    }

    private boolean isComplexType(String string) {
        for (String string2 : COMPLEX_DATA_TYPES) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private void handleCloseFunctionException(ErrorException errorException) {
        CoreUtils.postWarning(errorException, this.m_client.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), this.m_logger, WarningsUtils.DO_NOT_SUPPRESS_WARNING_AS_DEBUG_LOG);
    }
}

