/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.common.future;

import com.cloudera.hiveserver2.dsi.core.interfaces.IStatement;
import com.cloudera.hiveserver2.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IExecution;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IOutputConsumer;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterType;
import com.cloudera.hiveserver2.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.future.UnsupportedException;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.exceptions.JDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.common.SConnection;
import com.cloudera.hiveserver2.jdbc.common.future.SPreparedStatement;
import com.cloudera.hiveserver2.jdbc.common.utilities.NameToIndexMap;
import com.cloudera.hiveserver2.jdbc.interfaces.IJDBCCallableStatement;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import com.cloudera.hiveserver2.support.exceptions.ExceptionType;
import com.cloudera.hiveserver2.utilities.TypeNames;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;

public abstract class SCallableStatement
extends SPreparedStatement
implements IJDBCCallableStatement {
    public static final Charset s_asciiCharSet = Charset.forName("US-ASCII");
    public static final Charset s_utf16CharSet = Charset.forName("UTF-16");
    private final IJDBCDataSource[] m_dataSources;
    private final IJDBCExecution.OutputParameterRegistration[] m_outputParamRegistrations;
    private final NameToIndexMap m_nameToIndexMap;
    private final boolean m_hasOutputParameters;
    private OutputParameterStatus m_outputParamStatus = OutputParameterStatus.NOT_YET_AVAILABLE;
    private boolean m_wasLastValueRetrievedNull = false;
    private Closeable m_lastReturnedStream = null;
    private static final Getter<IArray, Object> s_arrayGetter = new Getter<IArray, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2003);
        }

        @Override
        protected IArray doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, UnsupportedException, ErrorException, ConversionFailed {
            return iJDBCDataSource.getArray();
        }
    };
    private static final Getter<String, Object> s_stringGetter = new Getter<String, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(12);
        }

        @Override
        protected String doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return iJDBCDataSource.getString();
        }
    };
    private static final Getter<BigDecimal, Integer> s_bigDecimalGetter = new Getter<BigDecimal, Integer>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(3);
        }

        @Override
        protected BigDecimal doGet(IJDBCDataSource iJDBCDataSource, Integer n) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return n == null ? iJDBCDataSource.getBigDecimal() : iJDBCDataSource.getBigDecimal(n);
        }
    };
    private static final Getter<byte[], Object> s_bytesGetter = new Getter<byte[], Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-3);
        }

        @Override
        protected byte[] doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return iJDBCDataSource.getBytes();
        }
    };
    private static final Getter<Date, Calendar> s_dateGetter = new Getter<Date, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(91);
        }

        @Override
        protected Date doGet(IJDBCDataSource iJDBCDataSource, Calendar calendar) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return calendar == null ? iJDBCDataSource.getDate() : iJDBCDataSource.getDate(calendar);
        }
    };
    private static final Getter<Time, Calendar> s_timeGetter = new Getter<Time, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(92);
        }

        @Override
        protected Time doGet(IJDBCDataSource iJDBCDataSource, Calendar calendar) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return calendar == null ? iJDBCDataSource.getTime() : iJDBCDataSource.getTime(calendar);
        }
    };
    private static final Getter<Timestamp, Calendar> s_timestampGetter = new Getter<Timestamp, Calendar>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(93);
        }

        @Override
        protected Timestamp doGet(IJDBCDataSource iJDBCDataSource, Calendar calendar) throws SQLException, IncorrectTypeException, ErrorException, ConversionFailed {
            return calendar == null ? iJDBCDataSource.getTimestamp() : iJDBCDataSource.getTimestamp(calendar);
        }
    };
    private static final Getter<Object, Object> s_objectGetter = new Getter<Object, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getObject();
        }
    };
    private static final Getter<Object, Map<String, Class<?>>> s_objectGetterWithMap = new Getter<Object, Map<String, Class<?>>>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(IJDBCDataSource iJDBCDataSource, Map<String, Class<?>> map) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getObject(map);
        }
    };
    protected static final Getter<Object, Class<?>> s_objectGetterWithClass = new Getter<Object, Class<?>>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2000);
        }

        @Override
        protected Object doGet(IJDBCDataSource iJDBCDataSource, Class<?> clazz) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getObject(clazz);
        }
    };
    private static final Getter<Ref, Object> s_refGetter = new Getter<Ref, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2006);
        }

        @Override
        protected Ref doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getRef();
        }
    };
    private static final Getter<Blob, Object> s_blobGetter = new Getter<Blob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2004);
        }

        @Override
        protected Blob doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getBlob();
        }
    };
    private static final Getter<Clob, Object> s_clobGetter = new Getter<Clob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2005);
        }

        @Override
        protected Clob doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getClob();
        }
    };
    private static final Getter<NClob, Object> s_nClobGetter = new Getter<NClob, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2011);
        }

        @Override
        protected NClob doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getNClob();
        }
    };
    private static final Getter<URL, Object> s_urlGetter = new Getter<URL, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(70);
        }

        @Override
        protected URL doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getURL();
        }
    };
    private static final Getter<RowId, Object> s_rowIdGetter = new Getter<RowId, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-8);
        }

        @Override
        protected RowId doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getRowId();
        }
    };
    private static final Getter<SQLXML, Object> s_sqlXmlGetter = new Getter<SQLXML, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(2009);
        }

        @Override
        protected SQLXML doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getSQLXML();
        }
    };
    private static final Getter<String, Object> s_nStringGetter = new Getter<String, Object>(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-9);
        }

        @Override
        protected String doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getNString();
        }
    };
    private static final Getter<Reader, Object> s_charStreamGetter = new StreamGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-1);
        }

        @Override
        protected Reader doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getCharacterStream();
        }
    };
    private static final Getter<Reader, Object> s_nCharStreamGetter = new StreamGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-16);
        }

        @Override
        protected Reader doGet(IJDBCDataSource iJDBCDataSource, Object object) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            return iJDBCDataSource.getNCharacterStream();
        }
    };
    private static final PrimitiveGetter s_booleanGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(16);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = iJDBCDataSource.getBoolean() ? 1L : 0L;
        }
    };
    private static final PrimitiveGetter s_byteGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-6);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = iJDBCDataSource.getByte();
        }
    };
    private static final PrimitiveGetter s_shortGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(5);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = iJDBCDataSource.getShort();
        }
    };
    private static final PrimitiveGetter s_intGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(4);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = iJDBCDataSource.getInt();
        }
    };
    private static final PrimitiveGetter s_longGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(-5);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = iJDBCDataSource.getLong();
        }
    };
    private static final PrimitiveGetter s_floatGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(7);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = Float.floatToRawIntBits(iJDBCDataSource.getFloat());
        }
    };
    private static final PrimitiveGetter s_doubleGetter = new PrimitiveGetter(){

        @Override
        protected String getTypeName() {
            return TypeNames.getTypeName(8);
        }

        @Override
        protected void doGet(SCallableStatement sCallableStatement, IJDBCDataSource iJDBCDataSource) throws SQLException, IncorrectTypeException, ErrorException, UnsupportedException, ConversionFailed {
            sCallableStatement.m_tempPrimitiveStorage = Double.doubleToRawLongBits(iJDBCDataSource.getDouble());
        }
    };

    public SCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        boolean bl = false;
        try {
            int n2 = this.m_queryExecutor.getNumParams();
            this.m_dataSources = new IJDBCDataSource[n2];
            this.m_outputParamRegistrations = new IJDBCExecution.OutputParameterRegistration[n2];
            this.m_nameToIndexMap = new NameToIndexMap(this.m_queryExecutor.getMetadataForParameters(), new NameToIndexMap.NameGetter<ParameterMetadata>(){

                @Override
                public String getName(ParameterMetadata parameterMetadata) {
                    return parameterMetadata.getName();
                }
            });
            this.m_hasOutputParameters = this.init();
            bl = true;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener);
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    private boolean init() throws ErrorException {
        boolean bl = false;
        int n = 1;
        for (ParameterMetadata parameterMetadata : this.m_queryExecutor.getMetadataForParameters()) {
            assert (parameterMetadata.getParameterNumber() == n++) : "Result of IQueryExecutor.getMetadataForParameters() had misplaced parameter metadata objects.";
            switch (parameterMetadata.getParameterType()) {
                case INPUT_OUTPUT: 
                case OUTPUT: 
                case RETURN_VALUE: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    protected IOutputConsumer getOutputConsumer() {
        return new OutputConsumer();
    }

    @Override
    protected void onNewlyCreatedExecution(IExecution iExecution) throws SQLException, ErrorException {
        super.onNewlyCreatedExecution(iExecution);
        if (iExecution instanceof IJDBCExecution) {
            IJDBCExecution iJDBCExecution = (IJDBCExecution)iExecution;
            if (this.m_outputParamRegistrations != null) {
                for (int i = 0; i < this.m_outputParamRegistrations.length; ++i) {
                    if (this.m_outputParamRegistrations[i] == null) continue;
                    iJDBCExecution.registerOutParameter(i + 1, this.m_outputParamRegistrations[i]);
                }
            }
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.clearParameters();
        Arrays.fill(this.m_outputParamRegistrations, null);
    }

    @Override
    protected void clearResultsFromPreviousExecution() {
        super.clearResultsFromPreviousExecution();
        Arrays.fill(this.m_dataSources, null);
        this.m_outputParamStatus = OutputParameterStatus.NOT_YET_AVAILABLE;
    }

    protected final boolean hasOutputParameters() {
        return this.m_hasOutputParameters;
    }

    protected final boolean allOutputParametersRegistered() {
        ParameterType[] parameterTypeArray = this.getParameterTypes();
        block3: for (int i = 0; i < parameterTypeArray.length; ++i) {
            switch (parameterTypeArray[i]) {
                case INPUT_OUTPUT: 
                case OUTPUT: 
                case RETURN_VALUE: {
                    if (this.m_outputParamRegistrations[i] != null) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    protected int getParameterIndex(String string) throws SQLException {
        if (string == null) {
            throw new NullPointerException();
        }
        int n = this.m_nameToIndexMap.getIndex(string);
        if (n > 0) {
            return n;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_NAME, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, string);
    }

    protected void registerOutputParameter(int n, IJDBCExecution.OutputParameterRegistration outputParameterRegistration) throws SQLException {
        assert (outputParameterRegistration != null);
        if (!this.isOutputParameter(n)) {
            this.throwInvalidParameterIndexException(n);
        }
        try {
            IExecution iExecution = this.getOrCreateExecution();
            if (iExecution instanceof IJDBCExecution) {
                switch (((IJDBCExecution)iExecution).registerOutParameter(n, outputParameterRegistration)) {
                    case REGISTRATION_SUCEEDED: {
                        break;
                    }
                    case REGISTERED_TYPE_NOT_SUPPORTED: {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                    }
                    case CONVERSION_TO_REGISTERED_TYPE_NOT_SUPPORTED: {
                        String string = outputParameterRegistration.getTypeName() != null ? outputParameterRegistration.getTypeName() : (outputParameterRegistration.getSqlType() instanceof Integer ? TypeNames.getTypeName((Integer)outputParameterRegistration.getSqlType()) : outputParameterRegistration.getSqlType().toString());
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string);
                    }
                }
            }
            this.m_outputParamRegistrations[n - 1] = outputParameterRegistration;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.execute();
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        if (this.hasOutputParameters()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        return super.executeBatch();
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.executeQuery();
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration(n2));
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n3);
        if (0 > n3) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SCALE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n3), "0");
        }
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration(n2, n3));
    }

    @Override
    protected final boolean isCallableStatement() {
        return true;
    }

    protected final void setWasLastNull(boolean bl) {
        this.m_wasLastValueRetrievedNull = bl;
    }

    protected final <T> T setWasNullAndReturn(T t) {
        this.setWasLastNull(t == null);
        return t;
    }

    protected final <T extends Closeable> T setStreamWasNullAndReturn(T t) {
        if (t != null) {
            this.onReturningStream(t);
        }
        return this.setWasNullAndReturn(t);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        return this.m_wasLastValueRetrievedNull;
    }

    protected final void onReturningStream(Closeable closeable) {
        assert (this.m_lastReturnedStream == null);
        assert (closeable != null);
        this.m_lastReturnedStream = closeable;
    }

    private IJDBCDataSource getDataSourceForGet(int n) throws SQLException {
        if (this.m_lastReturnedStream != null) {
            try {
                this.m_lastReturnedStream.close();
            }
            catch (Exception exception) {
                LogUtilities.logWarning(exception, this.m_logger);
            }
            this.m_lastReturnedStream = null;
        }
        switch (this.m_outputParamStatus) {
            case AVAILABLE: {
                break;
            }
            case FAILED: {
                throw new RuntimeException("Output parameters are unavailable since execution failed.");
            }
            case NOT_YET_AVAILABLE: {
                throw new RuntimeException("Output parameters are not yet available, execution results must first be consumed.");
            }
        }
        if (!this.isOutputParameter(n)) {
            this.throwInvalidParameterIndexException(n);
        }
        if (this.m_dataSources[n - 1] == null) {
            this.m_dataSources[n - 1] = this.getJDBCDataSource(n - 1);
        }
        assert (this.m_dataSources[n - 1] != null);
        return this.m_dataSources[n - 1];
    }

    private IJDBCDataSource getJDBCDataSource(int n) throws SQLException {
        assert (this.getPreviousExecution() != null);
        try {
            return ConvertingJDBCDataSource.wrapSqlDataSourceIfNecessary(this.getPreviousExecution().getSqlDataSource(n), this.m_queryExecutor.getMetadataForParameters().get(n).getTypeMetadata(), this.getWarningListener());
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
        catch (UnsupportedException unsupportedException) {
            throw this.getUnsupportedException();
        }
    }

    private SQLException getInvalidParamTypeException(int n, String string) {
        return ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string);
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_stringGetter.get(this, n);
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_booleanGetter.get(this, n);
        return this.m_tempPrimitiveStorage != 0L;
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_byteGetter.get(this, n);
        return (byte)this.m_tempPrimitiveStorage;
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_shortGetter.get(this, n);
        return (short)this.m_tempPrimitiveStorage;
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_intGetter.get(this, n);
        return (int)this.m_tempPrimitiveStorage;
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_longGetter.get(this, n);
        return this.m_tempPrimitiveStorage;
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getLong(this.getParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_floatGetter.get(this, n);
        return Float.intBitsToFloat((int)this.m_tempPrimitiveStorage);
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        s_doubleGetter.get(this, n);
        return Double.longBitsToDouble(this.m_tempPrimitiveStorage);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceTwoLong(this.m_logger, n, n2);
        return s_bigDecimalGetter.get(this, n, n2);
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_bytesGetter.get(this, n);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_dateGetter.get(this, n);
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timeGetter.get(this, n);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_timestampGetter.get(this, n);
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_objectGetter.get(this, n);
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_bigDecimalGetter.get(this, n);
    }

    @Override
    public synchronized Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, n, map);
        return s_objectGetterWithMap.get(this, n, map);
    }

    public <S> S getObject(int n, Class<S> clazz) throws SQLException {
        throw new SQLException("Not implemented in JDBC 4.0");
    }

    @Override
    public synchronized Ref getRef(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_refGetter.get(this, n);
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_blobGetter.get(this, n);
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_clobGetter.get(this, n);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLongOneObj(this.m_logger, n, calendar);
        return s_dateGetter.get(this, n, calendar);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLongOneObj(this.m_logger, n, calendar);
        return s_timeGetter.get(this, n, calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneLongOneObj(this.m_logger, n, calendar);
        return s_timestampGetter.get(this, n, calendar);
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.registerOutputParameter(n, new IJDBCExecution.OutputParameterRegistration(n2, string));
    }

    @Override
    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration(n));
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration(n, n2));
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, string2);
        this.registerOutputParameter(this.getParameterIndex(string), new IJDBCExecution.OutputParameterRegistration(n, string2));
    }

    @Override
    public synchronized URL getURL(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_urlGetter.get(this, n);
    }

    @Override
    public synchronized void setURL(String string, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setURL(this.getParameterIndex(string), uRL);
    }

    @Override
    public synchronized void setNull(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObjOneLong(this.m_logger, string, n);
        this.setNull(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBoolean(this.getParameterIndex(string), bl);
    }

    @Override
    public synchronized void setByte(String string, byte by) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setByte(this.getParameterIndex(string), by);
    }

    @Override
    public synchronized void setShort(String string, short s) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setShort(this.getParameterIndex(string), s);
    }

    @Override
    public synchronized void setInt(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setInt(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setLong(String string, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setLong(this.getParameterIndex(string), l);
    }

    @Override
    public synchronized void setFloat(String string, float f) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setFloat(this.getParameterIndex(string), f);
    }

    @Override
    public synchronized void setDouble(String string, double d) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setDouble(this.getParameterIndex(string), d);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBigDecimal(this.getParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setString(this.getParameterIndex(string), string2);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBytes(this.getParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setDate(String string, Date date) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setDate(this.getParameterIndex(string), date);
    }

    @Override
    public synchronized void setTime(String string, Time time) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setTime(this.getParameterIndex(string), time);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setTimestamp(this.getParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setObject(this.getParameterIndex(string), object, n, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setObject(this.getParameterIndex(string), object, n);
    }

    @Override
    public synchronized void setObject(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setObject(this.getParameterIndex(string), object);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setCharacterStream(this.getParameterIndex(string), reader, n);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setDate(this.getParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setTime(this.getParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setTimestamp(this.getParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setNull(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntranceOneObjOneLongOneObj(this.m_logger, string, n, string2);
        this.setNull(this.getParameterIndex(string), n, string2);
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getString(this.getParameterIndex(string));
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBoolean(this.getParameterIndex(string));
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getByte(this.getParameterIndex(string));
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getShort(this.getParameterIndex(string));
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getInt(this.getParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getFloat(this.getParameterIndex(string));
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getDouble(this.getParameterIndex(string));
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBytes(this.getParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getDate(this.getParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getTime(this.getParameterIndex(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getTimestamp(this.getParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getObject(this.getParameterIndex(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBigDecimal(this.getParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, map);
        return this.getObject(this.getParameterIndex(string));
    }

    @Override
    public synchronized Ref getRef(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getRef(this.getParameterIndex(string));
    }

    @Override
    public synchronized Blob getBlob(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBlob(this.getParameterIndex(string));
    }

    @Override
    public synchronized Clob getClob(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getClob(this.getParameterIndex(string));
    }

    @Override
    public synchronized Array getArray(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        IArray iArray = s_arrayGetter.get(this, n);
        if (iArray == null) {
            return null;
        }
        return this.getParentConnection().getJDBCObjectFactory().newArray(iArray, this.getParentConnection(), this.m_warningListener, this.m_logger);
    }

    @Override
    public synchronized Array getArray(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getArray(this.getParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getDate(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getTime(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getTimestamp(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized URL getURL(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getURL(this.getParameterIndex(string));
    }

    @Override
    public synchronized RowId getRowId(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_rowIdGetter.get(this, n);
    }

    @Override
    public synchronized RowId getRowId(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getRowId(this.getParameterIndex(string));
    }

    @Override
    public synchronized void setRowId(String string, RowId rowId) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setRowId(this.getParameterIndex(string), rowId);
    }

    @Override
    public synchronized void setNString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNString(this.getParameterIndex(string), string2);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public synchronized void setNClob(String string, NClob nClob) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNClob(this.getParameterIndex(string), nClob);
    }

    @Override
    public synchronized void setClob(String string, Reader reader, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBlob(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public synchronized NClob getNClob(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nClobGetter.get(this, n);
    }

    @Override
    public synchronized NClob getNClob(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getNClob(this.getParameterIndex(string));
    }

    @Override
    public synchronized void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setSQLXML(this.getParameterIndex(string), sQLXML);
    }

    @Override
    public synchronized SQLXML getSQLXML(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_sqlXmlGetter.get(this, n);
    }

    @Override
    public synchronized SQLXML getSQLXML(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getSQLXML(this.getParameterIndex(string));
    }

    @Override
    public synchronized String getNString(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nStringGetter.get(this, n);
    }

    @Override
    public synchronized String getNString(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getNString(this.getParameterIndex(string));
    }

    @Override
    public synchronized Reader getNCharacterStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_nCharStreamGetter.get(this, n);
    }

    @Override
    public synchronized Reader getNCharacterStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getNCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        return s_charStreamGetter.get(this, n);
    }

    @Override
    public synchronized Reader getCharacterStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public synchronized void setBlob(String string, Blob blob) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBlob(this.getParameterIndex(string), blob);
    }

    @Override
    public synchronized void setClob(String string, Clob clob) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setClob(this.getParameterIndex(string), clob);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBinaryStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public synchronized void setNCharacterStream(String string, Reader reader) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public synchronized void setClob(String string, Reader reader) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setClob(this.getParameterIndex(string), reader);
    }

    @Override
    public synchronized void setBlob(String string, InputStream inputStream) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setBlob(this.getParameterIndex(string), inputStream);
    }

    @Override
    public synchronized void setNClob(String string, Reader reader) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.setNClob(this.getParameterIndex(string), reader);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ConvertingJDBCDataSource.ReaderInputStream(reader, s_asciiCharSet);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        Reader reader = this.getCharacterStream(n);
        if (reader == null) {
            return null;
        }
        return new ConvertingJDBCDataSource.ReaderInputStream(reader, s_utf16CharSet);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    private static abstract class PrimitiveGetter {
        private PrimitiveGetter() {
        }

        public final void get(SCallableStatement sCallableStatement, int n) throws SQLException {
            sCallableStatement.checkIfOpen();
            try {
                IJDBCDataSource iJDBCDataSource = sCallableStatement.getDataSourceForGet(n);
                this.doGet(sCallableStatement, iJDBCDataSource);
                sCallableStatement.setWasLastNull(iJDBCDataSource.wasNull());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw sCallableStatement.getInvalidParamTypeException(n, this.getTypeName());
            }
            catch (UnsupportedException unsupportedException) {
                throw sCallableStatement.getUnsupportedException();
            }
            catch (ConversionFailed conversionFailed) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, (IWarningListener)sCallableStatement.m_warningListener, ExceptionType.DATA, this.getTypeName());
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, sCallableStatement.m_warningListener, sCallableStatement.m_logger);
            }
        }

        protected abstract String getTypeName();

        protected abstract void doGet(SCallableStatement var1, IJDBCDataSource var2) throws SQLException, IncorrectTypeException, UnsupportedException, ErrorException, ConversionFailed;
    }

    private static abstract class StreamGetter
    extends Getter<Reader, Object> {
        private StreamGetter() {
        }

        @Override
        protected Reader doSetWasNullAndReturn(SCallableStatement sCallableStatement, Reader reader) {
            return sCallableStatement.setStreamWasNullAndReturn(reader);
        }
    }

    protected static abstract class Getter<T, S> {
        protected Getter() {
        }

        public final T get(SCallableStatement sCallableStatement, int n) throws SQLException {
            return this.get(sCallableStatement, n, null);
        }

        public final T get(SCallableStatement sCallableStatement, int n, S s) throws SQLException {
            sCallableStatement.checkIfOpen();
            try {
                return this.doSetWasNullAndReturn(sCallableStatement, this.doGet(sCallableStatement.getDataSourceForGet(n), s));
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw sCallableStatement.getInvalidParamTypeException(n, this.getTypeName());
            }
            catch (UnsupportedException unsupportedException) {
                throw sCallableStatement.getUnsupportedException();
            }
            catch (ConversionFailed conversionFailed) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, (IWarningListener)sCallableStatement.m_warningListener, ExceptionType.DATA, this.getTypeName());
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, sCallableStatement.m_warningListener, sCallableStatement.m_logger);
            }
        }

        protected T doSetWasNullAndReturn(SCallableStatement sCallableStatement, T t) {
            return sCallableStatement.setWasNullAndReturn(t);
        }

        protected abstract String getTypeName();

        protected abstract T doGet(IJDBCDataSource var1, S var2) throws SQLException, IncorrectTypeException, ConversionFailed, UnsupportedException, ErrorException;
    }

    protected class OutputConsumer
    extends SPreparedStatement.OutputConsumer {
        protected OutputConsumer() {
            super(SCallableStatement.this);
        }

        @Override
        public void notifyParameterSetSucceeded() throws ErrorException {
            super.notifyParameterSetSucceeded();
            SCallableStatement.this.m_outputParamStatus = OutputParameterStatus.AVAILABLE;
        }

        @Override
        public void notifyParameterSetFailed() throws ErrorException {
            super.notifyParameterSetFailed();
            SCallableStatement.this.m_outputParamStatus = OutputParameterStatus.FAILED;
        }
    }

    private static enum OutputParameterStatus {
        NOT_YET_AVAILABLE,
        AVAILABLE,
        FAILED;

    }
}

