/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.jdbc42;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IDataEngine;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.OrderType;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.jdbc.common.SConnection;
import com.cloudera.hiveserver2.jdbc.common.SDatabaseMetaData;
import com.cloudera.hiveserver2.jdbc.jdbc42.S42MetaDataProxy;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class S42DatabaseMetaData
extends SDatabaseMetaData {
    private static final int JDBC_MINOR_VERSION = 2;

    public S42DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_42);
            S42MetaDataProxy s42MetaDataProxy = new S42MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s42MetaDataProxy);
            return s42MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            S42MetaDataProxy s42MetaDataProxy = new S42MetaDataProxy(this, null, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s42MetaDataProxy);
            return s42MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    protected synchronized ResultSet createUnorderedMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.NONE);
            S42MetaDataProxy s42MetaDataProxy = new S42MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
            this.m_resultSets.add(s42MetaDataProxy);
            return s42MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.PSEUDO_COLUMNS_JDBC41, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

