/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.utils;

import com.cloudera.hiveserver2.jdbc.utils.DSStringCache;
import com.cloudera.hiveserver2.jdbc.utils.DSStringCacheEntry;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DSStringMemoryCache
extends DSStringCache {
    private static final int MILLISEC_CONVERSION = 1000;
    private Map<String, DSStringCacheEntry> mp = new ConcurrentHashMap<String, DSStringCacheEntry>();

    DSStringMemoryCache(ILogger iLogger, boolean bl, boolean bl2) {
        super(iLogger, bl, bl2);
    }

    @Override
    public String getValue(String string) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.evictExpiredEntries();
        return this.mp.containsKey(string) ? this.mp.get((Object)string).value : null;
    }

    @Override
    public long getExpiry(String string) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.evictExpiredEntries();
        return this.mp.containsKey(string) ? Long.valueOf(this.mp.get((Object)string).expiry) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValue(String string, String string2, long l) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        DSStringMemoryCache dSStringMemoryCache = this;
        synchronized (dSStringMemoryCache) {
            this.evictExpiredEntries();
            this.mp.put(string, new DSStringCacheEntry(string, string2, new Date().getTime() + l * 1000L));
        }
        return true;
    }

    public Collection<DSStringCacheEntry> getValues() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.evictExpiredEntries();
        return this.mp.values();
    }

    public void addValuesWithoutReplacement(Collection<DSStringCacheEntry> collection) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (DSStringCacheEntry dSStringCacheEntry : collection) {
            if (this.mp.containsKey(dSStringCacheEntry.key)) continue;
            this.mp.put(dSStringCacheEntry.key, dSStringCacheEntry);
        }
        this.evictExpiredEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictExpiredEntries() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (DSStringCacheEntry dSStringCacheEntry : this.mp.values()) {
            if (dSStringCacheEntry.expiry >= new Date().getTime()) continue;
            DSStringMemoryCache dSStringMemoryCache = this;
            synchronized (dSStringMemoryCache) {
                this.mp.remove(dSStringCacheEntry.key);
            }
        }
    }
}

