/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor;

import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.sqlengine.SQLEngineGenericContext;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.utils.DSISqlConversionType;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.PTIdentifierNode;
import com.cloudera.hiveserver2.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver2.support.exceptions.DiagState;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import com.cloudera.hiveserver2.support.exceptions.InvalidOperationException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public class AEUtils {
    private static final Map<DSISqlConversionType, EnumSet<DSISqlConversionType>> CONVERSIONS;

    private AEUtils() {
        throw new UnsupportedOperationException("Cannot instantiate AEUtils class.");
    }

    public static AEQTableName adjustCatalogAndSchema(AEQTableName aEQTableName, SqlDataEngineContext sqlDataEngineContext, boolean bl) throws ErrorException {
        String string;
        AEQTableName.AEQTableNameBuilder aEQTableNameBuilder = new AEQTableName.AEQTableNameBuilder(aEQTableName);
        boolean bl2 = AEUtils.hasCatalogSupport(sqlDataEngineContext);
        boolean bl3 = aEQTableName.hasCatalogName();
        if (aEQTableName.hasCatalogName() && !bl2) {
            String string2 = SQLEngineMessageKey.CATALOG_NOT_SUPPORTED.name();
            throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(string2);
        }
        if (aEQTableName.hasSchemaName() && !AEUtils.hasSchemaSupport(sqlDataEngineContext)) {
            if (bl2 && !bl3) {
                aEQTableNameBuilder.setCatalogName(aEQTableName.getSchemaName());
                aEQTableNameBuilder.setSchemaName("");
                bl3 = true;
            } else {
                String string3 = SQLEngineMessageKey.SCHEMA_NOT_SUPPORTED.name();
                throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(string3);
            }
        }
        if (bl && !bl3 && bl2 && (string = AEUtils.currentCatalogName(sqlDataEngineContext)).length() > 0) {
            aEQTableNameBuilder.setCatalogName(string);
        }
        return aEQTableNameBuilder.build();
    }

    public static void checkReadOnly(SqlDataEngineContext sqlDataEngineContext, String string) throws ErrorException {
        Variant variant = sqlDataEngineContext.getConnProperty(16);
        assert (null != variant && variant.getType() == 3);
        try {
            if (variant.getLong() == 1L) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_OP_DRIVER_READ_ONLY.name(), new String[]{string});
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
    }

    public static String getIdentifierString(IPTNode iPTNode) throws ErrorException {
        if (iPTNode.isEmptyNode()) {
            return "";
        }
        if (iPTNode instanceof PTIdentifierNode) {
            return ((PTIdentifierNode)iPTNode).getIdentifier();
        }
        throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{"Wrong parse node type used to get identifier."});
    }

    public static boolean isTypeNumeric(short s) {
        return TypeUtilities.isIntegerType(s) || TypeUtilities.isApproximateNumericType(s) || TypeUtilities.isExactNumericType(s) || -7 == s;
    }

    public static boolean isConversionLegal(int n, int n2) throws ErrorException {
        DSISqlConversionType dSISqlConversionType = DSISqlConversionType.fromSqlType(n);
        DSISqlConversionType dSISqlConversionType2 = DSISqlConversionType.fromSqlType(n2);
        return CONVERSIONS.get((Object)dSISqlConversionType).contains((Object)dSISqlConversionType2);
    }

    public static boolean isAnyConversionLegal(int n, int n2, int ... nArray) throws ErrorException {
        DSISqlConversionType dSISqlConversionType = DSISqlConversionType.fromSqlType(n);
        DSISqlConversionType dSISqlConversionType2 = DSISqlConversionType.fromSqlType(n2);
        EnumSet<DSISqlConversionType> enumSet = CONVERSIONS.get((Object)dSISqlConversionType);
        if (enumSet.contains((Object)dSISqlConversionType2)) {
            return true;
        }
        for (int n3 : nArray) {
            if (!enumSet.contains((Object)DSISqlConversionType.fromSqlType(n3))) continue;
            return true;
        }
        return false;
    }

    public static String sqlQuoted(String string) {
        return "\"" + string.replace("\"", "\"\"") + "\"";
    }

    private static String currentCatalogName(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return sqlDataEngineContext.getConnProperty(22).getString();
    }

    private static boolean hasCatalogSupport(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return "Y".equals(sqlDataEngineContext.getConnProperty(9).getString());
    }

    private static boolean hasSchemaSupport(SqlDataEngineContext sqlDataEngineContext) throws ErrorException {
        return sqlDataEngineContext.getConnProperty(99).getString().length() > 0;
    }

    private static <E extends Enum<E>> EnumSet<E> unionOf(EnumSet<E> enumSet, EnumSet<E> enumSet2) {
        EnumSet<E> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.addAll(enumSet2);
        return enumSet3;
    }

    private static <E extends Enum<E>> EnumSet<E> unionOf(EnumSet<E> enumSet, EnumSet<E> enumSet2, EnumSet<E> enumSet3) {
        EnumSet<E> enumSet4 = EnumSet.copyOf(enumSet);
        enumSet4.addAll(enumSet2);
        enumSet4.addAll(enumSet3);
        return enumSet4;
    }

    private static <E extends Enum<E>> EnumSet<E> unionOf(EnumSet<E> enumSet, EnumSet<E> enumSet2, EnumSet<E> enumSet3, EnumSet<E> enumSet4) {
        EnumSet<E> enumSet5 = EnumSet.copyOf(enumSet);
        enumSet5.addAll(enumSet2);
        enumSet5.addAll(enumSet3);
        enumSet5.addAll(enumSet4);
        return enumSet5;
    }

    static {
        EnumMap<DSISqlConversionType, EnumSet<DSISqlConversionType>> enumMap = new EnumMap<DSISqlConversionType, EnumSet<DSISqlConversionType>>(DSISqlConversionType.class);
        EnumSet<DSISqlConversionType[]> enumSet = EnumSet.of(DSISqlConversionType.DSI_CVT_CHAR, new DSISqlConversionType[]{DSISqlConversionType.DSI_CVT_VARCHAR, DSISqlConversionType.DSI_CVT_LONGVARCHAR, DSISqlConversionType.DSI_CVT_WCHAR, DSISqlConversionType.DSI_CVT_WVARCHAR, DSISqlConversionType.DSI_CVT_WLONGVARCHAR});
        EnumSet<DSISqlConversionType> enumSet2 = EnumSet.of(DSISqlConversionType.DSI_CVT_BINARY, DSISqlConversionType.DSI_CVT_VARBINARY);
        EnumSet<DSISqlConversionType> enumSet3 = EnumSet.of(DSISqlConversionType.DSI_CVT_BINARY, DSISqlConversionType.DSI_CVT_VARBINARY, DSISqlConversionType.DSI_CVT_LONGVARBINARY);
        EnumSet<DSISqlConversionType> enumSet4 = EnumSet.of(DSISqlConversionType.DSI_CVT_INTERVAL_DAY_SECOND, DSISqlConversionType.DSI_CVT_INTERVAL_YEAR_MONTH);
        EnumSet<DSISqlConversionType> enumSet5 = EnumSet.of(DSISqlConversionType.DSI_CVT_DATE, DSISqlConversionType.DSI_CVT_TIME, DSISqlConversionType.DSI_CVT_TIMESTAMP);
        EnumSet<DSISqlConversionType> enumSet6 = EnumSet.of(DSISqlConversionType.DSI_CVT_TINYINT, DSISqlConversionType.DSI_CVT_SMALLINT, DSISqlConversionType.DSI_CVT_INTEGER, DSISqlConversionType.DSI_CVT_BIGINT);
        EnumSet<DSISqlConversionType[]> enumSet7 = EnumSet.of(DSISqlConversionType.DSI_CVT_NUMERIC, new DSISqlConversionType[]{DSISqlConversionType.DSI_CVT_DECIMAL, DSISqlConversionType.DSI_CVT_TINYINT, DSISqlConversionType.DSI_CVT_SMALLINT, DSISqlConversionType.DSI_CVT_INTEGER, DSISqlConversionType.DSI_CVT_BIGINT, DSISqlConversionType.DSI_CVT_REAL, DSISqlConversionType.DSI_CVT_FLOAT, DSISqlConversionType.DSI_CVT_DOUBLE});
        EnumSet<DSISqlConversionType> enumSet8 = EnumSet.of(DSISqlConversionType.DSI_CVT_ARRAY);
        enumMap.put(DSISqlConversionType.DSI_CVT_CHAR, EnumSet.allOf(DSISqlConversionType.class));
        enumMap.put(DSISqlConversionType.DSI_CVT_VARCHAR, EnumSet.allOf(DSISqlConversionType.class));
        enumMap.put(DSISqlConversionType.DSI_CVT_LONGVARCHAR, EnumSet.complementOf(enumSet3));
        enumMap.put(DSISqlConversionType.DSI_CVT_WCHAR, EnumSet.allOf(DSISqlConversionType.class));
        enumMap.put(DSISqlConversionType.DSI_CVT_WVARCHAR, EnumSet.allOf(DSISqlConversionType.class));
        enumMap.put(DSISqlConversionType.DSI_CVT_WLONGVARCHAR, EnumSet.complementOf(enumSet3));
        enumMap.put(DSISqlConversionType.DSI_CVT_BIT, EnumSet.complementOf(AEUtils.unionOf(enumSet4, enumSet5, EnumSet.of(DSISqlConversionType.DSI_CVT_GUID))));
        enumMap.put(DSISqlConversionType.DSI_CVT_BOOLEAN, EnumSet.complementOf(AEUtils.unionOf(enumSet4, enumSet5, EnumSet.of(DSISqlConversionType.DSI_CVT_GUID))));
        enumMap.put(DSISqlConversionType.DSI_CVT_BINARY, AEUtils.unionOf(enumSet, enumSet3));
        enumMap.put(DSISqlConversionType.DSI_CVT_VARBINARY, AEUtils.unionOf(enumSet, enumSet3));
        enumMap.put(DSISqlConversionType.DSI_CVT_LONGVARBINARY, AEUtils.unionOf(enumSet, enumSet3));
        enumMap.put(DSISqlConversionType.DSI_CVT_NUMERIC, AEUtils.unionOf(enumSet, enumSet7, enumSet4));
        enumMap.put(DSISqlConversionType.DSI_CVT_DECIMAL, AEUtils.unionOf(enumSet, enumSet7, enumSet4));
        EnumSet<DSISqlConversionType> enumSet9 = AEUtils.unionOf(enumSet, enumSet7, enumSet4, EnumSet.of(DSISqlConversionType.DSI_CVT_BIT, DSISqlConversionType.DSI_CVT_BOOLEAN, DSISqlConversionType.DSI_CVT_BINARY, DSISqlConversionType.DSI_CVT_VARBINARY));
        enumMap.put(DSISqlConversionType.DSI_CVT_TINYINT, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_SMALLINT, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_INTEGER, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_BIGINT, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_REAL, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_FLOAT, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_DOUBLE, EnumSet.copyOf(enumSet9));
        enumMap.put(DSISqlConversionType.DSI_CVT_DATE, AEUtils.unionOf(enumSet, enumSet2, EnumSet.of(DSISqlConversionType.DSI_CVT_DATE, DSISqlConversionType.DSI_CVT_TIMESTAMP)));
        enumMap.put(DSISqlConversionType.DSI_CVT_TIME, AEUtils.unionOf(enumSet, enumSet2, EnumSet.of(DSISqlConversionType.DSI_CVT_TIME, DSISqlConversionType.DSI_CVT_TIMESTAMP)));
        enumMap.put(DSISqlConversionType.DSI_CVT_TIMESTAMP, AEUtils.unionOf(enumSet, enumSet2, enumSet5));
        enumMap.put(DSISqlConversionType.DSI_CVT_INTERVAL_YEAR_MONTH, AEUtils.unionOf(enumSet, enumSet2, enumSet6, EnumSet.of(DSISqlConversionType.DSI_CVT_NUMERIC, DSISqlConversionType.DSI_CVT_DECIMAL, DSISqlConversionType.DSI_CVT_INTERVAL_YEAR_MONTH)));
        enumMap.put(DSISqlConversionType.DSI_CVT_INTERVAL_DAY_SECOND, AEUtils.unionOf(enumSet, enumSet2, enumSet6, EnumSet.of(DSISqlConversionType.DSI_CVT_NUMERIC, DSISqlConversionType.DSI_CVT_DECIMAL, DSISqlConversionType.DSI_CVT_INTERVAL_DAY_SECOND)));
        enumMap.put(DSISqlConversionType.DSI_CVT_GUID, AEUtils.unionOf(enumSet, enumSet2, EnumSet.of(DSISqlConversionType.DSI_CVT_GUID)));
        enumMap.put(DSISqlConversionType.DSI_CVT_NULL, EnumSet.allOf(DSISqlConversionType.class));
        enumMap.put(DSISqlConversionType.DSI_CVT_ARRAY, EnumSet.copyOf(enumSet8));
        CONVERSIONS = Collections.unmodifiableMap(enumMap);
    }
}

