/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.conversions;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.support.conv.CharConverter;
import com.cloudera.hiveserver2.support.conv.ConversionResult;
import com.cloudera.hiveserver2.support.conv.HexToBinaryConverter;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.UUID;

public class SqlCharTypeConverter
implements ISqlConverter {
    private final short m_tgtType;
    private final short m_tgtPrecision;
    private final short m_tgtScale;
    private final boolean m_tgtIsSigned;
    private final IColumn m_targetMetadata;

    public SqlCharTypeConverter(IColumn iColumn, IColumn iColumn2) {
        assert (TypeUtilities.isCharacterType(iColumn.getTypeMetadata().getType()));
        this.m_targetMetadata = iColumn2;
        TypeMetadata typeMetadata = iColumn2.getTypeMetadata();
        this.m_tgtType = typeMetadata.getType();
        this.m_tgtPrecision = typeMetadata.getPrecision();
        this.m_tgtScale = typeMetadata.getScale();
        this.m_tgtIsSigned = typeMetadata.isSigned();
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            String string = iSqlDataWrapper.getChar();
            switch (this.m_tgtType) {
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    String string2 = CharConverter.toChar(string, this.m_targetMetadata.getColumnLength(), conversionResult);
                    iSqlDataWrapper2.setChar(string2);
                    break;
                }
                case -5: {
                    BigInteger bigInteger = CharConverter.toBigInt(string, conversionResult, this.m_tgtIsSigned);
                    iSqlDataWrapper2.setBigInt(bigInteger);
                    break;
                }
                case 16: {
                    boolean bl = CharConverter.toBoolean(string, conversionResult);
                    iSqlDataWrapper2.setBoolean(bl);
                    break;
                }
                case -7: {
                    boolean bl = CharConverter.toBit(string, conversionResult);
                    iSqlDataWrapper2.setBoolean(bl);
                    break;
                }
                case 91: {
                    Date date = CharConverter.toDate(string, conversionResult, new GregorianCalendar());
                    iSqlDataWrapper2.setDate(date);
                    break;
                }
                case 6: 
                case 8: {
                    double d = CharConverter.toDouble(string, conversionResult);
                    iSqlDataWrapper2.setDouble(d);
                    break;
                }
                case -11: {
                    UUID uUID = CharConverter.toGUID(string, conversionResult);
                    iSqlDataWrapper2.setGuid(uUID);
                    break;
                }
                case 4: {
                    long l = CharConverter.toInteger(string, conversionResult, this.m_tgtIsSigned);
                    iSqlDataWrapper2.setInteger(l);
                    break;
                }
                case 7: {
                    float f = CharConverter.toReal(string, conversionResult);
                    iSqlDataWrapper2.setReal(f);
                    break;
                }
                case 5: {
                    int n = CharConverter.toSmallint(string, conversionResult, this.m_tgtIsSigned);
                    iSqlDataWrapper2.setSmallInt(n);
                    break;
                }
                case 92: {
                    Time time = CharConverter.toTime(string, conversionResult, this.m_tgtPrecision, new GregorianCalendar());
                    iSqlDataWrapper2.setTime(time);
                    break;
                }
                case -6: {
                    short s = CharConverter.toTinyint(string, conversionResult, this.m_tgtIsSigned);
                    iSqlDataWrapper2.setTinyInt(s);
                    break;
                }
                case 93: {
                    Timestamp timestamp = CharConverter.toTimestamp(string, conversionResult, this.m_tgtPrecision, new GregorianCalendar());
                    iSqlDataWrapper2.setTimestamp(timestamp);
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = CharConverter.toExactNum(string, conversionResult, this.m_tgtPrecision, this.m_tgtScale);
                    iSqlDataWrapper2.setExactNumber(bigDecimal);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = HexToBinaryConverter.toBinary(string, this.m_targetMetadata.getColumnLength(), conversionResult);
                    iSqlDataWrapper2.setBinary(byArray);
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_tgtType));
                }
            }
        }
        return conversionResult;
    }
}

