/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.datawrapper;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlArrayDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlBigIntDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlBinaryDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlBooleanDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlDateDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlDoubleDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlExactNumDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlGuidDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlIntegerDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlRealDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlSmallIntDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlTimeDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlTimestampDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlTinyIntDataWrapper;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DefaultSqlDataWrapper
implements ISqlDataWrapper {
    private static Map<Integer, Set<Integer>> s_implicitConvMap = new HashMap<Integer, Set<Integer>>();

    public static ISqlDataWrapper initializeFromSqlType(int n) {
        switch (n) {
            case -5: {
                return new SqlBigIntDataWrapper();
            }
            case 2: 
            case 3: {
                return new SqlExactNumDataWrapper(n);
            }
            case 6: 
            case 8: {
                return new SqlDoubleDataWrapper(n);
            }
            case 7: {
                return new SqlRealDataWrapper();
            }
            case -4: 
            case -3: 
            case -2: {
                return new SqlBinaryDataWrapper(n);
            }
            case -7: 
            case 16: {
                return new SqlBooleanDataWrapper(n);
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return new SqlCharDataWrapper(n);
            }
            case 91: {
                return new SqlDateDataWrapper();
            }
            case 92: {
                return new SqlTimeDataWrapper();
            }
            case 93: {
                return new SqlTimestampDataWrapper();
            }
            case -11: {
                return new SqlGuidDataWrapper();
            }
            case 4: {
                return new SqlIntegerDataWrapper();
            }
            case 5: {
                return new SqlSmallIntDataWrapper();
            }
            case -6: {
                return new SqlTinyIntDataWrapper();
            }
            case 2003: {
                return new SqlArrayDataWrapper();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + n);
    }

    public static void setDataWrapperFromDataWrapper(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            return;
        }
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                iSqlDataWrapper2.setBigInt(iSqlDataWrapper.getBigInt());
                break;
            }
            case 2: 
            case 3: {
                iSqlDataWrapper2.setExactNumber(iSqlDataWrapper.getExactNumber());
                break;
            }
            case 6: 
            case 8: {
                iSqlDataWrapper2.setDouble(iSqlDataWrapper.getDouble());
                break;
            }
            case 7: {
                iSqlDataWrapper2.setReal(iSqlDataWrapper.getReal());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                iSqlDataWrapper2.setBinary(iSqlDataWrapper.getBinary());
                break;
            }
            case -7: 
            case 16: {
                iSqlDataWrapper2.setBoolean(iSqlDataWrapper.getBoolean());
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                iSqlDataWrapper2.setChar(iSqlDataWrapper.getChar());
                break;
            }
            case 91: {
                iSqlDataWrapper2.setDate(iSqlDataWrapper.getDate());
                break;
            }
            case 92: {
                iSqlDataWrapper2.setTime(iSqlDataWrapper.getTime());
                break;
            }
            case 93: {
                iSqlDataWrapper2.setTimestamp(iSqlDataWrapper.getTimestamp());
                break;
            }
            case -11: {
                iSqlDataWrapper2.setGuid(iSqlDataWrapper.getGuid());
                break;
            }
            case 4: {
                iSqlDataWrapper2.setInteger(iSqlDataWrapper.getInteger());
                break;
            }
            case 5: {
                iSqlDataWrapper2.setSmallInt(iSqlDataWrapper.getSmallInt());
                break;
            }
            case -6: {
                iSqlDataWrapper2.setTinyInt(iSqlDataWrapper.getTinyInt());
                break;
            }
            case 2003: {
                iSqlDataWrapper2.setArray(iSqlDataWrapper.getArray());
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + iSqlDataWrapper.getType());
            }
        }
    }

    public static boolean isImplicitConvSupported(IColumn iColumn, IColumn iColumn2) throws ErrorException {
        if (iColumn.getTypeMetadata().getType() == 0) {
            return true;
        }
        Set<Integer> set = s_implicitConvMap.get(iColumn.getTypeMetadata().getType());
        if (!set.contains(iColumn2.getTypeMetadata().getType())) {
            return false;
        }
        return DefaultSqlDataWrapper.isCompatibleMeta(iColumn, iColumn2);
    }

    private static boolean isCompatibleMeta(IColumn iColumn, IColumn iColumn2) throws ErrorException {
        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
        TypeMetadata typeMetadata2 = iColumn2.getTypeMetadata();
        if (typeMetadata.isCharacterType() && typeMetadata2.isCharacterType()) {
            return iColumn2.getColumnLength() >= iColumn.getColumnLength();
        }
        if (typeMetadata.isBinaryType() && typeMetadata2.isBinaryType()) {
            return iColumn2.getColumnLength() >= iColumn.getColumnLength();
        }
        if (typeMetadata.isIntegerType() && typeMetadata2.isIntegerType()) {
            int n = DefaultSqlDataWrapper.integralTypeCompareTo(typeMetadata.getType(), typeMetadata2.getType());
            if (0 == n) {
                return typeMetadata.isSigned() == typeMetadata2.isSigned();
            }
            if (0 > n) {
                return typeMetadata.isSigned() == typeMetadata2.isSigned() || typeMetadata2.isSigned();
            }
            return false;
        }
        if (typeMetadata.isExactNumericType() && typeMetadata2.isExactNumericType()) {
            short s = typeMetadata.getScale();
            short s2 = typeMetadata2.getScale();
            int n = typeMetadata.getPrecision() - s;
            int n2 = typeMetadata2.getPrecision() - s2;
            return n2 >= n && s2 >= s;
        }
        if (typeMetadata.getType() == 93 && typeMetadata2.getType() == 93) {
            return typeMetadata2.getPrecision() >= typeMetadata.getPrecision();
        }
        if (typeMetadata.getType() == 92 && typeMetadata2.getType() == 92) {
            return typeMetadata2.getPrecision() >= typeMetadata.getPrecision();
        }
        return true;
    }

    private static int integralTypeCompareTo(short s, short s2) throws ErrorException {
        switch (s) {
            case -6: {
                if (-6 == s2) {
                    return 0;
                }
                return -1;
            }
            case 5: {
                if (5 == s2) {
                    return 0;
                }
                if (-6 == s2) {
                    return 1;
                }
                return -1;
            }
            case 4: {
                if (4 == s2) {
                    return 0;
                }
                if (-5 == s2) {
                    return -1;
                }
                return 1;
            }
            case -5: {
                if (-5 == s2) {
                    return 0;
                }
                return 1;
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException("Unknown type");
    }

    @Override
    public BigInteger getBigInt() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-5);
    }

    @Override
    public byte[] getBinary() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-2);
    }

    @Override
    public boolean getBoolean() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(16);
    }

    @Override
    public String getChar() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(1);
    }

    @Override
    public Date getDate() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(91);
    }

    @Override
    public java.util.Date getJavaUtilDate() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(91);
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(8);
    }

    @Override
    public BigDecimal getExactNumber() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(3);
    }

    @Override
    public UUID getGuid() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-11);
    }

    @Override
    public long getInteger() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(4);
    }

    @Override
    public Object getInterval() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(10);
    }

    @Override
    public float getReal() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(7);
    }

    @Override
    public int getSmallInt() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(5);
    }

    @Override
    public Time getTime() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(92);
    }

    @Override
    public Timestamp getTimestamp() throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(93);
    }

    @Override
    public short getTinyInt() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-6);
    }

    @Override
    public IArray getArray() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(2003);
    }

    @Override
    public void setBigInt(BigInteger bigInteger) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-5);
    }

    @Override
    public void setBinary(byte[] byArray) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-6);
    }

    @Override
    public void setBoolean(boolean bl) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(16);
    }

    @Override
    public void setChar(String string) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(1);
    }

    @Override
    public void setDate(Date date) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(91);
    }

    @Override
    public void setDouble(double d) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(8);
    }

    @Override
    public void setExactNumber(BigDecimal bigDecimal) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(3);
    }

    @Override
    public void setGuid(UUID uUID) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-11);
    }

    @Override
    public void setInteger(long l) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(4);
    }

    @Override
    public void setInterval(Object object) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(10);
    }

    @Override
    public void setReal(float f) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(6);
    }

    @Override
    public void setSmallInt(int n) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(5);
    }

    @Override
    public void setTime(Time time) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(92);
    }

    @Override
    public void setTimestamp(Timestamp timestamp) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(93);
    }

    @Override
    public void setTinyInt(short s) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(-6);
    }

    @Override
    public void setArray(IArray iArray) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(2003);
    }

    static {
        s_implicitConvMap.put(-2, new HashSet<Integer>(Arrays.asList(-2, -3, -4)));
        s_implicitConvMap.put(-3, new HashSet<Integer>(Arrays.asList(-2, -3, -4)));
        s_implicitConvMap.put(-4, new HashSet<Integer>(Arrays.asList(-2, -3, -4)));
        s_implicitConvMap.put(1, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(12, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(-1, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(-8, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(-9, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(-10, new HashSet<Integer>(Arrays.asList(1, 12, -1, -8, -9, -10)));
        s_implicitConvMap.put(-7, new HashSet<Integer>(Arrays.asList(-7, -5, 8, 16, 6, 4, 7, 5, -6)));
        s_implicitConvMap.put(16, new HashSet<Integer>(Arrays.asList(16, -5, 8, -7, 6, 4, 7, 5, -6)));
        s_implicitConvMap.put(-6, new HashSet<Integer>(Arrays.asList(-6, 5, 4, -5, 8, 6, 7)));
        s_implicitConvMap.put(5, new HashSet<Integer>(Arrays.asList(5, 4, -5, 8, 6, 7)));
        s_implicitConvMap.put(4, new HashSet<Integer>(Arrays.asList(4, -5, 8, 6)));
        s_implicitConvMap.put(-5, new HashSet<Integer>(Arrays.asList(-5)));
        s_implicitConvMap.put(2, new HashSet<Integer>(Arrays.asList(2, 3)));
        s_implicitConvMap.put(3, new HashSet<Integer>(Arrays.asList(2, 3)));
        s_implicitConvMap.put(7, new HashSet<Integer>(Arrays.asList(7, 8, 6)));
        s_implicitConvMap.put(8, new HashSet<Integer>(Arrays.asList(8, 6)));
        s_implicitConvMap.put(6, new HashSet<Integer>(Arrays.asList(8, 6)));
        s_implicitConvMap.put(91, new HashSet<Integer>(Arrays.asList(91)));
        s_implicitConvMap.put(92, new HashSet<Integer>(Arrays.asList(92)));
        s_implicitConvMap.put(93, new HashSet<Integer>(Arrays.asList(93)));
        s_implicitConvMap.put(-11, new HashSet<Integer>(Arrays.asList(-11)));
        s_implicitConvMap.put(2003, new HashSet<Integer>(Arrays.asList(new Integer[0])));
    }
}

