/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.temptable;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.BooleanComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.CharComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.ColumnComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.DateComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.DoubleComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.ExactNumComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.GuidComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.RealComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.SignedBigIntComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.SignedIntegerComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.SignedSmallIntComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.SignedTinyIntComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.TimeComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.TimestampComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.UnsignedBigIntComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.UnsignedIntegerComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.UnsignedSmallIntComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.UnsignedTinyIntComparator;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class RowComparator
implements Comparator<IRowView> {
    private ArrayList<Comparator<IRowView>> m_comparators = new ArrayList();

    public static RowComparator createComparator(IColumn[] iColumnArray, List<AESortSpec> list, NullCollation nullCollation) throws ErrorException {
        ArrayList<Comparator<IRowView>> arrayList = new ArrayList<Comparator<IRowView>>();
        block15: for (AESortSpec aESortSpec : list) {
            TypeMetadata typeMetadata = iColumnArray[aESortSpec.getColumnNumber()].getTypeMetadata();
            switch (typeMetadata.getType()) {
                case -7: 
                case 16: {
                    arrayList.add(new BooleanComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    arrayList.add(new CharComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case -5: {
                    ColumnComparator columnComparator = typeMetadata.isSigned() ? new SignedBigIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)) : new UnsignedBigIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation));
                    arrayList.add(columnComparator);
                    continue block15;
                }
                case 4: {
                    ColumnComparator columnComparator = typeMetadata.isSigned() ? new SignedIntegerComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)) : new UnsignedIntegerComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation));
                    arrayList.add(columnComparator);
                    continue block15;
                }
                case -6: {
                    ColumnComparator columnComparator = typeMetadata.isSigned() ? new SignedTinyIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)) : new UnsignedTinyIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation));
                    arrayList.add(columnComparator);
                    continue block15;
                }
                case 5: {
                    ColumnComparator columnComparator = typeMetadata.isSigned() ? new SignedSmallIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)) : new UnsignedSmallIntComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation));
                    arrayList.add(columnComparator);
                    continue block15;
                }
                case 7: {
                    arrayList.add(new RealComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case 6: 
                case 8: {
                    arrayList.add(new DoubleComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case -11: {
                    arrayList.add(new GuidComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case 2: 
                case 3: {
                    arrayList.add(new ExactNumComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case 91: {
                    arrayList.add(new DateComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case 92: {
                    arrayList.add(new TimeComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
                case 93: {
                    arrayList.add(new TimestampComparator(aESortSpec.getColumnNumber(), aESortSpec.isAscending(), RowComparator.nullsSortedFirst(aESortSpec.isAscending(), nullCollation)));
                    continue block15;
                }
            }
            throw SQLEngineExceptionFactory.invalidOrderByColumnException("" + (aESortSpec.getColumnNumber() + 1));
        }
        return new RowComparator(arrayList);
    }

    public static NullCollation getDefaultNullCollation() {
        return NullCollation.NULLS_END;
    }

    public static AESortSpec createDefaultSortSpec(int n) {
        return new AESortSpec(n, false);
    }

    public RowComparator(List<Comparator<IRowView>> list) {
        for (Comparator<IRowView> comparator : list) {
            this.m_comparators.add(comparator);
        }
    }

    @Override
    public int compare(IRowView iRowView, IRowView iRowView2) {
        for (int i = 0; i < this.m_comparators.size(); ++i) {
            int n = this.m_comparators.get(i).compare(iRowView, iRowView2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private static boolean nullsSortedFirst(boolean bl, NullCollation nullCollation) {
        switch (nullCollation) {
            case NULLS_END: {
                return false;
            }
            case NULLS_HI: {
                return !bl;
            }
            case NULLS_LO: {
                return bl;
            }
        }
        return true;
    }

    public static enum NullCollation {
        NULLS_START,
        NULLS_HI,
        NULLS_LO,
        NULLS_END;

    }
}

