/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.cloudera.hiveserver2.sqlengine.executor.etree.util.CompressionUtil;

public final class TinyIntColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 6481926827866336384L;
    private byte[] m_data;
    private byte[] m_nullInd;
    private final int m_columnNumber;
    private final boolean m_isSigned;

    public TinyIntColumnSlice(int n, int n2, boolean bl) {
        this.m_data = new byte[n];
        this.m_nullInd = new byte[(n + 7) / 8];
        this.m_columnNumber = n2;
        this.m_isSigned = bl;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullInd, n);
    }

    @Override
    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullInd, n);
    }

    @Override
    public byte getTinyInt(int n) {
        return this.m_data[n];
    }

    @Override
    public long getBigInt(int n) {
        return CompressionUtil.getTinyIntAsShort(this.m_data[n], this.m_isSigned);
    }

    @Override
    public double getDouble(int n) {
        return CompressionUtil.getTinyIntAsShort(this.m_data[n], this.m_isSigned);
    }

    @Override
    public float getReal(int n) {
        return CompressionUtil.getTinyIntAsShort(this.m_data[n], this.m_isSigned);
    }

    @Override
    public int getInteger(int n) {
        return CompressionUtil.getTinyIntAsShort(this.m_data[n], this.m_isSigned);
    }

    @Override
    public short getSmallInt(int n) {
        return CompressionUtil.getTinyIntAsShort(this.m_data[n], this.m_isSigned);
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.TINYINT;
    }

    @Override
    public void setTinyInt(int n, byte by) {
        this.m_data[n] = by;
        BitsUtil.clearBit(this.m_nullInd, n);
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        TinyIntColumnSlice tinyIntColumnSlice = (TinyIntColumnSlice)iColumnSlice;
        System.arraycopy(tinyIntColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullInd, n3, n2, tinyIntColumnSlice.m_nullInd, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return 1.125 * (double)javaSize.getByteSize();
    }
}

