/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETConstant;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver2.support.Pair;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ETExtractFn
extends ETScalarFn {
    private static final Map<String, Pair<Integer, Integer>> s_fieldMap;
    private static final Pair<Integer, Integer> s_secondWithoutFractionFieldAndOffset;
    private final FieldGetter m_fieldGetter;

    public ETExtractFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        this.m_fieldGetter = ETExtractFn.createFieldGetter((ETConstant)list.get(0), list2.get(0), list2.get(1), this.getResultMetadata());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(1);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            this.m_fieldGetter.retrieveData(iSqlDataWrapper.getJavaUtilDate(), eTDataRequest.getData());
        }
        return false;
    }

    private static FieldGetter createFieldGetter(ETConstant eTConstant, IColumn iColumn, IColumn iColumn2, IColumn iColumn3) throws ErrorException {
        ETDataRequest eTDataRequest = new ETDataRequest(iColumn);
        eTConstant.retrieveData(eTDataRequest);
        String string = eTDataRequest.getData().getChar();
        if (s_fieldMap.containsKey(string)) {
            return new IntegerFieldGetter(string);
        }
        if (string.equalsIgnoreCase("YEAR")) {
            return new YearGetter();
        }
        if (string.equalsIgnoreCase("QUARTER")) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("QUARTER field for EXTRACT scalar function");
        }
        if (string.equalsIgnoreCase("SECOND")) {
            if (!iColumn3.getTypeMetadata().isExactNumericType()) {
                return new IntegerFieldGetter(s_secondWithoutFractionFieldAndOffset);
            }
            if (iColumn2.getTypeMetadata().getType() == 92) {
                return new SecondsFromTimeGetter();
            }
            assert (iColumn2.getTypeMetadata().getType() == 93);
            return new SecondsFromTimestampGetter();
        }
        throw new RuntimeException(String.format("Invalid field type \"%s\", should be prevented by parser", string));
    }

    static {
        s_secondWithoutFractionFieldAndOffset = new Pair<Integer, Integer>(13, 0);
        TreeMap<String, Pair<Integer, Integer>> treeMap = new TreeMap<String, Pair<Integer, Integer>>(String.CASE_INSENSITIVE_ORDER);
        treeMap.put("MONTH", new Pair<Integer, Integer>(2, 1));
        treeMap.put("DAY", new Pair<Integer, Integer>(5, 0));
        treeMap.put("HOUR", new Pair<Integer, Integer>(11, 0));
        treeMap.put("MINUTE", new Pair<Integer, Integer>(12, 0));
        treeMap.put("WEEK", new Pair<Integer, Integer>(3, 0));
        treeMap.put("DAYOFWEEK", new Pair<Integer, Integer>(7, 0));
        s_fieldMap = Collections.unmodifiableMap(treeMap);
    }

    private static class SecondsFromTimeGetter
    extends FieldGetter {
        private SecondsFromTimeGetter() {
        }

        @Override
        public void retrieveData(Date date, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
            Calendar calendar = this.getCalendar(date);
            int n = calendar.get(13);
            int n2 = calendar.get(14);
            iSqlDataWrapper.setExactNumber(BigDecimal.valueOf(n).add(BigDecimal.valueOf(n2, 3)));
        }
    }

    private static class SecondsFromTimestampGetter
    extends FieldGetter {
        private SecondsFromTimestampGetter() {
        }

        @Override
        public void retrieveData(Date date, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
            int n = this.getCalendar(date).get(13);
            int n2 = ((Timestamp)date).getNanos();
            iSqlDataWrapper.setExactNumber(BigDecimal.valueOf(n).add(BigDecimal.valueOf(n2, 9)));
        }
    }

    private static class YearGetter
    extends FieldGetter {
        private YearGetter() {
        }

        @Override
        public void retrieveData(Date date, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
            Calendar calendar = this.getCalendar(date);
            int n = calendar.get(1);
            boolean bl = calendar.get(0) == 1;
            iSqlDataWrapper.setInteger(bl ? (long)n : (long)(-n));
        }
    }

    private static class IntegerFieldGetter
    extends FieldGetter {
        private final int m_field;
        private final int m_offset;

        public IntegerFieldGetter(String string) {
            this((Pair)s_fieldMap.get(string));
        }

        public IntegerFieldGetter(Pair<Integer, Integer> pair) {
            this.m_field = pair.key();
            this.m_offset = pair.value();
        }

        @Override
        public void retrieveData(Date date, ISqlDataWrapper iSqlDataWrapper) throws ErrorException {
            iSqlDataWrapper.setInteger(this.getCalendar(date).get(this.m_field) + this.m_offset);
        }
    }

    private static abstract class FieldGetter {
        private final Calendar m_calendar = new GregorianCalendar();

        private FieldGetter() {
        }

        public abstract void retrieveData(Date var1, ISqlDataWrapper var2) throws ErrorException;

        protected final Calendar getCalendar(Date date) {
            this.m_calendar.setTimeInMillis(date.getTime());
            return this.m_calendar;
        }
    }
}

