/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.parser.parsetree;

import com.cloudera.hiveserver2.sqlengine.parser.parsetree.AbstractPTNonterminalNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver2.sqlengine.parser.parsetree.IPTVisitor;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class PTWalker {
    public static void walkBreadthFirst(IPTNode iPTNode, IPTVisitor<Void> iPTVisitor) throws ErrorException {
        if (null == iPTNode) {
            throw new NullPointerException("The tree cannot be null.");
        }
        LinkedList<IPTNode> linkedList = new LinkedList<IPTNode>();
        linkedList.add(iPTNode);
        while (!linkedList.isEmpty()) {
            IPTNode iPTNode2 = (IPTNode)linkedList.remove();
            iPTNode2.acceptVisitor(iPTVisitor);
            if (iPTNode2.isTerminalNode()) continue;
            Iterator<IPTNode> iterator = ((AbstractPTNonterminalNode)iPTNode2).getChildItr();
            while (iterator.hasNext()) {
                IPTNode iPTNode3 = iterator.next();
                if (null == iPTNode3) {
                    throw new NullPointerException("Tree nodes cannot be null.");
                }
                linkedList.add(iPTNode3);
            }
        }
    }

    public static void walkPreorderDepthFirst(IPTNode iPTNode, IPTVisitor<Void> iPTVisitor) throws ErrorException {
        if (null == iPTNode) {
            throw new NullPointerException("The tree cannot be null.");
        }
        Stack<IPTNode> stack = new Stack<IPTNode>();
        stack.push(iPTNode);
        while (!stack.empty()) {
            IPTNode iPTNode2 = (IPTNode)stack.pop();
            iPTNode2.acceptVisitor(iPTVisitor);
            if (iPTNode2.isTerminalNode()) continue;
            Iterator<IPTNode> iterator = ((AbstractPTNonterminalNode)iPTNode2).getChildItr();
            ArrayList<IPTNode> arrayList = new ArrayList<IPTNode>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                IPTNode iPTNode3 = (IPTNode)arrayList.get(i);
                if (null == iPTNode3) {
                    throw new NullPointerException("Tree nodes cannot be null.");
                }
                stack.push(iPTNode3);
            }
        }
    }
}

