/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper;

import com.cloudera.hive.jdbc42.internal.apache.yetus.audience.InterfaceAudience;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.AsyncCallback;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.CreateMode;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Op;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.OpResult;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ZooKeeper;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.data.ACL;
import java.util.ArrayList;
import java.util.List;

@InterfaceAudience.Public
public class Transaction {
    private ZooKeeper zk;
    private List<Op> ops = new ArrayList<Op>();

    protected Transaction(ZooKeeper zk) {
        this.zk = zk;
    }

    public Transaction create(String path, byte[] data, List<ACL> acl, CreateMode createMode) {
        this.ops.add(Op.create(path, data, acl, createMode.toFlag()));
        return this;
    }

    public Transaction delete(String path, int version) {
        this.ops.add(Op.delete(path, version));
        return this;
    }

    public Transaction check(String path, int version) {
        this.ops.add(Op.check(path, version));
        return this;
    }

    public Transaction setData(String path, byte[] data, int version) {
        this.ops.add(Op.setData(path, data, version));
        return this;
    }

    public List<OpResult> commit() throws InterruptedException, KeeperException {
        return this.zk.multi(this.ops);
    }

    public void commit(AsyncCallback.MultiCallback cb, Object ctx) {
        this.zk.multi(this.ops, cb, ctx);
    }
}

