/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ClientCnxn;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Testable;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.WatchedEvent;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.Watcher;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.ZooKeeper;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.IOException;

class ZooKeeperTestable
implements Testable {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperTestable.class);
    private final ClientCnxn clientCnxn;

    ZooKeeperTestable(ClientCnxn clientCnxn) {
        this.clientCnxn = clientCnxn;
    }

    @Override
    public void injectSessionExpiration() {
        LOG.info("injectSessionExpiration() called");
        this.clientCnxn.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.clientCnxn.eventThread.queueEventOfDeath();
        this.clientCnxn.state = ZooKeeper.States.CLOSED;
        this.clientCnxn.sendThread.getClientCnxnSocket().onClosing();
    }

    @Override
    public void queueEvent(WatchedEvent event) {
        LOG.info("queueEvent() called: {}", (Object)event);
        this.clientCnxn.eventThread.queueEvent(event);
    }

    @Override
    public void closeSocket() throws IOException {
        LOG.info("closeSocket() called");
        this.clientCnxn.sendThread.testableCloseSocket();
    }
}

