/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli;

import com.cloudera.hive.jdbc42.internal.apache.commons.cli.CommandLine;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.DefaultParser;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.Options;
import com.cloudera.hive.jdbc42.internal.apache.commons.cli.ParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.KeeperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliCommand;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliParseException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.CliWrapperException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedCommandException;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.cli.MalformedPathException;

public class GetAllChildrenNumberCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetAllChildrenNumberCommand() {
        super("getAllChildrenNumber", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        try {
            String path = this.args[1];
            int allChildrenNumber = this.zk.getAllChildrenNumber(path);
            this.out.println(allChildrenNumber);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

