/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.common;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.BCFKSFileLoader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.FileKeyStoreLoader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.JKSFileLoader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.KeyStoreFileType;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.PEMFileLoader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.common.PKCS12FileLoader;
import java.util.Objects;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
            case PKCS12: {
                return new PKCS12FileLoader.Builder();
            }
            case BCFKS: {
                return new BCFKSFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

