/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin.AdminServer;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin.DummyAdminServer;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.lang.reflect.InvocationTargetException;

public class AdminServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServerFactory.class);

    public static AdminServer createAdminServer() {
        if (!"false".equals(System.getProperty("zookeeper.admin.enableServer"))) {
            try {
                Class<?> jettyAdminServerC = Class.forName("com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.admin.JettyAdminServer");
                Object adminServer = jettyAdminServerC.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (AdminServer)adminServer;
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Unable to start JettyAdminServer", e);
            }
            catch (InstantiationException e) {
                LOG.warn("Unable to start JettyAdminServer", e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Unable to start JettyAdminServer", e);
            }
            catch (InvocationTargetException e) {
                LOG.warn("Unable to start JettyAdminServer", e);
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Unable to start JettyAdminServer", e);
            }
            catch (NoClassDefFoundError e) {
                LOG.warn("Unable to load jetty, not starting JettyAdminServer", e);
            }
        }
        return new DummyAdminServer();
    }
}

