/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ServerMetrics;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.Leader;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.QuorumPeer;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    @Override
    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            request.logLatency(ServerMetrics.getMetrics().PROPOSAL_ACK_CREATION_LATENCY);
            this.leader.processAck(self.getMyId(), request.zxid, null);
        } else {
            LOG.error("Null QuorumPeer");
        }
    }

    @Override
    public void shutdown() {
    }
}

