/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum;

import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.Request;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.ServerMetrics;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.Learner;
import com.cloudera.hive.jdbc42.internal.apache.zookeeper.server.quorum.QuorumPacket;
import com.cloudera.hive.jdbc42.internal.slf4j.Logger;
import com.cloudera.hive.jdbc42.internal.slf4j.LoggerFactory;
import java.io.Flushable;
import java.io.IOException;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner peer) {
        this.learner = peer;
    }

    @Override
    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.getHdr().getZxid(), null, null);
            try {
                si.logLatency(ServerMetrics.getMetrics().PROPOSAL_ACK_CREATION_LATENCY);
                this.learner.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn("Closing connection to leader, exception during packet send", e);
                this.learner.closeSocket();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn("Closing connection to leader, exception during packet send", e);
            this.learner.closeSocket();
        }
    }

    @Override
    public void shutdown() {
    }
}

