/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.base64;

import com.cloudera.hive.jdbc42.internal.io.netty.buffer.ByteBuf;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandler;
import com.cloudera.hive.jdbc42.internal.io.netty.channel.ChannelHandlerContext;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.MessageToMessageEncoder;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.base64.Base64;
import com.cloudera.hive.jdbc42.internal.io.netty.handler.codec.base64.Base64Dialect;
import com.cloudera.hive.jdbc42.internal.io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = (Base64Dialect)((Object)ObjectUtil.checkNotNull((Object)((Object)dialect), (String)"dialect"));
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

